/*
 * Decompiled with CFR 0.152.
 */
package org.kududb.client.shaded.org.jboss.netty.handler.codec.http;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.kududb.client.shaded.org.jboss.netty.buffer.ChannelBuffer;
import org.kududb.client.shaded.org.jboss.netty.buffer.ChannelBuffers;
import org.kududb.client.shaded.org.jboss.netty.handler.codec.http.DefaultHttpHeaders;
import org.kududb.client.shaded.org.jboss.netty.handler.codec.http.HttpCodecUtil;
import org.kududb.client.shaded.org.jboss.netty.handler.codec.http.HttpHeaders;
import org.kududb.client.shaded.org.jboss.netty.handler.codec.http.HttpMessage;
import org.kududb.client.shaded.org.jboss.netty.handler.codec.http.HttpVersion;
import org.kududb.client.shaded.org.jboss.netty.util.internal.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultHttpMessage
implements HttpMessage {
    private final HttpHeaders headers = new DefaultHttpHeaders(true);
    private HttpVersion version;
    private ChannelBuffer content = ChannelBuffers.EMPTY_BUFFER;
    private boolean chunked;

    protected DefaultHttpMessage(HttpVersion version) {
        this.setProtocolVersion(version);
    }

    @Override
    public HttpHeaders headers() {
        return this.headers;
    }

    @Override
    @Deprecated
    public void addHeader(String name, Object value) {
        this.headers.add(name, value);
    }

    @Override
    @Deprecated
    public void setHeader(String name, Object value) {
        this.headers.set(name, value);
    }

    @Override
    @Deprecated
    public void setHeader(String name, Iterable<?> values) {
        this.headers.set(name, values);
    }

    @Override
    @Deprecated
    public void removeHeader(String name) {
        this.headers.remove(name);
    }

    @Override
    public boolean isChunked() {
        if (this.chunked) {
            return true;
        }
        return HttpCodecUtil.isTransferEncodingChunked(this);
    }

    @Override
    public void setChunked(boolean chunked) {
        this.chunked = chunked;
        if (chunked) {
            this.setContent(ChannelBuffers.EMPTY_BUFFER);
        }
    }

    @Override
    @Deprecated
    public void clearHeaders() {
        this.headers.clear();
    }

    @Override
    public void setContent(ChannelBuffer content) {
        if (content == null) {
            content = ChannelBuffers.EMPTY_BUFFER;
        }
        if (content.readable() && this.isChunked()) {
            throw new IllegalArgumentException("non-empty content disallowed if this.chunked == true");
        }
        this.content = content;
    }

    @Override
    @Deprecated
    public String getHeader(String name) {
        return this.headers.get(name);
    }

    @Override
    @Deprecated
    public List<String> getHeaders(String name) {
        return this.headers.getAll(name);
    }

    @Override
    @Deprecated
    public List<Map.Entry<String, String>> getHeaders() {
        return this.headers.entries();
    }

    @Override
    @Deprecated
    public boolean containsHeader(String name) {
        return this.headers.contains(name);
    }

    @Override
    @Deprecated
    public Set<String> getHeaderNames() {
        return this.headers.names();
    }

    @Override
    public HttpVersion getProtocolVersion() {
        return this.version;
    }

    @Override
    public void setProtocolVersion(HttpVersion version) {
        if (version == null) {
            throw new NullPointerException("version");
        }
        this.version = version;
    }

    @Override
    public ChannelBuffer getContent() {
        return this.content;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getClass().getSimpleName());
        buf.append("(version: ");
        buf.append(this.getProtocolVersion().getText());
        buf.append(", keepAlive: ");
        buf.append(HttpHeaders.isKeepAlive(this));
        buf.append(", chunked: ");
        buf.append(this.isChunked());
        buf.append(')');
        buf.append(StringUtil.NEWLINE);
        this.appendHeaders(buf);
        buf.setLength(buf.length() - StringUtil.NEWLINE.length());
        return buf.toString();
    }

    void appendHeaders(StringBuilder buf) {
        for (Map.Entry e : this.headers()) {
            buf.append((String)e.getKey());
            buf.append(": ");
            buf.append((String)e.getValue());
            buf.append(StringUtil.NEWLINE);
        }
    }
}

