/*
 * Decompiled with CFR 0.152.
 */
package org.kududb.client.shaded.org.jboss.netty.channel.socket.oio;

import java.net.SocketAddress;
import java.util.concurrent.Executor;
import org.kududb.client.shaded.org.jboss.netty.channel.ChannelEvent;
import org.kududb.client.shaded.org.jboss.netty.channel.ChannelFuture;
import org.kududb.client.shaded.org.jboss.netty.channel.ChannelFutureListener;
import org.kududb.client.shaded.org.jboss.netty.channel.ChannelPipeline;
import org.kududb.client.shaded.org.jboss.netty.channel.ChannelState;
import org.kududb.client.shaded.org.jboss.netty.channel.ChannelStateEvent;
import org.kududb.client.shaded.org.jboss.netty.channel.Channels;
import org.kududb.client.shaded.org.jboss.netty.channel.MessageEvent;
import org.kududb.client.shaded.org.jboss.netty.channel.socket.oio.AbstractOioChannelSink;
import org.kududb.client.shaded.org.jboss.netty.channel.socket.oio.AbstractOioWorker;
import org.kududb.client.shaded.org.jboss.netty.channel.socket.oio.OioDatagramChannel;
import org.kududb.client.shaded.org.jboss.netty.channel.socket.oio.OioDatagramWorker;
import org.kududb.client.shaded.org.jboss.netty.util.ThreadNameDeterminer;
import org.kududb.client.shaded.org.jboss.netty.util.ThreadRenamingRunnable;
import org.kududb.client.shaded.org.jboss.netty.util.internal.DeadLockProofWorker;

class OioDatagramPipelineSink
extends AbstractOioChannelSink {
    private final Executor workerExecutor;
    private final ThreadNameDeterminer determiner;

    OioDatagramPipelineSink(Executor workerExecutor, ThreadNameDeterminer determiner) {
        this.workerExecutor = workerExecutor;
        this.determiner = determiner;
    }

    public void eventSunk(ChannelPipeline pipeline, ChannelEvent e) throws Exception {
        OioDatagramChannel channel = (OioDatagramChannel)e.getChannel();
        ChannelFuture future = e.getFuture();
        if (e instanceof ChannelStateEvent) {
            ChannelStateEvent stateEvent = (ChannelStateEvent)e;
            ChannelState state = stateEvent.getState();
            Object value = stateEvent.getValue();
            switch (state) {
                case OPEN: {
                    if (!Boolean.FALSE.equals(value)) break;
                    AbstractOioWorker.close(channel, future);
                    break;
                }
                case BOUND: {
                    if (value != null) {
                        this.bind(channel, future, (SocketAddress)value);
                        break;
                    }
                    AbstractOioWorker.close(channel, future);
                    break;
                }
                case CONNECTED: {
                    if (value != null) {
                        this.connect(channel, future, (SocketAddress)value);
                        break;
                    }
                    OioDatagramWorker.disconnect(channel, future);
                    break;
                }
                case INTEREST_OPS: {
                    AbstractOioWorker.setInterestOps(channel, future, (Integer)value);
                }
            }
        } else if (e instanceof MessageEvent) {
            MessageEvent evt = (MessageEvent)e;
            OioDatagramWorker.write(channel, future, evt.getMessage(), evt.getRemoteAddress());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void bind(OioDatagramChannel channel, ChannelFuture future, SocketAddress localAddress) {
        boolean bound = false;
        boolean workerStarted = false;
        try {
            try {
                channel.socket.bind(localAddress);
                bound = true;
                future.setSuccess();
                Channels.fireChannelBound(channel, (SocketAddress)channel.getLocalAddress());
                DeadLockProofWorker.start(this.workerExecutor, new ThreadRenamingRunnable(new OioDatagramWorker(channel), "Old I/O datagram worker (" + channel + ')', this.determiner));
                workerStarted = true;
            }
            catch (Throwable t) {
                future.setFailure(t);
                Channels.fireExceptionCaught(channel, t);
                Object var8_7 = null;
                if (!bound) return;
                if (workerStarted) return;
                AbstractOioWorker.close(channel, future);
                return;
            }
            Object var8_6 = null;
            if (!bound) return;
            if (workerStarted) return;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (!bound) throw throwable;
            if (workerStarted) throw throwable;
            AbstractOioWorker.close(channel, future);
            throw throwable;
        }
        AbstractOioWorker.close(channel, future);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void connect(OioDatagramChannel channel, ChannelFuture future, SocketAddress remoteAddress) {
        boolean bound = channel.isBound();
        boolean connected = false;
        boolean workerStarted = false;
        future.addListener(ChannelFutureListener.CLOSE_ON_FAILURE);
        channel.remoteAddress = null;
        try {
            try {
                channel.socket.connect(remoteAddress);
                connected = true;
                future.setSuccess();
                if (!bound) {
                    Channels.fireChannelBound(channel, (SocketAddress)channel.getLocalAddress());
                }
                Channels.fireChannelConnected(channel, (SocketAddress)channel.getRemoteAddress());
                String threadName = "Old I/O datagram worker (" + channel + ')';
                if (!bound) {
                    DeadLockProofWorker.start(this.workerExecutor, new ThreadRenamingRunnable(new OioDatagramWorker(channel), threadName, this.determiner));
                } else {
                    Thread workerThread = channel.workerThread;
                    if (workerThread != null) {
                        try {
                            workerThread.setName(threadName);
                        }
                        catch (SecurityException e) {
                            // empty catch block
                        }
                    }
                }
                workerStarted = true;
            }
            catch (Throwable t) {
                future.setFailure(t);
                Channels.fireExceptionCaught(channel, t);
                Object var11_12 = null;
                if (!connected) return;
                if (workerStarted) return;
                AbstractOioWorker.close(channel, future);
                return;
            }
            Object var11_11 = null;
            if (!connected) return;
            if (workerStarted) return;
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            if (!connected) throw throwable;
            if (workerStarted) throw throwable;
            AbstractOioWorker.close(channel, future);
            throw throwable;
        }
        AbstractOioWorker.close(channel, future);
    }
}

