/*
 * Decompiled with CFR 0.152.
 */
package org.kududb.client.shaded.com.google.common.hash;

import java.nio.charset.Charset;
import org.kududb.client.shaded.com.google.common.base.Charsets;
import org.kududb.client.shaded.com.google.common.hash.Hasher;

abstract class AbstractHasher
implements Hasher {
    AbstractHasher() {
    }

    @Override
    public final Hasher putBoolean(boolean b) {
        return this.putByte(b ? (byte)1 : 0);
    }

    @Override
    public final Hasher putDouble(double d) {
        return this.putLong(Double.doubleToRawLongBits(d));
    }

    @Override
    public final Hasher putFloat(float f) {
        return this.putInt(Float.floatToRawIntBits(f));
    }

    @Override
    public Hasher putString(CharSequence charSequence) {
        return this.putString(charSequence, Charsets.UTF_16LE);
    }

    @Override
    public Hasher putString(CharSequence charSequence, Charset charset) {
        return this.putBytes(((Object)charSequence).toString().getBytes(charset));
    }
}

