/*
 * Decompiled with CFR 0.152.
 */
package org.kududb.client;

import com.stumbleupon.async.Deferred;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import javax.security.sasl.SaslException;
import org.kududb.WireProtocol;
import org.kududb.annotations.InterfaceAudience;
import org.kududb.client.AsyncKuduClient;
import org.kududb.client.Bytes;
import org.kududb.client.CallResponse;
import org.kududb.client.ConnectionResetException;
import org.kududb.client.GetMasterRegistrationRequest;
import org.kududb.client.KuduRpc;
import org.kududb.client.MasterErrorException;
import org.kududb.client.NonRecoverableException;
import org.kududb.client.SecureRpcHelper;
import org.kududb.client.TabletServerErrorException;
import org.kududb.client.shaded.com.google.protobuf.GeneratedMessage;
import org.kududb.client.shaded.org.jboss.netty.buffer.ChannelBuffer;
import org.kududb.client.shaded.org.jboss.netty.buffer.ChannelBuffers;
import org.kududb.client.shaded.org.jboss.netty.channel.Channel;
import org.kududb.client.shaded.org.jboss.netty.channel.ChannelEvent;
import org.kududb.client.shaded.org.jboss.netty.channel.ChannelFuture;
import org.kududb.client.shaded.org.jboss.netty.channel.ChannelFutureListener;
import org.kududb.client.shaded.org.jboss.netty.channel.ChannelHandlerContext;
import org.kududb.client.shaded.org.jboss.netty.channel.ChannelStateEvent;
import org.kududb.client.shaded.org.jboss.netty.channel.Channels;
import org.kududb.client.shaded.org.jboss.netty.channel.ExceptionEvent;
import org.kududb.client.shaded.org.jboss.netty.handler.codec.replay.ReplayingDecoder;
import org.kududb.client.shaded.org.jboss.netty.handler.codec.replay.VoidEnum;
import org.kududb.client.shaded.org.jboss.netty.handler.timeout.ReadTimeoutException;
import org.kududb.master.Master;
import org.kududb.rpc.RpcHeader;
import org.kududb.tserver.Tserver;
import org.kududb.util.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class TabletClient
extends ReplayingDecoder<VoidEnum> {
    public static final Logger LOG = LoggerFactory.getLogger(TabletClient.class);
    private ArrayList<KuduRpc<?>> pending_rpcs;
    public static final byte RPC_CURRENT_VERSION = 9;
    private static final byte[] RPC_HEADER = new byte[]{104, 114, 112, 99, 9, 0, 0};
    public static final int CONNECTION_CTX_CALL_ID = -3;
    private final AtomicInteger rpcid = new AtomicInteger(-1);
    private volatile Channel chan;
    private boolean dead = false;
    private final ConcurrentHashMap<Integer, KuduRpc<?>> rpcs_inflight = new ConcurrentHashMap();
    private final AsyncKuduClient kuduClient;
    private final String uuid;
    private final long socketReadTimeoutMs;
    private SecureRpcHelper secureRpcHelper;

    public TabletClient(AsyncKuduClient client, String uuid) {
        this.kuduClient = client;
        this.uuid = uuid;
        this.socketReadTimeoutMs = client.getDefaultSocketReadTimeoutMs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <R> void sendRpc(KuduRpc<R> rpc) {
        boolean copyOfDead;
        if (!rpc.deadlineTracker.hasDeadline()) {
            LOG.warn(this.getPeerUuidLoggingString() + " sending an rpc without a timeout " + rpc);
        }
        if (this.chan != null) {
            ChannelBuffer serialized = this.encode(rpc);
            if (serialized == null) {
                return;
            }
            Channel chan = this.chan;
            if (chan != null) {
                Channels.write(chan, serialized);
                return;
            }
        }
        boolean tryagain = false;
        TabletClient tabletClient = this;
        synchronized (tabletClient) {
            copyOfDead = this.dead;
            if (this.chan != null) {
                tryagain = true;
            } else if (!copyOfDead) {
                if (this.pending_rpcs == null) {
                    this.pending_rpcs = new ArrayList();
                }
                this.pending_rpcs.add(rpc);
            }
        }
        if (copyOfDead) {
            this.failOrRetryRpc(rpc, new ConnectionResetException(null));
            return;
        }
        if (tryagain) {
            this.sendRpc(rpc);
            return;
        }
    }

    private <R> ChannelBuffer encode(KuduRpc<R> rpc) {
        ChannelBuffer payload;
        int rpcid = this.rpcid.incrementAndGet();
        String service = rpc.serviceName();
        String method = rpc.method();
        try {
            RpcHeader.RequestHeader.Builder headerBuilder = RpcHeader.RequestHeader.newBuilder().setCallId(rpcid).setRemoteMethod(RpcHeader.RemoteMethodPB.newBuilder().setServiceName(service).setMethodName(method));
            if (rpc.deadlineTracker.hasDeadline() || this.socketReadTimeoutMs > 0L) {
                long millisBeforeDeadline = Long.MAX_VALUE;
                if (rpc.deadlineTracker.hasDeadline()) {
                    millisBeforeDeadline = rpc.deadlineTracker.getMillisBeforeDeadline();
                }
                long localRpcTimeoutMs = Long.MAX_VALUE;
                if (this.socketReadTimeoutMs > 0L) {
                    localRpcTimeoutMs = this.socketReadTimeoutMs;
                }
                headerBuilder.setTimeoutMillis((int)Math.min(millisBeforeDeadline, localRpcTimeoutMs));
            }
            payload = rpc.serialize(headerBuilder.build());
        }
        catch (Exception e) {
            LOG.error("Uncaught exception while serializing RPC: " + rpc, (Throwable)e);
            rpc.errback(e);
            return null;
        }
        KuduRpc<R> oldrpc = this.rpcs_inflight.put(rpcid, rpc);
        if (oldrpc != null) {
            String wtf = this.getPeerUuidLoggingString() + "WTF?  There was already an RPC in flight with" + " rpcid=" + rpcid + ": " + oldrpc + ".  This happened when sending out: " + rpc;
            LOG.error(wtf);
            oldrpc.errback(new NonRecoverableException(wtf));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(this.getPeerUuidLoggingString() + this.chan + " Sending RPC #" + rpcid + ", payload=" + payload + ' ' + Bytes.pretty(payload));
        }
        payload = this.secureRpcHelper.wrap(payload);
        return payload;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Deferred<Void> shutdown() {
        Object ite = this.rpcs_inflight.values().iterator();
        while (ite.hasNext()) {
            KuduRpc<?> rpc = ite.next();
            rpc.errback(new ConnectionResetException(null));
            ite.remove();
        }
        ite = this;
        synchronized (ite) {
            if (this.pending_rpcs != null) {
                Iterator<KuduRpc<?>> ite2 = this.pending_rpcs.iterator();
                while (ite2.hasNext()) {
                    ite2.next().errback(new ConnectionResetException(null));
                    ite2.remove();
                }
            }
        }
        Channel chancopy = this.chan;
        if (chancopy == null) {
            return Deferred.fromResult(null);
        }
        if (chancopy.isConnected()) {
            Channels.disconnect(chancopy);
        }
        if (chancopy.isBound()) {
            Channels.unbind(chancopy);
        }
        ChannelFuture future = Channels.close(chancopy);
        final Deferred d = new Deferred();
        if (future.isSuccess()) {
            d.callback(null);
        } else {
            future.addListener(new ChannelFutureListener(){

                @Override
                public void operationComplete(ChannelFuture future) {
                    if (future.isSuccess()) {
                        d.callback(null);
                        return;
                    }
                    Throwable t = future.getCause();
                    if (t instanceof Exception) {
                        d.callback((Object)t);
                    } else {
                        d.callback((Object)new NonRecoverableException("Failed to shutdown: " + TabletClient.this, t));
                    }
                }
            });
        }
        return d;
    }

    @Override
    protected Object decode(ChannelHandlerContext ctx, Channel chan, ChannelBuffer buf, VoidEnum voidEnum) {
        KuduRpc<?> removed;
        long start = System.nanoTime();
        int rdx = buf.readerIndex();
        LOG.debug("------------------>> ENTERING DECODE >>------------------");
        try {
            buf = this.secureRpcHelper.handleResponse(buf, chan);
        }
        catch (SaslException e) {
            String message = this.getPeerUuidLoggingString() + "Couldn't complete the SASL handshake";
            LOG.error(message);
            throw new NonRecoverableException(message, e);
        }
        if (buf == null) {
            return null;
        }
        CallResponse response = new CallResponse(buf);
        RpcHeader.ResponseHeader header = response.getHeader();
        if (!header.hasCallId()) {
            int size = response.getTotalResponseSize();
            String msg = this.getPeerUuidLoggingString() + "RPC response (size: " + size + ") doesn't" + " have a call ID: " + header + ", buf=" + Bytes.pretty(buf);
            LOG.error(msg);
            throw new NonRecoverableException(msg);
        }
        int rpcid = header.getCallId();
        KuduRpc<?> rpc = this.rpcs_inflight.get(rpcid);
        if (rpc == null) {
            String msg = this.getPeerUuidLoggingString() + "Invalid rpcid: " + rpcid + " found in " + buf + '=' + Bytes.pretty(buf);
            LOG.error(msg);
            throw new NonRecoverableException(msg);
        }
        Pair<?, Object> decoded = null;
        Exception exception = null;
        TabletServerErrorException retryableHeaderException = null;
        if (header.hasIsError() && header.getIsError()) {
            RpcHeader.ErrorStatusPB.Builder errorBuilder = RpcHeader.ErrorStatusPB.newBuilder();
            KuduRpc.readProtobuf(response.getPBMessage(), errorBuilder);
            RpcHeader.ErrorStatusPB error = errorBuilder.build();
            if (error.getCode().equals(RpcHeader.ErrorStatusPB.RpcErrorCodePB.ERROR_SERVER_TOO_BUSY)) {
                retryableHeaderException = new TabletServerErrorException(this.uuid, error);
            } else {
                String message = this.getPeerUuidLoggingString() + "Tablet server sent error " + error.getMessage();
                exception = new NonRecoverableException(message);
                LOG.error(message);
            }
        } else {
            try {
                decoded = rpc.deserialize(response, this.uuid);
            }
            catch (Exception ex) {
                exception = ex;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(this.getPeerUuidLoggingString() + "rpcid=" + rpcid + ", response size=" + (buf.readerIndex() - rdx) + " bytes" + ", " + this.actualReadableBytes() + " readable bytes left" + ", rpc=" + rpc);
        }
        if ((removed = this.rpcs_inflight.remove(rpcid)) == null) {
            throw new NonRecoverableException("RPC not found");
        }
        if (retryableHeaderException != null) {
            this.kuduClient.handleRetryableError(rpc, retryableHeaderException);
            return null;
        }
        if (decoded != null) {
            GeneratedMessage error;
            if (decoded.getSecond() instanceof Tserver.TabletServerErrorPB) {
                error = (Tserver.TabletServerErrorPB)decoded.getSecond();
                exception = this.dispatchTSErrorOrReturnException(rpc, (Tserver.TabletServerErrorPB)error);
                if (exception == null) {
                    return null;
                }
                decoded = null;
            } else if (decoded.getSecond() instanceof Master.MasterErrorPB) {
                error = (Master.MasterErrorPB)decoded.getSecond();
                exception = this.dispatchMasterErrorOrReturnException(rpc, (Master.MasterErrorPB)error);
                if (exception == null) {
                    return null;
                }
                decoded = null;
            }
        }
        try {
            if (decoded != null) {
                assert (!(decoded.getFirst() instanceof Exception));
                rpc.callback(decoded.getFirst());
            } else {
                rpc.errback(exception);
            }
        }
        catch (Exception e) {
            LOG.debug(this.getPeerUuidLoggingString() + "Unexpected exception while handling RPC #" + rpcid + ", rpc=" + rpc + ", buf=" + Bytes.pretty(buf), (Throwable)e);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("------------------<< LEAVING  DECODE <<------------------ time elapsed: " + (System.nanoTime() - start) / 1000L + "us");
        }
        return null;
    }

    private Exception dispatchTSErrorOrReturnException(KuduRpc rpc, Tserver.TabletServerErrorPB error) {
        WireProtocol.AppStatusPB.ErrorCode code = error.getStatus().getCode();
        TabletServerErrorException ex = new TabletServerErrorException(this.uuid, error.getStatus());
        if (error.getCode() == Tserver.TabletServerErrorPB.Code.TABLET_NOT_FOUND) {
            this.kuduClient.handleTabletNotFound(rpc, ex, this);
        } else if (code == WireProtocol.AppStatusPB.ErrorCode.SERVICE_UNAVAILABLE) {
            this.kuduClient.handleRetryableError(rpc, ex);
        } else if (code == WireProtocol.AppStatusPB.ErrorCode.ILLEGAL_STATE || code == WireProtocol.AppStatusPB.ErrorCode.ABORTED) {
            this.kuduClient.handleNotLeader(rpc, ex, this);
        } else {
            return ex;
        }
        return null;
    }

    private Exception dispatchMasterErrorOrReturnException(KuduRpc rpc, Master.MasterErrorPB error) {
        WireProtocol.AppStatusPB.ErrorCode code = error.getStatus().getCode();
        MasterErrorException ex = new MasterErrorException(this.uuid, error);
        if (error.getCode() == Master.MasterErrorPB.Code.NOT_THE_LEADER) {
            this.kuduClient.handleNotLeader(rpc, ex, this);
        } else if (code == WireProtocol.AppStatusPB.ErrorCode.SERVICE_UNAVAILABLE && !(rpc instanceof GetMasterRegistrationRequest)) {
            this.kuduClient.handleRetryableError(rpc, ex);
        } else {
            return ex;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object decodeLast(ChannelHandlerContext ctx, Channel chan, ChannelBuffer buf, VoidEnum unused) {
        if (buf.readable()) {
            try {
                Object object = this.decode(ctx, chan, buf, unused);
                return object;
            }
            finally {
                if (buf.readable()) {
                    LOG.error(this.getPeerUuidLoggingString() + "After decoding the last message on " + chan + ", there was still some undecoded bytes in the channel's" + " buffer (which are going to be lost): " + buf + '=' + Bytes.pretty(buf));
                }
            }
        }
        return null;
    }

    public boolean isAlive() {
        return !this.dead;
    }

    static void ensureReadable(ChannelBuffer buf, int nbytes) {
        buf.markReaderIndex();
        buf.skipBytes(nbytes);
        buf.resetReaderIndex();
    }

    @Override
    public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e) {
        Channel chan = e.getChannel();
        ChannelBuffer header = this.connectionHeaderPreamble();
        header.writerIndex(RPC_HEADER.length);
        Channels.write(chan, header);
        this.secureRpcHelper = new SecureRpcHelper(this);
        this.secureRpcHelper.sendHello(chan);
    }

    @Override
    public void handleUpstream(ChannelHandlerContext ctx, ChannelEvent e) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug(this.getPeerUuidLoggingString() + e.toString());
        }
        super.handleUpstream(ctx, e);
    }

    @Override
    public void channelDisconnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        this.chan = null;
        super.channelDisconnected(ctx, e);
        this.cleanup(e.getChannel());
    }

    @Override
    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) {
        this.chan = null;
        this.cleanup(e.getChannel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanup(Channel chan) {
        ArrayList<KuduRpc<?>> rpcs;
        ConnectionResetException exception = new ConnectionResetException(this.getPeerUuidLoggingString() + "Connection reset on " + chan);
        Iterator<KuduRpc<?>> ite = this.rpcs_inflight.values().iterator();
        while (ite.hasNext()) {
            KuduRpc<?> rpc = ite.next();
            this.failOrRetryRpc(rpc, exception);
            ite.remove();
        }
        TabletClient tabletClient = this;
        synchronized (tabletClient) {
            this.dead = true;
            rpcs = this.pending_rpcs;
            this.pending_rpcs = null;
        }
        if (rpcs != null) {
            this.failOrRetryRpcs(rpcs, exception);
        }
    }

    private void failOrRetryRpcs(Collection<KuduRpc<?>> rpcs, ConnectionResetException exception) {
        for (KuduRpc<?> rpc : rpcs) {
            this.failOrRetryRpc(rpc, exception);
        }
    }

    private void failOrRetryRpc(KuduRpc<?> rpc, ConnectionResetException exception) {
        AsyncKuduClient.RemoteTablet tablet = rpc.getTablet();
        if (tablet == null) {
            rpc.errback(exception);
        } else {
            this.kuduClient.handleTabletNotFound(rpc, exception, this);
        }
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent event) {
        Throwable e = event.getCause();
        Channel c = event.getChannel();
        if (e instanceof RejectedExecutionException) {
            LOG.warn(this.getPeerUuidLoggingString() + "RPC rejected by the executor," + " ignore this if we're shutting down", e);
        } else if (e instanceof ReadTimeoutException) {
            LOG.debug(this.getPeerUuidLoggingString() + "Encountered a read timeout");
            this.cleanup(c);
        } else {
            LOG.error(this.getPeerUuidLoggingString() + "Unexpected exception from downstream on " + c, e);
        }
        if (c.isOpen()) {
            Channels.close(c);
        } else {
            this.cleanup(c);
        }
    }

    private ChannelBuffer connectionHeaderPreamble() {
        return ChannelBuffers.wrappedBuffer(RPC_HEADER);
    }

    public void becomeReady(Channel chan) {
        this.chan = chan;
        this.sendQueuedRpcs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendQueuedRpcs() {
        ArrayList<KuduRpc<?>> rpcs;
        TabletClient tabletClient = this;
        synchronized (tabletClient) {
            rpcs = this.pending_rpcs;
            this.pending_rpcs = null;
        }
        if (rpcs != null) {
            for (KuduRpc<?> rpc : rpcs) {
                LOG.debug(this.getPeerUuidLoggingString() + "Executing RPC queued: " + rpc);
                this.sendRpc(rpc);
            }
        }
    }

    void sendContext(Channel channel) {
        Channels.write(channel, this.header());
        this.becomeReady(channel);
    }

    private ChannelBuffer header() {
        RpcHeader.ConnectionContextPB.Builder builder = RpcHeader.ConnectionContextPB.newBuilder();
        RpcHeader.UserInformationPB.Builder userBuilder = RpcHeader.UserInformationPB.newBuilder();
        userBuilder.setEffectiveUser("java_client");
        userBuilder.setRealUser("java_client");
        builder.setUserInfo(userBuilder.build());
        RpcHeader.ConnectionContextPB pb = builder.build();
        RpcHeader.RequestHeader header = RpcHeader.RequestHeader.newBuilder().setCallId(-3).build();
        return KuduRpc.toChannelBuffer(header, pb);
    }

    private String getPeerUuidLoggingString() {
        return "[Peer " + this.uuid + "] ";
    }

    String getUuid() {
        return this.uuid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        int npending_rpcs;
        StringBuilder buf = new StringBuilder(169);
        buf.append("TabletClient@").append(this.hashCode()).append("(chan=").append(this.chan).append(", uuid=").append(this.uuid).append(", #pending_rpcs=");
        TabletClient tabletClient = this;
        synchronized (tabletClient) {
            npending_rpcs = this.pending_rpcs == null ? 0 : this.pending_rpcs.size();
        }
        buf.append(npending_rpcs);
        buf.append(", #rpcs_inflight=").append(this.rpcs_inflight.size()).append(')');
        return buf.toString();
    }
}

