/*
 * Decompiled with CFR 0.152.
 */
package org.kududb.client;

import org.kududb.WireProtocol;
import org.kududb.annotations.InterfaceAudience;
import org.kududb.annotations.InterfaceStability;
import org.kududb.client.Bytes;
import org.kududb.client.Operation;
import org.kududb.tserver.Tserver;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class RowError {
    private final String status;
    private final String message;
    private final Operation operation;
    private final String tsUUID;

    private RowError(String errorStatus, String errorMessage, Operation operation, String tsUUID) {
        this.status = errorStatus;
        this.message = errorMessage;
        this.operation = operation;
        this.tsUUID = tsUUID;
    }

    public String getStatus() {
        return this.status;
    }

    public String getMessage() {
        return this.message;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public String getTsUUID() {
        return this.tsUUID;
    }

    public String toString() {
        return "Row error for primary key=" + Bytes.pretty(this.operation.getRow().encodePrimaryKey()) + ", tablet=" + this.operation.getTablet().getTabletIdAsString() + ", server=" + this.tsUUID + ", status=" + this.status + ", message=" + this.message;
    }

    static RowError fromRowErrorPb(Tserver.WriteResponsePB.PerRowErrorPB errorPB, Operation operation, String tsUUID) {
        WireProtocol.AppStatusPB statusPB = errorPB.getError();
        return new RowError(statusPB.getCode().toString(), statusPB.getMessage(), operation, tsUUID);
    }
}

