/*
 * Decompiled with CFR 0.152.
 */
package org.kududb.client;

import java.util.ArrayList;
import java.util.List;
import org.kududb.ColumnSchema;
import org.kududb.Common;
import org.kududb.Schema;
import org.kududb.Type;
import org.kududb.annotations.InterfaceAudience;
import org.kududb.client.Bytes;
import org.kududb.client.Partition;
import org.kududb.client.PartitionSchema;
import org.kududb.client.shaded.com.google.common.base.Charsets;
import org.kududb.client.shaded.com.google.common.collect.ImmutableList;
import org.kududb.client.shaded.com.google.common.net.HostAndPort;
import org.kududb.client.shaded.com.google.protobuf.ByteString;
import org.kududb.client.shaded.com.google.protobuf.ZeroCopyLiteralByteString;

@InterfaceAudience.Private
public class ProtobufHelper {
    public static List<Common.ColumnSchemaPB> schemaToListPb(Schema schema) {
        ArrayList<Common.ColumnSchemaPB> columns = new ArrayList<Common.ColumnSchemaPB>(schema.getColumnCount());
        Common.ColumnSchemaPB.Builder schemaBuilder = Common.ColumnSchemaPB.newBuilder();
        for (ColumnSchema col : schema.getColumns()) {
            columns.add(ProtobufHelper.columnToPb(schemaBuilder, col));
            schemaBuilder.clear();
        }
        return columns;
    }

    public static Common.SchemaPB schemaToPb(Schema schema) {
        Common.SchemaPB.Builder builder = Common.SchemaPB.newBuilder();
        builder.addAllColumns(ProtobufHelper.schemaToListPb(schema));
        return builder.build();
    }

    public static Common.ColumnSchemaPB columnToPb(ColumnSchema column) {
        return ProtobufHelper.columnToPb(Common.ColumnSchemaPB.newBuilder(), column);
    }

    public static Common.ColumnSchemaPB columnToPb(Common.ColumnSchemaPB.Builder schemaBuilder, ColumnSchema column) {
        schemaBuilder.setName(column.getName()).setType(column.getType().getDataType()).setIsKey(column.isKey()).setIsNullable(column.isNullable()).setCfileBlockSize(column.getDesiredBlockSize());
        if (column.getEncoding() != null) {
            schemaBuilder.setEncoding(column.getEncoding().getInternalPbType());
        }
        if (column.getCompressionAlgorithm() != null) {
            schemaBuilder.setCompression(column.getCompressionAlgorithm().getInternalPbType());
        }
        if (column.getDefaultValue() != null) {
            schemaBuilder.setReadDefaultValue(ZeroCopyLiteralByteString.wrap(ProtobufHelper.objectToWireFormat(column, column.getDefaultValue())));
        }
        return schemaBuilder.build();
    }

    public static Schema pbToSchema(Common.SchemaPB schema) {
        ArrayList<ColumnSchema> columns = new ArrayList<ColumnSchema>(schema.getColumnsCount());
        ArrayList<Integer> columnIds = new ArrayList<Integer>(schema.getColumnsCount());
        for (Common.ColumnSchemaPB columnPb : schema.getColumnsList()) {
            Type type = Type.getTypeForDataType(columnPb.getType());
            Object defaultValue = columnPb.hasReadDefaultValue() ? ProtobufHelper.byteStringToObject(type, columnPb.getReadDefaultValue()) : null;
            ColumnSchema.Encoding encoding = ColumnSchema.Encoding.valueOf(columnPb.getEncoding().name());
            ColumnSchema.CompressionAlgorithm compressionAlgorithm = ColumnSchema.CompressionAlgorithm.valueOf(columnPb.getCompression().name());
            ColumnSchema column = new ColumnSchema.ColumnSchemaBuilder(columnPb.getName(), type).key(columnPb.getIsKey()).nullable(columnPb.getIsNullable()).defaultValue(defaultValue).encoding(encoding).compressionAlgorithm(compressionAlgorithm).build();
            columns.add(column);
            int id = columnPb.getId();
            if (id < 0) {
                throw new IllegalArgumentException("Illegal column ID: " + id);
            }
            columnIds.add(id);
        }
        return new Schema(columns, columnIds);
    }

    static PartitionSchema pbToPartitionSchema(Common.PartitionSchemaPB pb, Schema schema) {
        List<Integer> rangeColumns = ProtobufHelper.pbToIds(pb.getRangeSchema().getColumnsList());
        PartitionSchema.RangeSchema rangeSchema = new PartitionSchema.RangeSchema(rangeColumns);
        ImmutableList.Builder hashSchemas = ImmutableList.builder();
        for (Common.PartitionSchemaPB.HashBucketSchemaPB hashBucketSchemaPB : pb.getHashBucketSchemasList()) {
            List<Integer> hashColumnIds = ProtobufHelper.pbToIds(hashBucketSchemaPB.getColumnsList());
            PartitionSchema.HashBucketSchema hashSchema = new PartitionSchema.HashBucketSchema(hashColumnIds, hashBucketSchemaPB.getNumBuckets(), hashBucketSchemaPB.getSeed());
            hashSchemas.add(hashSchema);
        }
        return new PartitionSchema(rangeSchema, (List<PartitionSchema.HashBucketSchema>)((Object)hashSchemas.build()), schema);
    }

    static Partition pbToPartition(Common.PartitionPB pb) {
        return new Partition(pb.getPartitionKeyStart().toByteArray(), pb.getPartitionKeyEnd().toByteArray(), pb.getHashBucketsList());
    }

    private static List<Integer> pbToIds(List<Common.PartitionSchemaPB.ColumnIdentifierPB> columnIdentifiers) {
        ImmutableList.Builder columnIds = ImmutableList.builder();
        for (Common.PartitionSchemaPB.ColumnIdentifierPB column : columnIdentifiers) {
            switch (column.getIdentifierCase()) {
                case ID: {
                    columnIds.add((Object)column.getId());
                    break;
                }
                case NAME: {
                    throw new IllegalArgumentException(String.format("Expected column ID from master: %s", column));
                }
                case IDENTIFIER_NOT_SET: {
                    throw new IllegalArgumentException("Unknown column: " + column);
                }
            }
        }
        return columnIds.build();
    }

    private static byte[] objectToWireFormat(ColumnSchema col, Object value) {
        switch (col.getType()) {
            case BOOL: {
                return Bytes.fromBoolean((Boolean)value);
            }
            case INT8: {
                return new byte[]{(Byte)value};
            }
            case INT16: {
                return Bytes.fromShort((Short)value);
            }
            case INT32: {
                return Bytes.fromInt((Integer)value);
            }
            case INT64: 
            case TIMESTAMP: {
                return Bytes.fromLong((Long)value);
            }
            case STRING: {
                return ((String)value).getBytes(Charsets.UTF_8);
            }
            case BINARY: {
                return (byte[])value;
            }
            case FLOAT: {
                return Bytes.fromFloat(((Float)value).floatValue());
            }
            case DOUBLE: {
                return Bytes.fromDouble((Double)value);
            }
        }
        throw new IllegalArgumentException("The column " + col.getName() + " is of type " + (Object)((Object)col.getType()) + " which is unknown");
    }

    private static Object byteStringToObject(Type type, ByteString value) {
        byte[] buf = ZeroCopyLiteralByteString.zeroCopyGetBytes(value);
        switch (type) {
            case BOOL: {
                return Bytes.getBoolean(buf);
            }
            case INT8: {
                return Bytes.getByte(buf);
            }
            case INT16: {
                return Bytes.getShort(buf);
            }
            case INT32: {
                return Bytes.getInt(buf);
            }
            case INT64: 
            case TIMESTAMP: {
                return Bytes.getLong(buf);
            }
            case FLOAT: {
                return Float.valueOf(Bytes.getFloat(buf));
            }
            case DOUBLE: {
                return Bytes.getDouble(buf);
            }
            case STRING: {
                return new String(buf, Charsets.UTF_8);
            }
            case BINARY: {
                return buf;
            }
        }
        throw new IllegalArgumentException("This type is unknown: " + (Object)((Object)type));
    }

    public static Common.HostPortPB hostAndPortToPB(HostAndPort hostAndPort) {
        return Common.HostPortPB.newBuilder().setHost(hostAndPort.getHostText()).setPort(hostAndPort.getPort()).build();
    }

    public static HostAndPort hostAndPortFromPB(Common.HostPortPB hostPortPB) {
        return HostAndPort.fromParts(hostPortPB.getHost(), hostPortPB.getPort());
    }
}

