/*
 * Decompiled with CFR 0.152.
 */
package org.kududb.client;

import java.util.Arrays;
import java.util.List;
import org.kududb.annotations.InterfaceAudience;
import org.kududb.annotations.InterfaceStability;
import org.kududb.client.AsyncKuduClient;
import org.kududb.client.Bytes;
import org.kududb.client.shaded.com.google.common.base.Objects;

@InterfaceAudience.LimitedPrivate(value={"Impala"})
@InterfaceStability.Unstable
public class Partition
implements Comparable<Partition> {
    final byte[] partitionKeyStart;
    final byte[] partitionKeyEnd;
    final byte[] rangeKeyStart;
    final byte[] rangeKeyEnd;
    final List<Integer> hashBuckets;
    private static final int ENCODED_BUCKET_SIZE = 4;

    Partition(byte[] partitionKeyStart, byte[] partitionKeyEnd, List<Integer> hashBuckets) {
        this.partitionKeyStart = partitionKeyStart;
        this.partitionKeyEnd = partitionKeyEnd;
        this.hashBuckets = hashBuckets;
        this.rangeKeyStart = Partition.rangeKey(partitionKeyStart, hashBuckets.size());
        this.rangeKeyEnd = Partition.rangeKey(partitionKeyEnd, hashBuckets.size());
    }

    public byte[] getPartitionKeyStart() {
        return this.partitionKeyStart;
    }

    public byte[] getPartitionKeyEnd() {
        return this.partitionKeyEnd;
    }

    public byte[] getRangeKeyStart() {
        return this.rangeKeyStart;
    }

    public byte[] getRangeKeyEnd() {
        return this.rangeKeyEnd;
    }

    public List<Integer> getHashBuckets() {
        return this.hashBuckets;
    }

    public boolean isEndPartition() {
        return this.partitionKeyEnd.length == 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Partition partition = (Partition)o;
        return Arrays.equals(this.partitionKeyStart, partition.partitionKeyStart) && Arrays.equals(this.partitionKeyEnd, partition.partitionKeyEnd);
    }

    public int hashCode() {
        return Objects.hashCode(Arrays.hashCode(this.partitionKeyStart), Arrays.hashCode(this.partitionKeyEnd));
    }

    @Override
    public int compareTo(Partition other) {
        return Bytes.memcmp(this.partitionKeyStart, other.partitionKeyStart);
    }

    private static byte[] rangeKey(byte[] partitionKey, int numHashBuckets) {
        int bucketsLen = numHashBuckets * 4;
        if (partitionKey.length > bucketsLen) {
            return Arrays.copyOfRange(partitionKey, bucketsLen, partitionKey.length);
        }
        return AsyncKuduClient.EMPTY_ARRAY;
    }

    public String toString() {
        return String.format("[%s, %s)", Bytes.pretty(this.partitionKeyStart), Bytes.pretty(this.partitionKeyEnd));
    }
}

