/*
 * Decompiled with CFR 0.152.
 */
package org.kududb.client;

import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import org.kududb.ColumnSchema;
import org.kududb.Schema;
import org.kududb.Type;
import org.kududb.annotations.InterfaceAudience;
import org.kududb.annotations.InterfaceStability;
import org.kududb.client.Bytes;
import org.kududb.client.KeyEncoder;
import org.kududb.client.shaded.com.google.common.collect.Lists;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class PartialRow {
    private final Schema schema;
    private final List<byte[]> varLengthData;
    private final byte[] rowAlloc;
    private final BitSet columnsBitSet;
    private final BitSet nullsBitSet;
    private boolean frozen = false;

    public PartialRow(Schema schema) {
        this.schema = schema;
        this.columnsBitSet = new BitSet(this.schema.getColumnCount());
        this.nullsBitSet = schema.hasNullableColumns() ? new BitSet(this.schema.getColumnCount()) : null;
        this.rowAlloc = new byte[schema.getRowSize()];
        this.varLengthData = Arrays.asList(new byte[this.schema.getColumnCount()][]);
    }

    PartialRow(PartialRow row) {
        this.schema = row.schema;
        this.varLengthData = Lists.newArrayListWithCapacity(row.varLengthData.size());
        for (byte[] data : row.varLengthData) {
            this.varLengthData.add(data == null ? null : (byte[])data.clone());
        }
        this.rowAlloc = (byte[])row.rowAlloc.clone();
        this.columnsBitSet = (BitSet)row.columnsBitSet.clone();
        this.nullsBitSet = row.nullsBitSet == null ? null : (BitSet)row.nullsBitSet.clone();
    }

    public void addBoolean(int columnIndex, boolean val) {
        this.checkColumn(this.schema.getColumnByIndex(columnIndex), Type.BOOL);
        this.rowAlloc[this.getPositionInRowAllocAndSetBitSet((int)columnIndex)] = (byte)(val ? 1 : 0);
    }

    public void addBoolean(String columnName, boolean val) {
        this.addBoolean(this.schema.getColumnIndex(columnName), val);
    }

    public void addByte(int columnIndex, byte val) {
        this.checkColumn(this.schema.getColumnByIndex(columnIndex), Type.INT8);
        this.rowAlloc[this.getPositionInRowAllocAndSetBitSet((int)columnIndex)] = val;
    }

    public void addByte(String columnName, byte val) {
        this.addByte(this.schema.getColumnIndex(columnName), val);
    }

    public void addShort(int columnIndex, short val) {
        this.checkColumn(this.schema.getColumnByIndex(columnIndex), Type.INT16);
        Bytes.setShort(this.rowAlloc, val, this.getPositionInRowAllocAndSetBitSet(columnIndex));
    }

    public void addShort(String columnName, short val) {
        this.addShort(this.schema.getColumnIndex(columnName), val);
    }

    public void addInt(int columnIndex, int val) {
        this.checkColumn(this.schema.getColumnByIndex(columnIndex), Type.INT32);
        Bytes.setInt(this.rowAlloc, val, this.getPositionInRowAllocAndSetBitSet(columnIndex));
    }

    public void addInt(String columnName, int val) {
        this.addInt(this.schema.getColumnIndex(columnName), val);
    }

    public void addLong(int columnIndex, long val) {
        this.checkColumn(this.schema.getColumnByIndex(columnIndex), Type.INT64, Type.TIMESTAMP);
        Bytes.setLong(this.rowAlloc, val, this.getPositionInRowAllocAndSetBitSet(columnIndex));
    }

    public void addLong(String columnName, long val) {
        this.addLong(this.schema.getColumnIndex(columnName), val);
    }

    public void addFloat(int columnIndex, float val) {
        this.checkColumn(this.schema.getColumnByIndex(columnIndex), Type.FLOAT);
        Bytes.setFloat(this.rowAlloc, val, this.getPositionInRowAllocAndSetBitSet(columnIndex));
    }

    public void addFloat(String columnName, float val) {
        this.addFloat(this.schema.getColumnIndex(columnName), val);
    }

    public void addDouble(int columnIndex, double val) {
        this.checkColumn(this.schema.getColumnByIndex(columnIndex), Type.DOUBLE);
        Bytes.setDouble(this.rowAlloc, val, this.getPositionInRowAllocAndSetBitSet(columnIndex));
    }

    public void addDouble(String columnName, double val) {
        this.addDouble(this.schema.getColumnIndex(columnName), val);
    }

    public void addString(int columnIndex, String val) {
        this.addStringUtf8(columnIndex, Bytes.fromString(val));
    }

    public void addString(String columnName, String val) {
        this.addStringUtf8(columnName, Bytes.fromString(val));
    }

    public void addStringUtf8(int columnIndex, byte[] val) {
        this.checkColumn(this.schema.getColumnByIndex(columnIndex), Type.STRING);
        this.addVarLengthData(columnIndex, val);
    }

    public void addStringUtf8(String columnName, byte[] val) {
        this.addStringUtf8(this.schema.getColumnIndex(columnName), val);
    }

    public void addBinary(int columnIndex, byte[] val) {
        this.checkColumn(this.schema.getColumnByIndex(columnIndex), Type.BINARY);
        this.addVarLengthData(columnIndex, val);
    }

    public void addBinary(String columnName, byte[] val) {
        this.addBinary(this.schema.getColumnIndex(columnName), val);
    }

    private void addVarLengthData(int columnIndex, byte[] val) {
        this.varLengthData.set(columnIndex, val);
        this.getPositionInRowAllocAndSetBitSet(columnIndex);
    }

    public void setNull(int columnIndex) {
        this.setNull(this.schema.getColumnByIndex(columnIndex));
    }

    public void setNull(String columnName) {
        this.setNull(this.schema.getColumn(columnName));
    }

    private void setNull(ColumnSchema column) {
        assert (this.nullsBitSet != null);
        this.checkNotFrozen();
        this.checkColumnExists(column);
        if (!column.isNullable()) {
            throw new IllegalArgumentException(column.getName() + " cannot be set to null");
        }
        int idx = this.schema.getColumns().indexOf(column);
        this.columnsBitSet.set(idx);
        this.nullsBitSet.set(idx);
    }

    private void checkColumn(ColumnSchema column, Type ... types) {
        this.checkNotFrozen();
        this.checkColumnExists(column);
        for (Type type : types) {
            if (!column.getType().equals((Object)type)) continue;
            return;
        }
        throw new IllegalArgumentException(String.format("%s isn't %s, it's %s", column.getName(), Arrays.toString((Object[])types), column.getType().getName()));
    }

    private void checkColumnExists(ColumnSchema column) {
        if (column == null) {
            throw new IllegalArgumentException("Column name isn't present in the table's schema");
        }
    }

    private void checkNotFrozen() {
        if (this.frozen) {
            throw new IllegalStateException("This row was already applied and cannot be modified.");
        }
    }

    private int getPositionInRowAllocAndSetBitSet(int columnIndex) {
        this.columnsBitSet.set(columnIndex);
        return this.schema.getColumnOffset(columnIndex);
    }

    boolean isSet(int column) {
        return this.columnsBitSet.get(column);
    }

    boolean isSetToNull(int column) {
        if (this.nullsBitSet == null) {
            return false;
        }
        return this.nullsBitSet.get(column);
    }

    public byte[] encodePrimaryKey() {
        return new KeyEncoder().encodePrimaryKey(this);
    }

    Schema getSchema() {
        return this.schema;
    }

    List<byte[]> getVarLengthData() {
        return this.varLengthData;
    }

    byte[] getRowAlloc() {
        return this.rowAlloc;
    }

    BitSet getColumnsBitSet() {
        return this.columnsBitSet;
    }

    BitSet getNullsBitSet() {
        return this.nullsBitSet;
    }

    void freeze() {
        this.frozen = true;
    }
}

