/*
 * Decompiled with CFR 0.152.
 */
package org.kududb.client;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.List;
import org.kududb.ColumnSchema;
import org.kududb.Schema;
import org.kududb.Type;
import org.kududb.WireProtocol;
import org.kududb.annotations.InterfaceAudience;
import org.kududb.annotations.InterfaceStability;
import org.kududb.client.Bytes;
import org.kududb.client.CallResponse;
import org.kududb.client.KuduRpc;
import org.kududb.client.KuduTable;
import org.kududb.client.OperationResponse;
import org.kududb.client.PartialRow;
import org.kududb.client.ProtobufHelper;
import org.kududb.client.shaded.com.google.protobuf.ByteString;
import org.kududb.client.shaded.com.google.protobuf.Message;
import org.kududb.client.shaded.com.google.protobuf.ZeroCopyLiteralByteString;
import org.kududb.client.shaded.org.jboss.netty.buffer.ChannelBuffer;
import org.kududb.tserver.Tserver;
import org.kududb.util.Pair;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public abstract class Operation
extends KuduRpc<OperationResponse>
implements KuduRpc.HasKey {
    private long sequenceNumber = -1L;
    static final String METHOD = "Write";
    private final PartialRow row;

    Operation(KuduTable table) {
        super(table);
        this.row = table.getSchema().newPartialRow();
    }

    abstract ChangeType getChangeType();

    void setSequenceNumber(long sequenceNumber) {
        assert (this.sequenceNumber == -1L);
        this.sequenceNumber = sequenceNumber;
    }

    long getSequenceNumber() {
        return this.sequenceNumber;
    }

    @Override
    String serviceName() {
        return "kudu.tserver.TabletServerService";
    }

    @Override
    String method() {
        return METHOD;
    }

    @Override
    ChannelBuffer serialize(Message header) {
        Tserver.WriteRequestPB.Builder builder = Operation.createAndFillWriteRequestPB(this);
        builder.setTabletId(ZeroCopyLiteralByteString.wrap(this.getTablet().getTabletIdAsBytes()));
        builder.setExternalConsistencyMode(this.externalConsistencyMode.pbVersion());
        if (this.propagatedTimestamp != -1L) {
            builder.setPropagatedTimestamp(this.propagatedTimestamp);
        }
        return Operation.toChannelBuffer(header, builder.build());
    }

    @Override
    Pair<OperationResponse, Object> deserialize(CallResponse callResponse, String tsUUID) throws Exception {
        Tserver.WriteResponsePB.Builder builder = Tserver.WriteResponsePB.newBuilder();
        Operation.readProtobuf(callResponse.getPBMessage(), builder);
        Tserver.WriteResponsePB.PerRowErrorPB error = null;
        if (builder.getPerRowErrorsCount() != 0) {
            error = builder.getPerRowErrors(0);
        }
        OperationResponse response = new OperationResponse(this.deadlineTracker.getElapsedMillis(), tsUUID, builder.getTimestamp(), this, error);
        return new Pair<OperationResponse, Object>(response, builder.hasError() ? builder.getError() : null);
    }

    @Override
    public byte[] partitionKey() {
        return this.getTable().getPartitionSchema().encodePartitionKey(this.row);
    }

    public PartialRow getRow() {
        return this.row;
    }

    static Tserver.WriteRequestPB.Builder createAndFillWriteRequestPB(Operation ... operations) {
        if (operations == null || operations.length == 0) {
            return null;
        }
        Schema schema = operations[0].table.getSchema();
        WireProtocol.RowOperationsPB rowOps = new OperationsEncoder().encodeOperations(operations);
        if (rowOps == null) {
            return null;
        }
        Tserver.WriteRequestPB.Builder requestBuilder = Tserver.WriteRequestPB.newBuilder();
        requestBuilder.setSchema(ProtobufHelper.schemaToPb(schema));
        requestBuilder.setRowOperations(rowOps);
        return requestBuilder;
    }

    static class OperationsEncoder {
        private Schema schema;
        private ByteBuffer rows;
        private ByteArrayOutputStream indirect;

        OperationsEncoder() {
        }

        private void init(Schema schema, int numOperations) {
            this.schema = schema;
            int columnBitSetSize = Bytes.getBitSetSize(schema.getColumnCount());
            int sizePerRow = 1 + schema.getRowSize() + columnBitSetSize;
            if (schema.hasNullableColumns()) {
                sizePerRow += columnBitSetSize;
            }
            this.rows = ByteBuffer.allocate(sizePerRow * numOperations).order(ByteOrder.LITTLE_ENDIAN);
            this.indirect = new ByteArrayOutputStream();
        }

        private WireProtocol.RowOperationsPB toPB() {
            WireProtocol.RowOperationsPB.Builder rowOpsBuilder = WireProtocol.RowOperationsPB.newBuilder();
            this.rows.limit(this.rows.position());
            this.rows.flip();
            rowOpsBuilder.setRows(ByteString.copyFrom(this.rows));
            if (this.indirect.size() > 0) {
                rowOpsBuilder.setIndirectData(ZeroCopyLiteralByteString.wrap(this.indirect.toByteArray()));
            }
            return rowOpsBuilder.build();
        }

        private void encodeRow(PartialRow row, ChangeType type) {
            this.rows.put(type.toEncodedByte());
            this.rows.put(Bytes.fromBitSet(row.getColumnsBitSet(), this.schema.getColumnCount()));
            if (this.schema.hasNullableColumns()) {
                this.rows.put(Bytes.fromBitSet(row.getNullsBitSet(), this.schema.getColumnCount()));
            }
            int colIdx = 0;
            byte[] rowData = row.getRowAlloc();
            int currentRowOffset = 0;
            for (ColumnSchema col : row.getSchema().getColumns()) {
                if (row.isSet(colIdx) && !row.isSetToNull(colIdx)) {
                    if (col.getType() == Type.STRING || col.getType() == Type.BINARY) {
                        byte[] varLengthData = row.getVarLengthData().get(colIdx);
                        this.rows.putLong(this.indirect.size());
                        this.rows.putLong(varLengthData.length);
                        try {
                            this.indirect.write(varLengthData);
                        }
                        catch (IOException e) {
                            throw new AssertionError((Object)e);
                        }
                    } else {
                        this.rows.put(rowData, currentRowOffset, col.getType().getSize());
                    }
                }
                currentRowOffset += col.getType().getSize();
                ++colIdx;
            }
        }

        public WireProtocol.RowOperationsPB encodeOperations(Operation ... operations) {
            if (operations == null || operations.length == 0) {
                return null;
            }
            this.init(operations[0].table.getSchema(), operations.length);
            for (Operation operation : operations) {
                this.encodeRow(operation.row, operation.getChangeType());
            }
            return this.toPB();
        }

        public WireProtocol.RowOperationsPB encodeSplitRows(List<PartialRow> rows) {
            if (rows == null || rows.isEmpty()) {
                return null;
            }
            this.init(rows.get(0).getSchema(), rows.size());
            for (PartialRow row : rows) {
                this.encodeRow(row, ChangeType.SPLIT_ROWS);
            }
            return this.toPB();
        }
    }

    static enum ChangeType {
        INSERT((byte)WireProtocol.RowOperationsPB.Type.INSERT.getNumber()),
        UPDATE((byte)WireProtocol.RowOperationsPB.Type.UPDATE.getNumber()),
        DELETE((byte)WireProtocol.RowOperationsPB.Type.DELETE.getNumber()),
        SPLIT_ROWS((byte)WireProtocol.RowOperationsPB.Type.SPLIT_ROW.getNumber());

        private byte encodedByte;

        private ChangeType(byte encodedByte) {
            this.encodedByte = encodedByte;
        }

        byte toEncodedByte() {
            return this.encodedByte;
        }
    }
}

