/*
 * Decompiled with CFR 0.152.
 */
package org.kududb.client;

import java.util.ArrayList;
import java.util.List;
import org.kududb.annotations.InterfaceAudience;
import org.kududb.annotations.InterfaceStability;
import org.kududb.client.Bytes;
import org.kududb.client.Partition;
import org.kududb.client.ProtobufHelper;
import org.kududb.client.shaded.com.google.common.collect.ImmutableList;
import org.kududb.client.shaded.com.google.common.collect.Lists;
import org.kududb.consensus.Metadata;
import org.kududb.master.Master;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class LocatedTablet {
    private final Partition partition;
    private final byte[] tabletId;
    private final List<Replica> replicas;

    LocatedTablet(Master.TabletLocationsPB pb) {
        this.partition = ProtobufHelper.pbToPartition(pb.getPartition());
        this.tabletId = pb.getTabletId().toByteArray();
        ArrayList<Replica> reps = Lists.newArrayList();
        for (Master.TabletLocationsPB.ReplicaPB repPb : pb.getReplicasList()) {
            reps.add(new Replica(repPb));
        }
        this.replicas = ImmutableList.copyOf(reps);
    }

    public List<Replica> getReplicas() {
        return this.replicas;
    }

    public Partition getPartition() {
        return this.partition;
    }

    @Deprecated
    public byte[] getStartKey() {
        return this.getPartition().getPartitionKeyStart();
    }

    @Deprecated
    public byte[] getEndKey() {
        return this.getPartition().getPartitionKeyEnd();
    }

    public byte[] getTabletId() {
        return this.tabletId;
    }

    public Replica getLeaderReplica() {
        return this.getOneOfRoleOrNull(Metadata.RaftPeerPB.Role.LEADER);
    }

    private Replica getOneOfRoleOrNull(Metadata.RaftPeerPB.Role role) {
        for (Replica r : this.replicas) {
            if (r.getRole() != role.toString()) continue;
            return r;
        }
        return null;
    }

    public String toString() {
        return Bytes.pretty(this.tabletId) + " " + this.partition.toString();
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public static class Replica {
        private final Master.TabletLocationsPB.ReplicaPB pb;

        private Replica(Master.TabletLocationsPB.ReplicaPB pb) {
            this.pb = pb;
        }

        public String getRpcHost() {
            if (this.pb.getTsInfo().getRpcAddressesList().isEmpty()) {
                return null;
            }
            return this.pb.getTsInfo().getRpcAddressesList().get(0).getHost();
        }

        public Integer getRpcPort() {
            if (this.pb.getTsInfo().getRpcAddressesList().isEmpty()) {
                return null;
            }
            return this.pb.getTsInfo().getRpcAddressesList().get(0).getPort();
        }

        public String getRole() {
            return this.pb.getRole().toString();
        }

        public String toString() {
            return this.pb.toString();
        }
    }
}

