/*
 * Decompiled with CFR 0.152.
 */
package org.kududb.client;

import java.util.ArrayList;
import org.kududb.annotations.InterfaceAudience;
import org.kududb.client.CallResponse;
import org.kududb.client.KuduRpc;
import org.kududb.client.KuduTable;
import org.kududb.client.ListTabletServersResponse;
import org.kududb.client.shaded.com.google.protobuf.Message;
import org.kududb.client.shaded.org.jboss.netty.buffer.ChannelBuffer;
import org.kududb.master.Master;
import org.kududb.util.Pair;

@InterfaceAudience.Private
public class ListTabletServersRequest
extends KuduRpc<ListTabletServersResponse> {
    public ListTabletServersRequest(KuduTable masterTable) {
        super(masterTable);
    }

    @Override
    ChannelBuffer serialize(Message header) {
        assert (header.isInitialized());
        Master.ListTabletServersRequestPB.Builder builder = Master.ListTabletServersRequestPB.newBuilder();
        return ListTabletServersRequest.toChannelBuffer(header, builder.build());
    }

    @Override
    String serviceName() {
        return "kudu.master.MasterService";
    }

    @Override
    String method() {
        return "ListTabletServers";
    }

    @Override
    Pair<ListTabletServersResponse, Object> deserialize(CallResponse callResponse, String tsUUID) throws Exception {
        Master.ListTabletServersResponsePB.Builder respBuilder = Master.ListTabletServersResponsePB.newBuilder();
        ListTabletServersRequest.readProtobuf(callResponse.getPBMessage(), respBuilder);
        int serversCount = respBuilder.getServersCount();
        ArrayList<String> servers = new ArrayList<String>(serversCount);
        for (Master.ListTabletServersResponsePB.Entry entry : respBuilder.getServersList()) {
            servers.add(entry.getRegistration().getRpcAddresses(0).getHost());
        }
        ListTabletServersResponse response = new ListTabletServersResponse(this.deadlineTracker.getElapsedMillis(), tsUUID, serversCount, servers);
        return new Pair<ListTabletServersResponse, Object>(response, respBuilder.hasError() ? respBuilder.getError() : null);
    }
}

