/*
 * Decompiled with CFR 0.152.
 */
package org.kududb.client;

import java.util.List;
import org.kududb.Schema;
import org.kududb.annotations.InterfaceAudience;
import org.kududb.annotations.InterfaceStability;
import org.kududb.client.AsyncKuduClient;
import org.kududb.client.Delete;
import org.kududb.client.Insert;
import org.kududb.client.LocatedTablet;
import org.kududb.client.PartitionSchema;
import org.kududb.client.Update;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class KuduTable {
    private final Schema schema;
    private final PartitionSchema partitionSchema;
    private final AsyncKuduClient client;
    private final String name;
    private final String tableId;

    KuduTable(AsyncKuduClient client, String name, String tableId, Schema schema, PartitionSchema partitionSchema) {
        this.schema = schema;
        this.partitionSchema = partitionSchema;
        this.client = client;
        this.name = name;
        this.tableId = tableId;
    }

    public Schema getSchema() {
        return this.schema;
    }

    @InterfaceAudience.LimitedPrivate(value={"Impala"})
    @InterfaceStability.Unstable
    public PartitionSchema getPartitionSchema() {
        return this.partitionSchema;
    }

    public String getName() {
        return this.name;
    }

    public String getTableId() {
        return this.tableId;
    }

    public AsyncKuduClient getAsyncClient() {
        return this.client;
    }

    public Insert newInsert() {
        return new Insert(this);
    }

    public Update newUpdate() {
        return new Update(this);
    }

    public Delete newDelete() {
        return new Delete(this);
    }

    public List<LocatedTablet> getTabletsLocations(long deadline) throws Exception {
        return this.getTabletsLocations(null, null, deadline);
    }

    public List<LocatedTablet> getTabletsLocations(byte[] startKey, byte[] endKey, long deadline) throws Exception {
        return this.client.syncLocateTable(this.tableId, startKey, endKey, deadline);
    }
}

