/*
 * Decompiled with CFR 0.152.
 */
package org.kududb.client;

import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.List;
import org.kududb.ColumnSchema;
import org.kududb.Schema;
import org.kududb.Type;
import org.kududb.annotations.InterfaceAudience;
import org.kududb.client.Bytes;
import org.kududb.client.PartialRow;
import org.kududb.client.PartitionSchema;
import org.kududb.client.shaded.com.google.common.primitives.UnsignedLongs;
import org.kududb.client.shaded.com.sangupta.murmur.Murmur2;

@InterfaceAudience.Private
class KeyEncoder {
    private final ByteArrayOutputStream buf = new ByteArrayOutputStream();

    KeyEncoder() {
    }

    public byte[] encodePrimaryKey(PartialRow row) {
        this.buf.reset();
        Schema schema = row.getSchema();
        for (int columnIdx = 0; columnIdx < schema.getPrimaryKeyColumnCount(); ++columnIdx) {
            boolean isLast = columnIdx + 1 == schema.getPrimaryKeyColumnCount();
            this.encodeColumn(row, columnIdx, isLast);
        }
        return this.extractByteArray();
    }

    public byte[] encodePartitionKey(PartialRow row, PartitionSchema partitionSchema) {
        this.buf.reset();
        if (!partitionSchema.getHashBucketSchemas().isEmpty()) {
            ByteBuffer bucketBuf = ByteBuffer.allocate(4 * partitionSchema.getHashBucketSchemas().size());
            bucketBuf.order(ByteOrder.BIG_ENDIAN);
            for (PartitionSchema.HashBucketSchema hashBucketSchema : partitionSchema.getHashBucketSchemas()) {
                this.encodeColumns(row, hashBucketSchema.getColumnIds());
                byte[] encodedColumns = this.extractByteArray();
                long hash = Murmur2.hash64(encodedColumns, encodedColumns.length, hashBucketSchema.getSeed());
                int bucket = (int)UnsignedLongs.remainder(hash, hashBucketSchema.getNumBuckets());
                bucketBuf.putInt(bucket);
            }
            assert (bucketBuf.arrayOffset() == 0);
            this.buf.write(bucketBuf.array(), 0, bucketBuf.position());
        }
        this.encodeColumns(row, partitionSchema.getRangeSchema().getColumns());
        return this.extractByteArray();
    }

    private void encodeColumns(PartialRow row, List<Integer> columnIds) {
        for (int i = 0; i < columnIds.size(); ++i) {
            boolean isLast = i + 1 == columnIds.size();
            this.encodeColumn(row, row.getSchema().getColumnIndex(columnIds.get(i)), isLast);
        }
    }

    private void encodeColumn(PartialRow row, int columnIdx, boolean isLast) {
        Schema schema = row.getSchema();
        ColumnSchema column = schema.getColumnByIndex(columnIdx);
        if (!row.isSet(columnIdx)) {
            throw new IllegalStateException(String.format("Primary key column %s is not set", column.getName()));
        }
        Type type = column.getType();
        if (type == Type.STRING || type == Type.BINARY) {
            this.addComponent(row.getVarLengthData().get(columnIdx), type, isLast);
        } else {
            this.addComponent(row.getRowAlloc(), schema.getColumnOffset(columnIdx), type.getSize(), type, isLast);
        }
    }

    private void addComponent(byte[] value, Type type, boolean isLast) {
        this.addComponent(value, 0, value.length, type, isLast);
    }

    private void addComponent(byte[] value, int offset, int len, Type type, boolean isLast) {
        switch (type) {
            case BOOL: {
                assert (len == 1);
                this.buf.write(value[0]);
                break;
            }
            case INT8: 
            case INT16: 
            case INT32: 
            case INT64: 
            case TIMESTAMP: {
                byte lastByte = value[offset + (len - 1)];
                lastByte = Bytes.xorLeftMostBit(lastByte);
                this.buf.write(lastByte);
                if (len <= 1) break;
                for (int i = len - 2; i >= 0; --i) {
                    this.buf.write(value[offset + i]);
                }
                break;
            }
            case BINARY: 
            case STRING: {
                if (isLast) {
                    this.buf.write(value, offset, len);
                    break;
                }
                for (int b = offset; b < offset + len; ++b) {
                    this.buf.write(value[b]);
                    if (value[b] != 0) continue;
                    this.buf.write(1);
                }
                this.buf.write(0);
                this.buf.write(0);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("The column type %s is not a valid key component type", new Object[]{type}));
            }
        }
    }

    private byte[] extractByteArray() {
        byte[] bytes = this.buf.toByteArray();
        this.buf.reset();
        return bytes;
    }
}

