/*
 * Decompiled with CFR 0.152.
 */
package org.kududb.client;

import org.kududb.annotations.InterfaceAudience;
import org.kududb.client.CallResponse;
import org.kududb.client.IsAlterTableDoneResponse;
import org.kududb.client.KuduRpc;
import org.kududb.client.KuduTable;
import org.kududb.client.shaded.com.google.protobuf.Message;
import org.kududb.client.shaded.org.jboss.netty.buffer.ChannelBuffer;
import org.kududb.master.Master;
import org.kududb.util.Pair;

@InterfaceAudience.Private
class IsAlterTableDoneRequest
extends KuduRpc<IsAlterTableDoneResponse> {
    static final String IS_ALTER_TABLE_DONE = "IsAlterTableDone";
    private final String name;

    IsAlterTableDoneRequest(KuduTable masterTable, String name) {
        super(masterTable);
        this.name = name;
    }

    @Override
    ChannelBuffer serialize(Message header) {
        assert (header.isInitialized());
        Master.IsAlterTableDoneRequestPB.Builder builder = Master.IsAlterTableDoneRequestPB.newBuilder();
        Master.TableIdentifierPB tableID = Master.TableIdentifierPB.newBuilder().setTableName(this.name).build();
        builder.setTable(tableID);
        return IsAlterTableDoneRequest.toChannelBuffer(header, builder.build());
    }

    @Override
    String serviceName() {
        return "kudu.master.MasterService";
    }

    @Override
    String method() {
        return IS_ALTER_TABLE_DONE;
    }

    @Override
    Pair<IsAlterTableDoneResponse, Object> deserialize(CallResponse callResponse, String tsUUID) throws Exception {
        Master.IsAlterTableDoneResponsePB.Builder respBuilder = Master.IsAlterTableDoneResponsePB.newBuilder();
        IsAlterTableDoneRequest.readProtobuf(callResponse.getPBMessage(), respBuilder);
        IsAlterTableDoneResponse resp = new IsAlterTableDoneResponse(this.deadlineTracker.getElapsedMillis(), tsUUID, respBuilder.getDone());
        return new Pair<IsAlterTableDoneResponse, Object>(resp, respBuilder.hasError() ? respBuilder.getError() : null);
    }
}

