/*
 * Decompiled with CFR 0.152.
 */
package org.kududb.client;

import org.kududb.Schema;
import org.kududb.annotations.InterfaceAudience;
import org.kududb.client.CallResponse;
import org.kududb.client.GetTableSchemaResponse;
import org.kududb.client.KuduRpc;
import org.kududb.client.KuduTable;
import org.kududb.client.ProtobufHelper;
import org.kududb.client.shaded.com.google.protobuf.Message;
import org.kududb.client.shaded.org.jboss.netty.buffer.ChannelBuffer;
import org.kududb.master.Master;
import org.kududb.util.Pair;

@InterfaceAudience.Private
public class GetTableSchemaRequest
extends KuduRpc<GetTableSchemaResponse> {
    static final String GET_TABLE_SCHEMA = "GetTableSchema";
    private final String name;

    GetTableSchemaRequest(KuduTable masterTable, String name) {
        super(masterTable);
        this.name = name;
    }

    @Override
    ChannelBuffer serialize(Message header) {
        assert (header.isInitialized());
        Master.GetTableSchemaRequestPB.Builder builder = Master.GetTableSchemaRequestPB.newBuilder();
        Master.TableIdentifierPB tableID = Master.TableIdentifierPB.newBuilder().setTableName(this.name).build();
        builder.setTable(tableID);
        return GetTableSchemaRequest.toChannelBuffer(header, builder.build());
    }

    @Override
    String serviceName() {
        return "kudu.master.MasterService";
    }

    @Override
    String method() {
        return GET_TABLE_SCHEMA;
    }

    @Override
    Pair<GetTableSchemaResponse, Object> deserialize(CallResponse callResponse, String tsUUID) throws Exception {
        Master.GetTableSchemaResponsePB.Builder respBuilder = Master.GetTableSchemaResponsePB.newBuilder();
        GetTableSchemaRequest.readProtobuf(callResponse.getPBMessage(), respBuilder);
        Schema schema = ProtobufHelper.pbToSchema(respBuilder.getSchema());
        GetTableSchemaResponse response = new GetTableSchemaResponse(this.deadlineTracker.getElapsedMillis(), tsUUID, schema, respBuilder.getTableId().toStringUtf8(), ProtobufHelper.pbToPartitionSchema(respBuilder.getPartitionSchema(), schema), respBuilder.getCreateTableDone());
        return new Pair<GetTableSchemaResponse, Object>(response, respBuilder.hasError() ? respBuilder.getError() : null);
    }
}

