/*
 * Decompiled with CFR 0.152.
 */
package org.kududb.client;

import org.kududb.annotations.InterfaceAudience;
import org.kududb.client.CallResponse;
import org.kududb.client.DeleteTableResponse;
import org.kududb.client.KuduRpc;
import org.kududb.client.KuduTable;
import org.kududb.client.shaded.com.google.protobuf.Message;
import org.kududb.client.shaded.org.jboss.netty.buffer.ChannelBuffer;
import org.kududb.master.Master;
import org.kududb.util.Pair;

@InterfaceAudience.Private
class DeleteTableRequest
extends KuduRpc<DeleteTableResponse> {
    static final String DELETE_TABLE = "DeleteTable";
    private final String name;

    DeleteTableRequest(KuduTable table, String name) {
        super(table);
        this.name = name;
    }

    @Override
    ChannelBuffer serialize(Message header) {
        assert (header.isInitialized());
        Master.DeleteTableRequestPB.Builder builder = Master.DeleteTableRequestPB.newBuilder();
        Master.TableIdentifierPB tableID = Master.TableIdentifierPB.newBuilder().setTableName(this.name).build();
        builder.setTable(tableID);
        return DeleteTableRequest.toChannelBuffer(header, builder.build());
    }

    @Override
    String serviceName() {
        return "kudu.master.MasterService";
    }

    @Override
    String method() {
        return DELETE_TABLE;
    }

    @Override
    Pair<DeleteTableResponse, Object> deserialize(CallResponse callResponse, String tsUUID) throws Exception {
        Master.DeleteTableResponsePB.Builder builder = Master.DeleteTableResponsePB.newBuilder();
        DeleteTableRequest.readProtobuf(callResponse.getPBMessage(), builder);
        DeleteTableResponse response = new DeleteTableResponse(this.deadlineTracker.getElapsedMillis(), tsUUID);
        return new Pair<DeleteTableResponse, Object>(response, builder.hasError() ? builder.getError() : null);
    }
}

