/*
 * Decompiled with CFR 0.152.
 */
package org.kududb.client;

import java.util.List;
import org.kududb.Common;
import org.kududb.annotations.InterfaceAudience;
import org.kududb.annotations.InterfaceStability;
import org.kududb.client.Operation;
import org.kududb.client.PartialRow;
import org.kududb.client.shaded.com.google.common.collect.Lists;
import org.kududb.master.Master;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class CreateTableOptions {
    private Master.CreateTableRequestPB.Builder pb = Master.CreateTableRequestPB.newBuilder();
    private final List<PartialRow> splitRows = Lists.newArrayList();

    public CreateTableOptions addSplitRow(PartialRow row) {
        this.splitRows.add(new PartialRow(row));
        return this;
    }

    public CreateTableOptions addHashPartitions(List<String> columns, int buckets) {
        this.addHashPartitions(columns, buckets, 0);
        return this;
    }

    public CreateTableOptions addHashPartitions(List<String> columns, int buckets, int seed) {
        Common.PartitionSchemaPB.HashBucketSchemaPB.Builder hashBucket = this.pb.getPartitionSchemaBuilder().addHashBucketSchemasBuilder();
        for (String column : columns) {
            hashBucket.addColumnsBuilder().setName(column);
        }
        hashBucket.setNumBuckets(buckets);
        hashBucket.setSeed(seed);
        return this;
    }

    public CreateTableOptions setRangePartitionColumns(List<String> columns) {
        Common.PartitionSchemaPB.RangeSchemaPB.Builder rangePartition = this.pb.getPartitionSchemaBuilder().getRangeSchemaBuilder();
        for (String column : columns) {
            rangePartition.addColumnsBuilder().setName(column);
        }
        return this;
    }

    public CreateTableOptions setNumReplicas(int numReplicas) {
        this.pb.setNumReplicas(numReplicas);
        return this;
    }

    Master.CreateTableRequestPB.Builder getBuilder() {
        if (!this.splitRows.isEmpty()) {
            this.pb.setSplitRows(new Operation.OperationsEncoder().encodeSplitRows(this.splitRows));
        }
        return this.pb;
    }
}

