/*
 * Decompiled with CFR 0.152.
 */
package org.kududb.client;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.kududb.annotations.InterfaceAudience;
import org.kududb.client.KuduRpcResponse;
import org.kududb.client.Operation;
import org.kududb.client.OperationResponse;
import org.kududb.client.RowError;
import org.kududb.tserver.Tserver;

@InterfaceAudience.Private
public class BatchResponse
extends KuduRpcResponse {
    private final long writeTimestamp;
    private final List<RowError> rowErrors;
    private final List<OperationResponse> individualResponses;

    BatchResponse(long elapsedMillis, String tsUUID, long writeTimestamp, List<Tserver.WriteResponsePB.PerRowErrorPB> errorsPB, List<Operation> operations) {
        super(elapsedMillis, tsUUID);
        this.writeTimestamp = writeTimestamp;
        this.individualResponses = new ArrayList<OperationResponse>(operations.size());
        this.rowErrors = errorsPB.isEmpty() ? Collections.emptyList() : new ArrayList<RowError>(errorsPB.size());
        int currentErrorIndex = 0;
        for (int i = 0; i < operations.size(); ++i) {
            RowError rowError = null;
            Operation currentOperation = operations.get(i);
            if (currentErrorIndex < errorsPB.size() && errorsPB.get(currentErrorIndex).getRowIndex() == i) {
                rowError = RowError.fromRowErrorPb(errorsPB.get(currentErrorIndex), currentOperation, tsUUID);
                this.rowErrors.add(rowError);
                ++currentErrorIndex;
            }
            this.individualResponses.add(new OperationResponse(currentOperation.deadlineTracker.getElapsedMillis(), tsUUID, writeTimestamp, currentOperation, rowError));
        }
        assert (this.rowErrors.size() == errorsPB.size());
        assert (this.individualResponses.size() == operations.size());
    }

    public long getWriteTimestamp() {
        return this.writeTimestamp;
    }

    List<OperationResponse> getIndividualResponses() {
        return this.individualResponses;
    }
}

