/*
 * Decompiled with CFR 0.152.
 */
package org.kududb.client;

import com.stumbleupon.async.Callback;
import com.stumbleupon.async.Deferred;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.kududb.ColumnSchema;
import org.kududb.Common;
import org.kududb.Schema;
import org.kududb.annotations.InterfaceAudience;
import org.kududb.annotations.InterfaceStability;
import org.kududb.client.AbstractKuduScannerBuilder;
import org.kududb.client.AsyncKuduClient;
import org.kududb.client.Bytes;
import org.kududb.client.CallResponse;
import org.kududb.client.InvalidResponseException;
import org.kududb.client.KuduRpc;
import org.kududb.client.KuduTable;
import org.kududb.client.NonRecoverableException;
import org.kududb.client.Partition;
import org.kududb.client.ProtobufHelper;
import org.kududb.client.RowResultIterator;
import org.kududb.client.shaded.com.google.common.base.Preconditions;
import org.kududb.client.shaded.com.google.protobuf.Message;
import org.kududb.client.shaded.com.google.protobuf.ZeroCopyLiteralByteString;
import org.kududb.client.shaded.org.jboss.netty.buffer.ChannelBuffer;
import org.kududb.tserver.Tserver;
import org.kududb.util.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public final class AsyncKuduScanner {
    private static final Logger LOG = LoggerFactory.getLogger(AsyncKuduScanner.class);
    private final AsyncKuduClient client;
    private final KuduTable table;
    private final Schema schema;
    private final List<Tserver.ColumnRangePredicatePB> columnRangePredicates;
    private final int batchSizeBytes;
    private final long limit;
    private byte[] nextPartitionKey;
    private final byte[] endPartitionKey;
    private final byte[] startPrimaryKey;
    private final byte[] endPrimaryKey;
    private final boolean prefetching;
    private final boolean cacheBlocks;
    private final ReadMode readMode;
    private final long htTimestamp;
    private boolean closed = false;
    private boolean hasMore = true;
    private AsyncKuduClient.RemoteTablet tablet;
    private byte[] scannerId;
    private int sequenceId;
    private Deferred<RowResultIterator> prefetcherDeferred;
    private boolean inFirstTablet = true;
    final long scanRequestTimeout;
    private static final AtomicBoolean PARTITION_PRUNE_WARN = new AtomicBoolean(true);
    private final Callback<RowResultIterator, RowResultIterator> prefetch = new Callback<RowResultIterator, RowResultIterator>(){

        public RowResultIterator call(RowResultIterator arg) throws Exception {
            if (AsyncKuduScanner.this.hasMoreRows()) {
                AsyncKuduScanner.this.prefetcherDeferred = AsyncKuduScanner.this.client.scanNextRows(AsyncKuduScanner.this).addCallbacks(AsyncKuduScanner.this.got_next_row, AsyncKuduScanner.this.nextRowErrback());
            }
            return null;
        }
    };
    private final Callback<RowResultIterator, Response> got_next_row = new Callback<RowResultIterator, Response>(){

        public RowResultIterator call(Response resp) {
            if (!resp.more) {
                AsyncKuduScanner.this.scanFinished();
                return resp.data;
            }
            AsyncKuduScanner.this.sequenceId++;
            AsyncKuduScanner.this.hasMore = resp.more;
            return resp.data;
        }

        public String toString() {
            return "get nextRows response";
        }
    };

    AsyncKuduScanner(AsyncKuduClient client, KuduTable table, List<String> projectedNames, List<Integer> projectedIndexes, ReadMode readMode, long scanRequestTimeout, List<Tserver.ColumnRangePredicatePB> columnRangePredicates, long limit, boolean cacheBlocks, boolean prefetching, byte[] startPrimaryKey, byte[] endPrimaryKey, byte[] startPartitionKey, byte[] endPartitionKey, long htTimestamp, int batchSizeBytes) {
        Preconditions.checkArgument(batchSizeBytes > 0, "Need a strictly positive number of bytes, got %s", batchSizeBytes);
        Preconditions.checkArgument(limit > 0L, "Need a strictly positive number for the limit, got %s", limit);
        if (htTimestamp != -1L) {
            Preconditions.checkArgument(htTimestamp >= 0L, "Need non-negative number for the scan,  timestamp got %s", htTimestamp);
            Preconditions.checkArgument(readMode == ReadMode.READ_AT_SNAPSHOT, "When specifying a HybridClock timestamp, the read mode needs to be set to READ_AT_SNAPSHOT");
        }
        this.client = client;
        this.table = table;
        this.readMode = readMode;
        this.scanRequestTimeout = scanRequestTimeout;
        this.columnRangePredicates = columnRangePredicates;
        this.limit = limit;
        this.cacheBlocks = cacheBlocks;
        this.prefetching = prefetching;
        this.startPrimaryKey = startPrimaryKey;
        this.endPrimaryKey = endPrimaryKey;
        this.htTimestamp = htTimestamp;
        this.batchSizeBytes = batchSizeBytes;
        if (!table.getPartitionSchema().isSimpleRangePartitioning() && (startPrimaryKey != AsyncKuduClient.EMPTY_ARRAY || endPrimaryKey != AsyncKuduClient.EMPTY_ARRAY) && PARTITION_PRUNE_WARN.getAndSet(false)) {
            LOG.warn("Starting full table scan. In the future this scan may be automatically optimized with partition pruning.");
        }
        if (table.getPartitionSchema().isSimpleRangePartitioning()) {
            if (endPartitionKey.length != 0 && Bytes.memcmp(startPrimaryKey, endPartitionKey) >= 0 || endPrimaryKey.length != 0 && Bytes.memcmp(startPartitionKey, endPrimaryKey) >= 0) {
                this.nextPartitionKey = startPartitionKey;
                this.endPartitionKey = endPartitionKey;
            } else {
                this.nextPartitionKey = Bytes.memcmp(startPartitionKey, startPrimaryKey) < 0 ? startPrimaryKey : startPartitionKey;
                this.endPartitionKey = endPrimaryKey.length != 0 && Bytes.memcmp(endPartitionKey, endPrimaryKey) > 0 ? endPrimaryKey : endPartitionKey;
            }
        } else {
            this.nextPartitionKey = startPartitionKey;
            this.endPartitionKey = endPartitionKey;
        }
        if (projectedNames != null) {
            ArrayList<ColumnSchema> columns = new ArrayList<ColumnSchema>();
            for (String columnName : projectedNames) {
                ColumnSchema columnSchema = table.getSchema().getColumn(columnName);
                if (columnSchema == null) {
                    throw new IllegalArgumentException("Unknown column " + columnName);
                }
                columns.add(columnSchema);
            }
            this.schema = new Schema(columns);
        } else if (projectedIndexes != null) {
            ArrayList<ColumnSchema> columns = new ArrayList<ColumnSchema>();
            for (Integer columnIndex : projectedIndexes) {
                ColumnSchema columnSchema = table.getSchema().getColumnByIndex(columnIndex);
                if (columnSchema == null) {
                    throw new IllegalArgumentException("Unknown column index " + columnIndex);
                }
                columns.add(columnSchema);
            }
            this.schema = new Schema(columns);
        } else {
            this.schema = table.getSchema();
        }
    }

    public long getLimit() {
        return this.limit;
    }

    public boolean hasMoreRows() {
        return this.hasMore;
    }

    public boolean getCacheBlocks() {
        return this.cacheBlocks;
    }

    public long getBatchSizeBytes() {
        return this.batchSizeBytes;
    }

    public ReadMode getReadMode() {
        return this.readMode;
    }

    long getSnapshotTimestamp() {
        return this.htTimestamp;
    }

    public Deferred<RowResultIterator> nextRows() {
        if (this.closed) {
            return Deferred.fromResult(null);
        }
        if (this.tablet == null) {
            return this.client.openScanner(this).addCallbackDeferring((Callback)new Callback<Deferred<RowResultIterator>, Response>(){

                public Deferred<RowResultIterator> call(Response resp) {
                    if (!resp.more || resp.scanner_id == null) {
                        AsyncKuduScanner.this.scanFinished();
                        return Deferred.fromResult((Object)resp.data);
                    }
                    AsyncKuduScanner.access$302(AsyncKuduScanner.this, resp.scanner_id);
                    AsyncKuduScanner.this.sequenceId++;
                    AsyncKuduScanner.this.hasMore = resp.more;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Scanner " + Bytes.pretty(AsyncKuduScanner.this.scannerId) + " opened on " + AsyncKuduScanner.this.tablet);
                    }
                    return Deferred.fromResult((Object)resp.data);
                }

                public String toString() {
                    return "scanner opened";
                }
            });
        }
        if (this.prefetching && this.prefetcherDeferred != null) {
            this.prefetcherDeferred.chain(new Deferred().addCallback(this.prefetch));
            return this.prefetcherDeferred;
        }
        Deferred d = this.client.scanNextRows(this).addCallbacks(this.got_next_row, this.nextRowErrback());
        if (this.prefetching) {
            d.chain(new Deferred().addCallback(this.prefetch));
        }
        return d;
    }

    private final Callback<Exception, Exception> nextRowErrback() {
        return new Callback<Exception, Exception>(){

            public Exception call(Exception error) {
                AsyncKuduClient.RemoteTablet old_tablet = AsyncKuduScanner.this.tablet;
                String message = old_tablet + " pretends to not know " + AsyncKuduScanner.this;
                LOG.warn(message, (Throwable)error);
                AsyncKuduScanner.this.invalidate();
                return error;
            }

            public String toString() {
                return "NextRow errback";
            }
        };
    }

    void scanFinished() {
        Partition partition = this.tablet.getPartition();
        if (partition.isEndPartition() || this.endPartitionKey != AsyncKuduClient.EMPTY_ARRAY && Bytes.memcmp(this.endPartitionKey, partition.getPartitionKeyEnd()) <= 0) {
            this.hasMore = false;
            this.closed = true;
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Done scanning tablet {} for partition {} with scanner id {}", new Object[]{this.tablet.getTabletIdAsString(), this.tablet.getPartition(), Bytes.pretty(this.scannerId)});
        }
        this.nextPartitionKey = partition.getPartitionKeyEnd();
        this.scannerId = null;
        this.invalidate();
    }

    public Deferred<RowResultIterator> close() {
        if (this.closed) {
            return Deferred.fromResult(null);
        }
        Deferred d = this.client.closeScanner(this).addCallback(this.closedCallback());
        return d;
    }

    private Callback<RowResultIterator, Response> closedCallback() {
        return new Callback<RowResultIterator, Response>(){

            public RowResultIterator call(Response response) {
                AsyncKuduScanner.this.closed = true;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Scanner " + Bytes.pretty(AsyncKuduScanner.this.scannerId) + " closed on " + AsyncKuduScanner.this.tablet);
                }
                AsyncKuduScanner.this.tablet = null;
                AsyncKuduScanner.access$302(AsyncKuduScanner.this, "client debug closed".getBytes());
                return response == null ? null : response.data;
            }

            public String toString() {
                return "scanner closed";
            }
        };
    }

    public String toString() {
        String tablet = this.tablet == null ? "null" : this.tablet.getTabletIdAsString();
        StringBuilder buf = new StringBuilder();
        buf.append("KuduScanner(table=");
        buf.append(this.table.getName());
        buf.append(", tablet=").append(tablet);
        buf.append(", scannerId=").append(Bytes.pretty(this.scannerId));
        buf.append(", scanRequestTimeout=").append(this.scanRequestTimeout);
        buf.append(')');
        return buf.toString();
    }

    KuduTable table() {
        return this.table;
    }

    void setTablet(AsyncKuduClient.RemoteTablet tablet) {
        this.tablet = tablet;
    }

    void invalidate() {
        this.tablet = null;
    }

    AsyncKuduClient.RemoteTablet currentTablet() {
        return this.tablet;
    }

    KuduRpc<Response> getOpenRequest() {
        this.checkScanningNotStarted();
        if (this.inFirstTablet) {
            this.inFirstTablet = false;
        }
        return new ScanRequest(this.table, State.OPENING);
    }

    KuduRpc<Response> getNextRowsRequest() {
        return new ScanRequest(this.table, State.NEXT);
    }

    KuduRpc<Response> getCloseRequest() {
        return new ScanRequest(this.table, State.CLOSING);
    }

    private void checkScanningNotStarted() {
        if (this.tablet != null) {
            throw new IllegalStateException("scanning already started");
        }
    }

    static /* synthetic */ byte[] access$302(AsyncKuduScanner x0, byte[] x1) {
        x0.scannerId = x1;
        return x1;
    }

    public static class AsyncKuduScannerBuilder
    extends AbstractKuduScannerBuilder<AsyncKuduScannerBuilder, AsyncKuduScanner> {
        AsyncKuduScannerBuilder(AsyncKuduClient client, KuduTable table) {
            super(client, table);
        }

        @Override
        public AsyncKuduScanner build() {
            return new AsyncKuduScanner(this.client, this.table, this.projectedColumnNames, this.projectedColumnIndexes, this.readMode, this.scanRequestTimeout, this.columnRangePredicates, this.limit, this.cacheBlocks, this.prefetching, this.lowerBoundPrimaryKey, this.upperBoundPrimaryKey, this.lowerBoundPartitionKey, this.upperBoundPartitionKey, this.htTimestamp, this.batchSizeBytes);
        }
    }

    private final class ScanRequest
    extends KuduRpc<Response>
    implements KuduRpc.HasKey {
        State state;

        ScanRequest(KuduTable table, State state) {
            super(table);
            this.state = state;
            this.setTimeoutMillis(AsyncKuduScanner.this.scanRequestTimeout);
        }

        @Override
        String serviceName() {
            return "kudu.tserver.TabletServerService";
        }

        @Override
        String method() {
            return "Scan";
        }

        @Override
        ChannelBuffer serialize(Message header) {
            Tserver.ScanRequestPB.Builder builder = Tserver.ScanRequestPB.newBuilder();
            switch (this.state) {
                case OPENING: {
                    AsyncKuduScanner.this.tablet = super.getTablet();
                    Tserver.NewScanRequestPB.Builder newBuilder = Tserver.NewScanRequestPB.newBuilder();
                    newBuilder.setLimit(AsyncKuduScanner.this.limit);
                    newBuilder.addAllProjectedColumns(ProtobufHelper.schemaToListPb(AsyncKuduScanner.this.schema));
                    newBuilder.setTabletId(ZeroCopyLiteralByteString.wrap(AsyncKuduScanner.this.tablet.getTabletIdAsBytes()));
                    newBuilder.setReadMode(AsyncKuduScanner.this.getReadMode().pbVersion());
                    newBuilder.setCacheBlocks(AsyncKuduScanner.this.cacheBlocks);
                    if (this.table.getAsyncClient().getLastPropagatedTimestamp() != -1L) {
                        newBuilder.setPropagatedTimestamp(this.table.getAsyncClient().getLastPropagatedTimestamp());
                    }
                    newBuilder.setReadMode(AsyncKuduScanner.this.getReadMode().pbVersion());
                    if (AsyncKuduScanner.this.getReadMode() == ReadMode.READ_AT_SNAPSHOT && AsyncKuduScanner.this.getSnapshotTimestamp() != -1L) {
                        newBuilder.setSnapTimestamp(AsyncKuduScanner.this.getSnapshotTimestamp());
                    }
                    if (AsyncKuduScanner.this.startPrimaryKey != AsyncKuduClient.EMPTY_ARRAY && AsyncKuduScanner.this.startPrimaryKey.length > 0) {
                        newBuilder.setStartPrimaryKey(ZeroCopyLiteralByteString.copyFrom(AsyncKuduScanner.this.startPrimaryKey));
                    }
                    if (AsyncKuduScanner.this.endPrimaryKey != AsyncKuduClient.EMPTY_ARRAY && AsyncKuduScanner.this.endPrimaryKey.length > 0) {
                        newBuilder.setStopPrimaryKey(ZeroCopyLiteralByteString.copyFrom(AsyncKuduScanner.this.endPrimaryKey));
                    }
                    if (!AsyncKuduScanner.this.columnRangePredicates.isEmpty()) {
                        newBuilder.addAllRangePredicates(AsyncKuduScanner.this.columnRangePredicates);
                    }
                    builder.setNewScanRequest(newBuilder.build()).setBatchSizeBytes(AsyncKuduScanner.this.batchSizeBytes);
                    break;
                }
                case NEXT: {
                    builder.setScannerId(ZeroCopyLiteralByteString.wrap(AsyncKuduScanner.this.scannerId)).setCallSeqId(AsyncKuduScanner.this.sequenceId).setBatchSizeBytes(AsyncKuduScanner.this.batchSizeBytes);
                    break;
                }
                case CLOSING: {
                    builder.setScannerId(ZeroCopyLiteralByteString.wrap(AsyncKuduScanner.this.scannerId)).setBatchSizeBytes(0).setCloseScanner(true);
                }
            }
            Tserver.ScanRequestPB request = builder.build();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Sending scan req: " + request.toString());
            }
            return ScanRequest.toChannelBuffer(header, request);
        }

        @Override
        Pair<Response, Object> deserialize(CallResponse callResponse, String tsUUID) throws Exception {
            Tserver.TabletServerErrorPB error;
            Tserver.ScanResponsePB.Builder builder = Tserver.ScanResponsePB.newBuilder();
            ScanRequest.readProtobuf(callResponse.getPBMessage(), builder);
            Tserver.ScanResponsePB resp = builder.build();
            byte[] id = resp.getScannerId().toByteArray();
            Tserver.TabletServerErrorPB tabletServerErrorPB = error = resp.hasError() ? resp.getError() : null;
            if (error != null && error.getCode().equals(Tserver.TabletServerErrorPB.Code.TABLET_NOT_FOUND)) {
                if (this.state == State.OPENING) {
                    return new Pair<Object, Tserver.TabletServerErrorPB>(null, error);
                }
                throw new NonRecoverableException("Cannot continue scanning, the tablet has moved and this isn't a fault tolerant scan");
            }
            RowResultIterator iterator = new RowResultIterator(this.deadlineTracker.getElapsedMillis(), tsUUID, AsyncKuduScanner.this.schema, resp.getData(), callResponse);
            boolean hasMore = resp.getHasMoreResults();
            if (id.length != 0 && AsyncKuduScanner.this.scannerId != null && !Bytes.equals(AsyncKuduScanner.this.scannerId, id)) {
                throw new InvalidResponseException("Scan RPC response was for scanner ID " + Bytes.pretty(id) + " but we expected " + Bytes.pretty(AsyncKuduScanner.this.scannerId), (Object)resp);
            }
            Response response = new Response(id, iterator, hasMore);
            if (LOG.isDebugEnabled()) {
                LOG.debug(response.toString());
            }
            return new Pair<Response, Object>(response, error);
        }

        @Override
        public String toString() {
            return "ScanRequest(scannerId=" + Bytes.pretty(AsyncKuduScanner.this.scannerId) + (AsyncKuduScanner.this.tablet != null ? ", tabletSlice=" + AsyncKuduScanner.this.tablet.getTabletIdAsString() : "") + ", attempt=" + this.attempt + ')';
        }

        @Override
        public byte[] partitionKey() {
            return AsyncKuduScanner.this.nextPartitionKey;
        }
    }

    private static enum State {
        OPENING,
        NEXT,
        CLOSING;

    }

    static final class Response {
        private final byte[] scanner_id;
        private final RowResultIterator data;
        private final boolean more;

        Response(byte[] scanner_id, RowResultIterator data, boolean more) {
            this.scanner_id = scanner_id;
            this.data = data;
            this.more = more;
        }

        public String toString() {
            return "AsyncKuduScanner$Response(scannerId=" + Bytes.pretty(this.scanner_id) + ", data=" + this.data + ", more=" + this.more + ") ";
        }
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public static enum ReadMode {
        READ_LATEST(Common.ReadMode.READ_LATEST),
        READ_AT_SNAPSHOT(Common.ReadMode.READ_AT_SNAPSHOT);

        private Common.ReadMode pbVersion;

        private ReadMode(Common.ReadMode pbVersion) {
            this.pbVersion = pbVersion;
        }

        @InterfaceAudience.Private
        public Common.ReadMode pbVersion() {
            return this.pbVersion;
        }
    }
}

