/*
 * Decompiled with CFR 0.152.
 */
package org.kududb.client;

import org.kududb.annotations.InterfaceAudience;
import org.kududb.client.AlterTableOptions;
import org.kududb.client.AlterTableResponse;
import org.kududb.client.CallResponse;
import org.kududb.client.KuduRpc;
import org.kududb.client.KuduTable;
import org.kududb.client.shaded.com.google.protobuf.Message;
import org.kududb.client.shaded.org.jboss.netty.buffer.ChannelBuffer;
import org.kududb.master.Master;
import org.kududb.util.Pair;

@InterfaceAudience.Private
class AlterTableRequest
extends KuduRpc<AlterTableResponse> {
    static final String ALTER_TABLE = "AlterTable";
    private final String name;
    private final Master.AlterTableRequestPB.Builder builder;

    AlterTableRequest(KuduTable masterTable, String name, AlterTableOptions ato) {
        super(masterTable);
        this.name = name;
        this.builder = ato.pb;
    }

    @Override
    ChannelBuffer serialize(Message header) {
        assert (header.isInitialized());
        Master.TableIdentifierPB tableID = Master.TableIdentifierPB.newBuilder().setTableName(this.name).build();
        this.builder.setTable(tableID);
        return AlterTableRequest.toChannelBuffer(header, this.builder.build());
    }

    @Override
    String serviceName() {
        return "kudu.master.MasterService";
    }

    @Override
    String method() {
        return ALTER_TABLE;
    }

    @Override
    Pair<AlterTableResponse, Object> deserialize(CallResponse callResponse, String tsUUID) throws Exception {
        Master.AlterTableResponsePB.Builder respBuilder = Master.AlterTableResponsePB.newBuilder();
        AlterTableRequest.readProtobuf(callResponse.getPBMessage(), respBuilder);
        AlterTableResponse response = new AlterTableResponse(this.deadlineTracker.getElapsedMillis(), tsUUID);
        return new Pair<AlterTableResponse, Object>(response, respBuilder.hasError() ? respBuilder.getError() : null);
    }
}

