/*
 * Decompiled with CFR 0.152.
 */
package org.kududb.client;

import org.kududb.ColumnSchema;
import org.kududb.Type;
import org.kududb.annotations.InterfaceAudience;
import org.kududb.annotations.InterfaceStability;
import org.kududb.client.ProtobufHelper;
import org.kududb.master.Master;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public class AlterTableOptions {
    Master.AlterTableRequestPB.Builder pb = Master.AlterTableRequestPB.newBuilder();

    public AlterTableOptions renameTable(String newName) {
        this.pb.setNewTableName(newName);
        return this;
    }

    public AlterTableOptions addColumn(String name, Type type, Object defaultVal) {
        if (defaultVal == null) {
            throw new IllegalArgumentException("A new column must have a default value, use addNullableColumn() to add a NULLABLE column");
        }
        Master.AlterTableRequestPB.Step.Builder step = this.pb.addAlterSchemaStepsBuilder();
        step.setType(Master.AlterTableRequestPB.StepType.ADD_COLUMN);
        step.setAddColumn(Master.AlterTableRequestPB.AddColumn.newBuilder().setSchema(ProtobufHelper.columnToPb(new ColumnSchema.ColumnSchemaBuilder(name, type).defaultValue(defaultVal).build())));
        return this;
    }

    public AlterTableOptions addNullableColumn(String name, Type type) {
        Master.AlterTableRequestPB.Step.Builder step = this.pb.addAlterSchemaStepsBuilder();
        step.setType(Master.AlterTableRequestPB.StepType.ADD_COLUMN);
        step.setAddColumn(Master.AlterTableRequestPB.AddColumn.newBuilder().setSchema(ProtobufHelper.columnToPb(new ColumnSchema.ColumnSchemaBuilder(name, type).nullable(true).build())));
        return this;
    }

    public AlterTableOptions dropColumn(String name) {
        Master.AlterTableRequestPB.Step.Builder step = this.pb.addAlterSchemaStepsBuilder();
        step.setType(Master.AlterTableRequestPB.StepType.DROP_COLUMN);
        step.setDropColumn(Master.AlterTableRequestPB.DropColumn.newBuilder().setName(name));
        return this;
    }

    public AlterTableOptions renameColumn(String oldName, String newName) {
        Master.AlterTableRequestPB.Step.Builder step = this.pb.addAlterSchemaStepsBuilder();
        step.setType(Master.AlterTableRequestPB.StepType.RENAME_COLUMN);
        step.setRenameColumn(Master.AlterTableRequestPB.RenameColumn.newBuilder().setOldName(oldName).setNewName(newName));
        return this;
    }
}

