/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.linq4j.expressions;

import net.hydromatic.linq4j.expressions.Blocks;
import net.hydromatic.linq4j.expressions.Expression;
import net.hydromatic.linq4j.expressions.ExpressionType;
import net.hydromatic.linq4j.expressions.ExpressionWriter;
import net.hydromatic.linq4j.expressions.Statement;
import net.hydromatic.linq4j.expressions.Visitor;

public class WhileStatement
extends Statement {
    public final Expression condition;
    public final Statement body;

    public WhileStatement(Expression condition, Statement body) {
        super(ExpressionType.While, Void.TYPE);
        assert (condition != null) : "condition should not be null";
        assert (body != null) : "body should not be null";
        this.condition = condition;
        this.body = body;
    }

    public Statement accept(Visitor visitor) {
        visitor = visitor.preVisit(this);
        Expression condition1 = this.condition.accept(visitor);
        Statement body1 = this.body.accept(visitor);
        return visitor.visit(this, condition1, body1);
    }

    void accept0(ExpressionWriter writer) {
        writer.append("while (").append(this.condition).append(") ").append(Blocks.toBlock(this.body));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        WhileStatement that = (WhileStatement)o;
        if (!this.body.equals(that.body)) {
            return false;
        }
        return this.condition.equals(that.condition);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.condition.hashCode();
        result = 31 * result + this.body.hashCode();
        return result;
    }
}

