/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.jdbc.impl;

import java.sql.ParameterMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import oadd.net.hydromatic.avatica.AvaticaParameter;
import oadd.net.hydromatic.avatica.AvaticaPrepareResult;
import oadd.net.hydromatic.avatica.AvaticaPreparedStatement;
import org.apache.drill.jdbc.AlreadyClosedSqlException;
import org.apache.drill.jdbc.DrillPreparedStatement;
import org.apache.drill.jdbc.impl.DrillConnectionImpl;
import org.apache.drill.jdbc.impl.DrillRemoteStatement;

abstract class DrillPreparedStatementImpl
extends AvaticaPreparedStatement
implements DrillPreparedStatement,
DrillRemoteStatement {
    protected DrillPreparedStatementImpl(DrillConnectionImpl connection, AvaticaPrepareResult prepareResult, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        super(connection, prepareResult, resultSetType, resultSetConcurrency, resultSetHoldability);
        connection.openStatementsRegistry.addStatement(this);
    }

    private void throwIfClosed() throws AlreadyClosedSqlException {
        if (this.isClosed()) {
            throw new AlreadyClosedSqlException("PreparedStatement is already closed.");
        }
    }

    @Override
    public DrillConnectionImpl getConnection() {
        try {
            this.throwIfClosed();
        }
        catch (AlreadyClosedSqlException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return (DrillConnectionImpl)super.getConnection();
    }

    @Override
    protected AvaticaParameter getParameter(int param) throws SQLException {
        this.throwIfClosed();
        throw new SQLFeatureNotSupportedException("Prepared-statement dynamic parameters are not supported.");
    }

    @Override
    public void cleanUp() {
        DrillConnectionImpl connection1 = (DrillConnectionImpl)this.connection;
        connection1.openStatementsRegistry.removeStatement(this);
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        this.throwIfClosed();
        try {
            return super.executeQuery(sql);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        this.throwIfClosed();
        try {
            return super.executeUpdate(sql);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        this.throwIfClosed();
        try {
            return super.getMaxFieldSize();
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this.throwIfClosed();
        try {
            super.setMaxFieldSize(max);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public int getMaxRows() {
        try {
            this.throwIfClosed();
        }
        catch (AlreadyClosedSqlException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return super.getMaxRows();
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.throwIfClosed();
        super.setMaxRows(max);
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.throwIfClosed();
        try {
            super.setEscapeProcessing(enable);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        this.throwIfClosed();
        return super.getQueryTimeout();
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.throwIfClosed();
        super.setQueryTimeout(seconds);
    }

    @Override
    public void cancel() throws SQLException {
        this.throwIfClosed();
        super.cancel();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.throwIfClosed();
        return super.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.throwIfClosed();
        super.clearWarnings();
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        this.throwIfClosed();
        try {
            super.setCursorName(name);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        this.throwIfClosed();
        return super.execute(sql);
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        this.throwIfClosed();
        return super.getResultSet();
    }

    @Override
    public int getUpdateCount() throws SQLException {
        this.throwIfClosed();
        return super.getUpdateCount();
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        this.throwIfClosed();
        try {
            return super.getMoreResults();
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.throwIfClosed();
        super.setFetchDirection(direction);
    }

    @Override
    public int getFetchDirection() {
        try {
            this.throwIfClosed();
        }
        catch (AlreadyClosedSqlException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return super.getFetchDirection();
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.throwIfClosed();
        super.setFetchSize(rows);
    }

    @Override
    public int getFetchSize() {
        try {
            this.throwIfClosed();
        }
        catch (AlreadyClosedSqlException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return super.getFetchSize();
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        this.throwIfClosed();
        try {
            return super.getResultSetConcurrency();
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public int getResultSetType() throws SQLException {
        this.throwIfClosed();
        try {
            return super.getResultSetType();
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.throwIfClosed();
        try {
            super.addBatch(sql);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void clearBatch() throws SQLException {
        this.throwIfClosed();
        try {
            super.clearBatch();
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public int[] executeBatch() throws SQLException {
        this.throwIfClosed();
        try {
            return super.executeBatch();
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        this.throwIfClosed();
        try {
            return super.getMoreResults(current);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        this.throwIfClosed();
        try {
            return super.getGeneratedKeys();
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        this.throwIfClosed();
        try {
            return super.executeUpdate(sql, autoGeneratedKeys);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        this.throwIfClosed();
        try {
            return super.executeUpdate(sql, columnIndexes);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        this.throwIfClosed();
        try {
            return super.executeUpdate(sql, columnNames);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        this.throwIfClosed();
        try {
            return super.execute(sql, autoGeneratedKeys);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        this.throwIfClosed();
        try {
            return super.execute(sql, columnIndexes);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        this.throwIfClosed();
        try {
            return super.execute(sql, columnNames);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        this.throwIfClosed();
        try {
            return super.getResultSetHoldability();
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public boolean isClosed() {
        try {
            return super.isClosed();
        }
        catch (SQLException e) {
            throw new RuntimeException("Unexpected " + e + " from AvaticaPreparedStatement.isClosed");
        }
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        this.throwIfClosed();
        try {
            super.setPoolable(poolable);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public boolean isPoolable() throws SQLException {
        this.throwIfClosed();
        try {
            return super.isPoolable();
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        this.throwIfClosed();
        super.closeOnCompletion();
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        this.throwIfClosed();
        return super.isCloseOnCompletion();
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        this.throwIfClosed();
        return super.executeQuery();
    }

    @Override
    public int executeUpdate() throws SQLException {
        this.throwIfClosed();
        try {
            return super.executeUpdate();
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void clearParameters() throws SQLException {
        this.throwIfClosed();
        try {
            super.clearParameters();
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public boolean execute() throws SQLException {
        this.throwIfClosed();
        try {
            return super.execute();
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void addBatch() throws SQLException {
        this.throwIfClosed();
        try {
            super.addBatch();
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public ResultSetMetaData getMetaData() {
        try {
            this.throwIfClosed();
        }
        catch (AlreadyClosedSqlException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return super.getMetaData();
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        this.throwIfClosed();
        return super.getParameterMetaData();
    }
}

