/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.jdbc.impl;

import java.sql.SQLException;
import oadd.net.hydromatic.avatica.Cursor;
import oadd.org.apache.drill.exec.expr.TypeHelper;
import oadd.org.apache.drill.exec.record.RecordBatchLoader;
import oadd.org.apache.drill.exec.vector.ValueVector;
import oadd.org.apache.drill.exec.vector.accessor.BoundCheckingAccessor;
import org.apache.drill.jdbc.JdbcApiSqlException;
import org.apache.drill.jdbc.impl.AvaticaDrillSqlAccessor;
import org.apache.drill.jdbc.impl.BasicList;
import org.apache.drill.jdbc.impl.DrillCursor;
import org.apache.drill.jdbc.impl.TypeConvertingSqlAccessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DrillAccessorList
extends BasicList<Cursor.Accessor> {
    private static final Logger logger = LoggerFactory.getLogger(DrillAccessorList.class);
    private static final int NULL_LAST_COLUMN_INDEX = -2;
    private AvaticaDrillSqlAccessor[] accessors = new AvaticaDrillSqlAccessor[0];
    private int rowLastColumnOffset = -2;

    DrillAccessorList() {
    }

    void clearLastColumnIndexedInRow() {
        this.rowLastColumnOffset = -2;
    }

    void generateAccessors(DrillCursor cursor, RecordBatchLoader currentBatch) {
        int cnt = currentBatch.getSchema().getFieldCount();
        this.accessors = new AvaticaDrillSqlAccessor[cnt];
        for (int i = 0; i < cnt; ++i) {
            Object vector = currentBatch.getValueAccessorById(null, i).getValueVector();
            TypeConvertingSqlAccessor acc = new TypeConvertingSqlAccessor(new BoundCheckingAccessor((ValueVector)vector, TypeHelper.getSqlAccessor(vector)));
            this.accessors[i] = new AvaticaDrillSqlAccessor(acc, cursor);
        }
        this.clearLastColumnIndexedInRow();
    }

    @Override
    public AvaticaDrillSqlAccessor get(int accessorOffset) {
        AvaticaDrillSqlAccessor accessor = this.accessors[accessorOffset];
        this.rowLastColumnOffset = accessorOffset;
        return accessor;
    }

    boolean wasNull() throws SQLException {
        if (-2 == this.rowLastColumnOffset) {
            throw new JdbcApiSqlException("ResultSet.wasNull() called without a preceding call to a column getter method since the last call to ResultSet.next()");
        }
        return this.accessors[this.rowLastColumnOffset].wasNull();
    }

    @Override
    public int size() {
        return this.accessors.length;
    }
}

