/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.reflections.util;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.servlet.ServletContext;
import oadd.com.google.common.collect.Sets;
import oadd.org.reflections.Reflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ClasspathHelper {
    public static ClassLoader contextClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public static ClassLoader staticClassLoader() {
        return Reflections.class.getClassLoader();
    }

    public static ClassLoader[] classLoaders(ClassLoader ... classLoaders) {
        ClassLoader[] classLoaderArray;
        ClassLoader staticClassLoader;
        if (classLoaders != null && classLoaders.length != 0) {
            return classLoaders;
        }
        ClassLoader contextClassLoader = ClasspathHelper.contextClassLoader();
        if (contextClassLoader != (staticClassLoader = ClasspathHelper.staticClassLoader())) {
            ClassLoader[] classLoaderArray2 = new ClassLoader[2];
            classLoaderArray2[0] = contextClassLoader;
            classLoaderArray = classLoaderArray2;
            classLoaderArray2[1] = staticClassLoader;
        } else {
            ClassLoader[] classLoaderArray3 = new ClassLoader[1];
            classLoaderArray = classLoaderArray3;
            classLoaderArray3[0] = contextClassLoader;
        }
        return classLoaderArray;
    }

    public static Set<URL> forPackage(String name, ClassLoader ... classLoaders) {
        HashSet<URL> result = Sets.newHashSet();
        ClassLoader[] loaders = ClasspathHelper.classLoaders(classLoaders);
        String resourceName = ClasspathHelper.resourceName(name);
        for (ClassLoader classLoader : loaders) {
            try {
                Enumeration<URL> urls = classLoader.getResources(resourceName);
                while (urls.hasMoreElements()) {
                    URL url = urls.nextElement();
                    int index = url.toExternalForm().lastIndexOf(resourceName);
                    if (index != -1) {
                        result.add(new URL(url.toExternalForm().substring(0, index)));
                        continue;
                    }
                    result.add(url);
                }
            }
            catch (IOException e) {
                if (Reflections.log == null) continue;
                Reflections.log.error("error getting resources for package " + name, e);
            }
        }
        return result;
    }

    public static URL forClass(Class<?> aClass, ClassLoader ... classLoaders) {
        ClassLoader[] loaders = ClasspathHelper.classLoaders(classLoaders);
        String resourceName = aClass.getName().replace(".", "/") + ".class";
        for (ClassLoader classLoader : loaders) {
            try {
                URL url = classLoader.getResource(resourceName);
                if (url == null) continue;
                String normalizedUrl = url.toExternalForm().substring(0, url.toExternalForm().lastIndexOf(aClass.getPackage().getName().replace(".", "/")));
                return new URL(normalizedUrl);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static Set<URL> forClassLoader(ClassLoader ... classLoaders) {
        ClassLoader[] loaders;
        HashSet<URL> result = Sets.newHashSet();
        ClassLoader[] arr$ = loaders = ClasspathHelper.classLoaders(classLoaders);
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            for (ClassLoader classLoader = arr$[i$]; classLoader != null; classLoader = classLoader.getParent()) {
                URL[] urls;
                if (!(classLoader instanceof URLClassLoader) || (urls = ((URLClassLoader)classLoader).getURLs()) == null) continue;
                result.addAll(Sets.newHashSet(urls));
            }
        }
        return result;
    }

    public static Set<URL> forJavaClassPath() {
        HashSet<URL> urls = Sets.newHashSet();
        String javaClassPath = System.getProperty("java.class.path");
        if (javaClassPath != null) {
            for (String path : javaClassPath.split(File.pathSeparator)) {
                try {
                    urls.add(new File(path).toURI().toURL());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return urls;
    }

    public static Set<URL> forWebInfLib(ServletContext servletContext) {
        HashSet<URL> urls = Sets.newHashSet();
        for (Object urlString : servletContext.getResourcePaths("/WEB-INF/lib")) {
            try {
                urls.add(servletContext.getResource((String)urlString));
            }
            catch (MalformedURLException e) {}
        }
        return urls;
    }

    public static URL forWebInfClasses(ServletContext servletContext) {
        block4: {
            try {
                String path = servletContext.getRealPath("/WEB-INF/classes");
                if (path != null) {
                    File file = new File(path);
                    if (file.exists()) {
                        return file.toURL();
                    }
                    break block4;
                }
                return servletContext.getResource("/WEB-INF/classes");
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return null;
    }

    public static Set<URL> forManifest() {
        return ClasspathHelper.forManifest(ClasspathHelper.forClassLoader(new ClassLoader[0]));
    }

    public static Set<URL> forManifest(URL url) {
        HashSet<URL> result = Sets.newHashSet();
        result.add(url);
        try {
            String classPath;
            Manifest manifest;
            String part = ClasspathHelper.cleanPath(url);
            File jarFile = new File(part);
            JarFile myJar = new JarFile(part);
            URL validUrl = ClasspathHelper.tryToGetValidUrl(jarFile.getPath(), new File(part).getParent(), part);
            if (validUrl != null) {
                result.add(validUrl);
            }
            if ((manifest = myJar.getManifest()) != null && (classPath = manifest.getMainAttributes().getValue(new Attributes.Name("Class-Path"))) != null) {
                for (String jar : classPath.split(" ")) {
                    validUrl = ClasspathHelper.tryToGetValidUrl(jarFile.getPath(), new File(part).getParent(), jar);
                    if (validUrl == null) continue;
                    result.add(validUrl);
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    public static Set<URL> forManifest(Iterable<URL> urls) {
        HashSet<URL> result = Sets.newHashSet();
        for (URL url : urls) {
            result.addAll(ClasspathHelper.forManifest(url));
        }
        return result;
    }

    static URL tryToGetValidUrl(String workingDir, String path, String filename) {
        try {
            if (new File(filename).exists()) {
                return new File(filename).toURI().toURL();
            }
            if (new File(path + File.separator + filename).exists()) {
                return new File(path + File.separator + filename).toURI().toURL();
            }
            if (new File(workingDir + File.separator + filename).exists()) {
                return new File(workingDir + File.separator + filename).toURI().toURL();
            }
            if (new File(new URL(filename).getFile()).exists()) {
                return new File(new URL(filename).getFile()).toURI().toURL();
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return null;
    }

    public static String cleanPath(URL url) {
        String path = url.getPath();
        try {
            path = URLDecoder.decode(path, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        if (path.startsWith("jar:")) {
            path = path.substring("jar:".length());
        }
        if (path.startsWith("file:")) {
            path = path.substring("file:".length());
        }
        if (path.endsWith("!/")) {
            path = path.substring(0, path.lastIndexOf("!/")) + "/";
        }
        return path;
    }

    private static String resourceName(String name) {
        if (name != null) {
            String resourceName = name.replace(".", "/");
            if ((resourceName = resourceName.replace("\\", "/")).startsWith("/")) {
                resourceName = resourceName.substring(1);
            }
            return resourceName;
        }
        return name;
    }
}

