/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.reflections.scanners;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oadd.com.google.common.collect.Sets;
import oadd.org.reflections.scanners.AbstractScanner;
import oadd.org.reflections.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConvertersScanner
extends AbstractScanner {
    @Override
    public void scan(Object cls) {
        List methods = this.getMetadataAdapter().getMethods(cls);
        for (Object method : methods) {
            List<String> parameterNames = this.getMetadataAdapter().getParameterNames(method);
            if (parameterNames.size() != 1) continue;
            String from = parameterNames.get(0);
            String to = this.getMetadataAdapter().getReturnTypeName(method);
            if (to.equals("void") || !this.acceptResult(from) && !this.acceptResult(to)) continue;
            String methodKey = this.getMetadataAdapter().getMethodFullKey(cls, method);
            this.getStore().put(ConvertersScanner.getConverterKey(from, to), methodKey);
        }
    }

    public static String getConverterKey(String from, String to) {
        return from + " to " + to;
    }

    public static String getConverterKey(Class<?> from, Class<?> to) {
        return ConvertersScanner.getConverterKey(from.getName(), to.getName());
    }

    public Set<Method> getConverters(Class<?> from, Class<?> to) {
        HashSet<Method> result = Sets.newHashSet();
        for (String converter : this.getStore().get(ConvertersScanner.getConverterKey(from, to))) {
            result.add(Utils.getMethodFromDescriptor(converter, this.getConfiguration().getClassLoaders()));
        }
        return result;
    }
}

