/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.zookeeper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oadd.org.apache.jute.InputArchive;
import oadd.org.apache.jute.OutputArchive;
import oadd.org.apache.jute.Record;
import oadd.org.apache.zookeeper.Op;
import oadd.org.apache.zookeeper.proto.CheckVersionRequest;
import oadd.org.apache.zookeeper.proto.CreateRequest;
import oadd.org.apache.zookeeper.proto.DeleteRequest;
import oadd.org.apache.zookeeper.proto.MultiHeader;
import oadd.org.apache.zookeeper.proto.SetDataRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiTransactionRecord
implements Record,
Iterable<Op> {
    private List<Op> ops = new ArrayList<Op>();

    public MultiTransactionRecord() {
    }

    public MultiTransactionRecord(Iterable<Op> ops) {
        for (Op op : ops) {
            this.add(op);
        }
    }

    @Override
    public Iterator<Op> iterator() {
        return this.ops.iterator();
    }

    public void add(Op op) {
        this.ops.add(op);
    }

    public int size() {
        return this.ops.size();
    }

    @Override
    public void serialize(OutputArchive archive, String tag) throws IOException {
        archive.startRecord(this, tag);
        boolean index = false;
        block6: for (Op op : this.ops) {
            MultiHeader h = new MultiHeader(op.getType(), false, -1);
            h.serialize(archive, tag);
            switch (op.getType()) {
                case 1: {
                    op.toRequestRecord().serialize(archive, tag);
                    continue block6;
                }
                case 2: {
                    op.toRequestRecord().serialize(archive, tag);
                    continue block6;
                }
                case 5: {
                    op.toRequestRecord().serialize(archive, tag);
                    continue block6;
                }
                case 13: {
                    op.toRequestRecord().serialize(archive, tag);
                    continue block6;
                }
            }
            throw new IOException("Invalid type of op");
        }
        new MultiHeader(-1, true, -1).serialize(archive, tag);
        archive.endRecord(this, tag);
    }

    @Override
    public void deserialize(InputArchive archive, String tag) throws IOException {
        archive.startRecord(tag);
        MultiHeader h = new MultiHeader();
        h.deserialize(archive, tag);
        while (!h.getDone()) {
            switch (h.getType()) {
                case 1: {
                    CreateRequest cr = new CreateRequest();
                    cr.deserialize(archive, tag);
                    this.add(Op.create(cr.getPath(), cr.getData(), cr.getAcl(), cr.getFlags()));
                    break;
                }
                case 2: {
                    DeleteRequest dr = new DeleteRequest();
                    dr.deserialize(archive, tag);
                    this.add(Op.delete(dr.getPath(), dr.getVersion()));
                    break;
                }
                case 5: {
                    SetDataRequest sdr = new SetDataRequest();
                    sdr.deserialize(archive, tag);
                    this.add(Op.setData(sdr.getPath(), sdr.getData(), sdr.getVersion()));
                    break;
                }
                case 13: {
                    CheckVersionRequest cvr = new CheckVersionRequest();
                    cvr.deserialize(archive, tag);
                    this.add(Op.check(cvr.getPath(), cvr.getVersion()));
                    break;
                }
                default: {
                    throw new IOException("Invalid type of op");
                }
            }
            h.deserialize(archive, tag);
        }
        archive.endRecord(tag);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MultiTransactionRecord)) {
            return false;
        }
        MultiTransactionRecord that = (MultiTransactionRecord)o;
        if (this.ops != null) {
            Iterator<Op> other = that.ops.iterator();
            for (Op op : this.ops) {
                boolean hasMoreData = other.hasNext();
                if (!hasMoreData) {
                    return false;
                }
                Op otherOp = other.next();
                if (op.equals(otherOp)) continue;
                return false;
            }
            return !other.hasNext();
        }
        return that.ops == null;
    }

    public int hashCode() {
        int h = 1023;
        for (Op op : this.ops) {
            h = h * 25 + op.hashCode();
        }
        return h;
    }
}

