/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.work.fragment;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import oadd.com.google.common.base.Preconditions;
import oadd.org.apache.drill.common.exceptions.ExecutionSetupException;
import oadd.org.apache.drill.exec.exception.FragmentSetupException;
import oadd.org.apache.drill.exec.ops.FragmentContext;
import oadd.org.apache.drill.exec.proto.BitControl;
import oadd.org.apache.drill.exec.proto.ExecProtos;
import oadd.org.apache.drill.exec.rpc.RemoteConnection;
import oadd.org.apache.drill.exec.rpc.data.IncomingDataBatch;
import oadd.org.apache.drill.exec.server.DrillbitContext;
import oadd.org.apache.drill.exec.work.batch.IncomingBuffers;
import oadd.org.apache.drill.exec.work.foreman.ForemanException;
import oadd.org.apache.drill.exec.work.fragment.FragmentExecutor;
import oadd.org.apache.drill.exec.work.fragment.FragmentManager;
import oadd.org.apache.drill.exec.work.fragment.FragmentStatusReporter;

public class NonRootFragmentManager
implements FragmentManager {
    private final IncomingBuffers buffers;
    private final FragmentExecutor runner;
    private final ExecProtos.FragmentHandle handle;
    private volatile boolean cancel = false;
    private final FragmentContext context;
    private final List<RemoteConnection> connections = new CopyOnWriteArrayList<RemoteConnection>();
    private volatile boolean runnerRetrieved = false;

    public NonRootFragmentManager(BitControl.PlanFragment fragment, DrillbitContext context) throws ExecutionSetupException {
        try {
            this.handle = fragment.getHandle();
            this.context = new FragmentContext(context, fragment, context.getFunctionImplementationRegistry());
            this.buffers = new IncomingBuffers(fragment, this.context);
            FragmentStatusReporter reporter = new FragmentStatusReporter(this.context, context.getController().getTunnel(fragment.getForeman()));
            this.runner = new FragmentExecutor(this.context, fragment, reporter);
            this.context.setBuffers(this.buffers);
        }
        catch (ForemanException e) {
            throw new FragmentSetupException("Failure while decoding fragment.", e);
        }
    }

    @Override
    public boolean handle(IncomingDataBatch batch) throws FragmentSetupException, IOException {
        return this.buffers.batchArrived(batch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FragmentExecutor getRunnable() {
        NonRootFragmentManager nonRootFragmentManager = this;
        synchronized (nonRootFragmentManager) {
            Preconditions.checkArgument(!this.runnerRetrieved, "Get Runnable can only be run once.");
            if (this.cancel) {
                return null;
            }
            this.runnerRetrieved = true;
            return this.runner;
        }
    }

    @Override
    public void receivingFragmentFinished(ExecProtos.FragmentHandle handle) {
        this.runner.receivingFragmentFinished(handle);
    }

    @Override
    public synchronized void cancel() {
        this.cancel = true;
        this.runner.cancel();
    }

    @Override
    public boolean isCancelled() {
        return this.cancel;
    }

    @Override
    public void unpause() {
        this.runner.unpause();
    }

    @Override
    public ExecProtos.FragmentHandle getHandle() {
        return this.handle;
    }

    @Override
    public boolean isWaiting() {
        return !this.buffers.isDone() && !this.cancel;
    }

    @Override
    public FragmentContext getFragmentContext() {
        return this.context;
    }

    @Override
    public void addConnection(RemoteConnection connection) {
        this.connections.add(connection);
    }

    @Override
    public void setAutoRead(boolean autoRead) {
        for (RemoteConnection c : this.connections) {
            c.setAutoRead(autoRead);
        }
    }
}

