/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.work.fragment;

import oadd.org.apache.drill.common.exceptions.UserException;
import oadd.org.apache.drill.exec.ops.FragmentContext;
import oadd.org.apache.drill.exec.proto.BitControl;
import oadd.org.apache.drill.exec.proto.UserBitShared;
import oadd.org.apache.drill.exec.proto.helper.QueryIdHelper;
import oadd.org.apache.drill.exec.rpc.control.ControlTunnel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FragmentStatusReporter {
    private static final Logger logger = LoggerFactory.getLogger(FragmentStatusReporter.class);
    private final FragmentContext context;
    private final ControlTunnel tunnel;

    public FragmentStatusReporter(FragmentContext context, ControlTunnel tunnel) {
        this.context = context;
        this.tunnel = tunnel;
    }

    BitControl.FragmentStatus getStatus(UserBitShared.FragmentState state) {
        return this.getStatus(state, null);
    }

    private BitControl.FragmentStatus getStatus(UserBitShared.FragmentState state, UserException ex) {
        BitControl.FragmentStatus.Builder status = BitControl.FragmentStatus.newBuilder();
        UserBitShared.MinorFragmentProfile.Builder b = UserBitShared.MinorFragmentProfile.newBuilder();
        this.context.getStats().addMetricsToStatus(b);
        b.setState(state);
        if (ex != null) {
            boolean verbose = this.context.getOptions().getOption((String)"exec.errors.verbose").bool_val;
            b.setError(ex.getOrCreatePBError(verbose));
        }
        status.setHandle(this.context.getHandle());
        b.setMemoryUsed(this.context.getAllocator().getAllocatedMemory());
        b.setMinorFragmentId(this.context.getHandle().getMinorFragmentId());
        status.setProfile(b);
        return status.build();
    }

    void stateChanged(UserBitShared.FragmentState newState) {
        BitControl.FragmentStatus status = this.getStatus(newState, null);
        logger.info("{}: State to report: {}", (Object)QueryIdHelper.getQueryIdentifier(this.context.getHandle()), (Object)newState);
        switch (newState) {
            case AWAITING_ALLOCATION: 
            case CANCELLATION_REQUESTED: 
            case CANCELLED: 
            case FINISHED: 
            case RUNNING: {
                this.sendStatus(status);
                break;
            }
            case SENDING: {
                break;
            }
            default: {
                throw new IllegalStateException(String.format("Received state changed event for unexpected state of %s.", newState));
            }
        }
    }

    private void sendStatus(BitControl.FragmentStatus status) {
        this.tunnel.sendFragmentStatus(status);
    }

    void fail(UserException ex) {
        BitControl.FragmentStatus status = this.getStatus(UserBitShared.FragmentState.FAILED, ex);
        this.sendStatus(status);
    }
}

