/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.work.batch;

import java.util.Queue;
import oadd.com.google.common.annotations.VisibleForTesting;
import oadd.com.google.common.collect.Queues;
import oadd.org.apache.drill.exec.rpc.data.AckSender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseSenderQueue {
    static final Logger logger = LoggerFactory.getLogger(ResponseSenderQueue.class);
    private Queue<AckSender> q = Queues.newConcurrentLinkedQueue();

    public void enqueueResponse(AckSender sender) {
        this.q.add(sender);
    }

    public void flushResponses() {
        this.flushResponses(Integer.MAX_VALUE);
    }

    public int flushResponses(int count) {
        int i;
        logger.trace("queue.size: {}, count: {}", (Object)this.q.size(), (Object)count);
        for (i = 0; !this.q.isEmpty() && i < count; ++i) {
            AckSender s = this.q.poll();
            if (s == null) continue;
            s.sendOk();
        }
        return i;
    }

    @VisibleForTesting
    boolean isEmpty() {
        return this.q.isEmpty();
    }
}

