/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.work.batch;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import oadd.com.google.common.collect.ImmutableMap;
import oadd.com.google.common.collect.Maps;
import oadd.org.apache.drill.common.AutoCloseables;
import oadd.org.apache.drill.common.concurrent.AutoCloseableLock;
import oadd.org.apache.drill.exec.exception.FragmentSetupException;
import oadd.org.apache.drill.exec.ops.FragmentContext;
import oadd.org.apache.drill.exec.proto.BitControl;
import oadd.org.apache.drill.exec.record.RawFragmentBatch;
import oadd.org.apache.drill.exec.rpc.data.IncomingDataBatch;
import oadd.org.apache.drill.exec.work.batch.AbstractDataCollector;
import oadd.org.apache.drill.exec.work.batch.DataCollector;
import oadd.org.apache.drill.exec.work.batch.MergingCollector;
import oadd.org.apache.drill.exec.work.batch.PartitionedCollector;
import oadd.org.apache.drill.exec.work.batch.RawBatchBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IncomingBuffers
implements AutoCloseable {
    static final Logger logger = LoggerFactory.getLogger(IncomingBuffers.class);
    private volatile boolean closed = false;
    private final AtomicInteger streamsRemaining = new AtomicInteger(0);
    private final AtomicInteger remainingRequired;
    private final Map<Integer, DataCollector> collectorMap;
    private final FragmentContext context;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final AutoCloseableLock sharedIncomingBatchLock = new AutoCloseableLock(this.lock.readLock());
    private final AutoCloseableLock exclusiveCloseLock = new AutoCloseableLock(this.lock.writeLock());

    public IncomingBuffers(BitControl.PlanFragment fragment, FragmentContext context) {
        this.context = context;
        HashMap<Integer, MergingCollector> collectors = Maps.newHashMap();
        this.remainingRequired = new AtomicInteger(fragment.getCollectorCount());
        for (int i = 0; i < fragment.getCollectorCount(); ++i) {
            BitControl.Collector collector = fragment.getCollector(i);
            AbstractDataCollector newCollector = collector.getSupportsOutOfOrder() ? new MergingCollector(this.remainingRequired, collector, context) : new PartitionedCollector(this.remainingRequired, collector, context);
            collectors.put(collector.getOppositeMajorFragmentId(), (MergingCollector)newCollector);
        }
        logger.debug("Came up with a list of {} required fragments.  Fragments {}", (Object)this.remainingRequired.get(), (Object)collectors);
        this.collectorMap = ImmutableMap.copyOf(collectors);
        int totalStreams = 0;
        for (DataCollector bc : this.collectorMap.values()) {
            totalStreams += bc.getTotalIncomingFragments();
        }
        assert (totalStreams >= this.remainingRequired.get()) : String.format("Total Streams %d should be more than the minimum number of streams to commence (%d).  It isn't.", totalStreams, this.remainingRequired.get());
        this.streamsRemaining.set(totalStreams);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean batchArrived(IncomingDataBatch incomingBatch) throws FragmentSetupException, IOException {
        Throwable throwable = null;
        try (AutoCloseableLock lock = this.sharedIncomingBatchLock.open();){
            int sendMajorFragmentId;
            DataCollector collector;
            if (this.closed) {
                boolean bl = false;
                return bl;
            }
            if (incomingBatch.getHeader().getIsLastBatch()) {
                this.streamsRemaining.decrementAndGet();
            }
            if ((collector = this.collectorMap.get(sendMajorFragmentId = incomingBatch.getHeader().getSendingMajorFragmentId())) == null) {
                throw new FragmentSetupException(String.format("We received a major fragment id that we were not expecting.  The id was %d. %s", sendMajorFragmentId, Arrays.toString(this.collectorMap.values().toArray())));
            }
            DataCollector dataCollector = collector;
            synchronized (dataCollector) {
                try {
                    RawFragmentBatch newRawFragmentBatch = incomingBatch.newRawFragmentBatch(this.context.getAllocator());
                    boolean decrementedToZero = collector.batchArrived(incomingBatch.getHeader().getSendingMinorFragmentId(), newRawFragmentBatch);
                    newRawFragmentBatch.release();
                    boolean bl = decrementedToZero;
                    return bl;
                }
                catch (Throwable throwable2) {
                    try {
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                }
            }
        }
    }

    public int getRemainingRequired() {
        int rem = this.remainingRequired.get();
        if (rem < 0) {
            return 0;
        }
        return rem;
    }

    public RawBatchBuffer[] getBuffers(int senderMajorFragmentId) {
        return this.collectorMap.get(senderMajorFragmentId).getBuffers();
    }

    public boolean isDone() {
        return this.streamsRemaining.get() < 1;
    }

    @Override
    public void close() throws Exception {
        try (AutoCloseableLock lock = this.exclusiveCloseLock.open();){
            this.closed = true;
            AutoCloseables.close(this.collectorMap.values());
        }
    }
}

