/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.work;

import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import oadd.com.codahale.metrics.Gauge;
import oadd.com.google.common.base.Preconditions;
import oadd.com.google.common.collect.Lists;
import oadd.com.google.common.collect.Maps;
import oadd.org.apache.drill.common.SelfCleaningRunnable;
import oadd.org.apache.drill.common.concurrent.ExtendedLatch;
import oadd.org.apache.drill.exec.coord.ClusterCoordinator;
import oadd.org.apache.drill.exec.metrics.DrillMetrics;
import oadd.org.apache.drill.exec.proto.BitControl;
import oadd.org.apache.drill.exec.proto.CoordinationProtos;
import oadd.org.apache.drill.exec.proto.ExecProtos;
import oadd.org.apache.drill.exec.proto.UserBitShared;
import oadd.org.apache.drill.exec.proto.helper.QueryIdHelper;
import oadd.org.apache.drill.exec.rpc.DrillRpcFuture;
import oadd.org.apache.drill.exec.rpc.RpcException;
import oadd.org.apache.drill.exec.rpc.control.Controller;
import oadd.org.apache.drill.exec.rpc.control.WorkEventBus;
import oadd.org.apache.drill.exec.rpc.data.DataConnectionCreator;
import oadd.org.apache.drill.exec.server.BootStrapContext;
import oadd.org.apache.drill.exec.server.DrillbitContext;
import oadd.org.apache.drill.exec.store.sys.PersistentStoreProvider;
import oadd.org.apache.drill.exec.work.batch.ControlMessageHandler;
import oadd.org.apache.drill.exec.work.foreman.Foreman;
import oadd.org.apache.drill.exec.work.fragment.FragmentExecutor;
import oadd.org.apache.drill.exec.work.fragment.FragmentManager;
import oadd.org.apache.drill.exec.work.user.UserWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkManager
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(WorkManager.class);
    private final Map<ExecProtos.FragmentHandle, FragmentExecutor> runningFragments = new ConcurrentHashMap<ExecProtos.FragmentHandle, FragmentExecutor>();
    private final ConcurrentMap<UserBitShared.QueryId, Foreman> queries = Maps.newConcurrentMap();
    private final BootStrapContext bContext;
    private DrillbitContext dContext;
    private final ControlMessageHandler controlMessageWorker;
    private final UserWorker userWorker;
    private final WorkerBee bee;
    private final WorkEventBus workBus;
    private final Executor executor;
    private final StatusThread statusThread;
    private static final int STATUS_PERIOD_SECONDS = 5;
    private ExtendedLatch exitLatch = null;

    public WorkManager(BootStrapContext context) {
        this.bContext = context;
        this.bee = new WorkerBee();
        this.workBus = new WorkEventBus();
        this.executor = context.getExecutor();
        this.controlMessageWorker = new ControlMessageHandler(this.bee);
        this.userWorker = new UserWorker(this.bee);
        this.statusThread = new StatusThread();
    }

    public void start(CoordinationProtos.DrillbitEndpoint endpoint, Controller controller, DataConnectionCreator data, ClusterCoordinator coord, PersistentStoreProvider provider) {
        this.dContext = new DrillbitContext(endpoint, this.bContext, coord, controller, data, this.workBus, provider);
        this.statusThread.start();
        DrillMetrics.register("drill.fragments.running", new Gauge<Integer>(){

            @Override
            public Integer getValue() {
                return WorkManager.this.runningFragments.size();
            }
        });
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public WorkEventBus getWorkBus() {
        return this.workBus;
    }

    public ControlMessageHandler getControlMessageHandler() {
        return this.controlMessageWorker;
    }

    public UserWorker getUserWorker() {
        return this.userWorker;
    }

    public WorkerBee getBee() {
        return this.bee;
    }

    @Override
    public void close() throws Exception {
        this.statusThread.interrupt();
        long numRunningFragments = this.runningFragments.size();
        if (numRunningFragments != 0L) {
            logger.warn("Closing WorkManager but there are {} running fragments.", (Object)numRunningFragments);
            if (logger.isDebugEnabled()) {
                for (ExecProtos.FragmentHandle handle : this.runningFragments.keySet()) {
                    logger.debug("Fragment still running: {} status: {}", (Object)QueryIdHelper.getQueryIdentifier(handle), (Object)this.runningFragments.get(handle).getStatus());
                }
            }
        }
        this.getContext().close();
    }

    public DrillbitContext getContext() {
        return this.dContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitToExit() {
        WorkManager workManager = this;
        synchronized (workManager) {
            if (this.queries.isEmpty() && this.runningFragments.isEmpty()) {
                return;
            }
            this.exitLatch = new ExtendedLatch();
        }
        this.exitLatch.awaitUninterruptibly(5000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void indicateIfSafeToExit() {
        WorkManager workManager = this;
        synchronized (workManager) {
            if (this.exitLatch != null && this.queries.isEmpty() && this.runningFragments.isEmpty()) {
                this.exitLatch.countDown();
            }
        }
    }

    private class StatusThread
    extends Thread {
        public StatusThread() {
            this.setDaemon(true);
            this.setName("WorkManager.StatusThread");
        }

        @Override
        public void run() {
            while (true) {
                Controller controller = WorkManager.this.dContext.getController();
                ArrayList<DrillRpcFuture> futures = Lists.newArrayList();
                for (FragmentExecutor fragmentExecutor : WorkManager.this.runningFragments.values()) {
                    BitControl.FragmentStatus status = fragmentExecutor.getStatus();
                    if (status == null) continue;
                    CoordinationProtos.DrillbitEndpoint ep = fragmentExecutor.getContext().getForemanEndpoint();
                    futures.add(controller.getTunnel(ep).sendFragmentStatus(status));
                }
                for (DrillRpcFuture future : futures) {
                    try {
                        future.checkedGet();
                    }
                    catch (RpcException ex) {
                        logger.info("Failure while sending intermediate fragment status to Foreman", ex);
                    }
                }
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
            }
        }
    }

    public class WorkerBee {
        public void addNewForeman(Foreman foreman) {
            WorkManager.this.queries.put(foreman.getQueryId(), foreman);
            WorkManager.this.executor.execute(foreman);
        }

        public void retireForeman(Foreman foreman) {
            Preconditions.checkNotNull(foreman);
            UserBitShared.QueryId queryId = foreman.getQueryId();
            boolean wasRemoved = WorkManager.this.queries.remove(queryId, foreman);
            if (!wasRemoved) {
                logger.warn("Couldn't find retiring Foreman for query " + queryId);
            }
            WorkManager.this.indicateIfSafeToExit();
        }

        public Foreman getForemanForQueryId(UserBitShared.QueryId queryId) {
            return (Foreman)WorkManager.this.queries.get(queryId);
        }

        public DrillbitContext getContext() {
            return WorkManager.this.dContext;
        }

        public void addFragmentRunner(FragmentExecutor fragmentExecutor) {
            final ExecProtos.FragmentHandle fragmentHandle = fragmentExecutor.getContext().getHandle();
            WorkManager.this.runningFragments.put(fragmentHandle, fragmentExecutor);
            WorkManager.this.executor.execute(new SelfCleaningRunnable(fragmentExecutor){

                @Override
                protected void cleanup() {
                    WorkManager.this.runningFragments.remove(fragmentHandle);
                    WorkManager.this.indicateIfSafeToExit();
                }
            });
        }

        public void startFragmentPendingRemote(FragmentManager fragmentManager) {
            final ExecProtos.FragmentHandle fragmentHandle = fragmentManager.getHandle();
            FragmentExecutor fragmentExecutor = fragmentManager.getRunnable();
            if (fragmentExecutor == null) {
                return;
            }
            WorkManager.this.runningFragments.put(fragmentHandle, fragmentExecutor);
            WorkManager.this.executor.execute(new SelfCleaningRunnable(fragmentExecutor){

                @Override
                protected void cleanup() {
                    WorkManager.this.runningFragments.remove(fragmentHandle);
                    WorkManager.this.workBus.removeFragmentManager(fragmentHandle);
                    WorkManager.this.indicateIfSafeToExit();
                }
            });
        }

        public FragmentExecutor getFragmentRunner(ExecProtos.FragmentHandle handle) {
            return (FragmentExecutor)WorkManager.this.runningFragments.get(handle);
        }
    }
}

