/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.complex.impl;

import java.util.ArrayList;
import oadd.com.google.common.collect.Lists;
import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.exec.expr.holders.NullableVar16CharHolder;
import oadd.org.apache.drill.exec.expr.holders.RepeatedVar16CharHolder;
import oadd.org.apache.drill.exec.vector.complex.impl.AbstractFieldReader;

public class RepeatedVar16CharHolderReaderImpl
extends AbstractFieldReader {
    private NullableVar16CharHolder holder = new NullableVar16CharHolder();
    private int index = -1;
    private RepeatedVar16CharHolder repeatedHolder;

    public RepeatedVar16CharHolderReaderImpl(RepeatedVar16CharHolder holder) {
        this.repeatedHolder = holder;
    }

    @Override
    public int size() {
        return this.repeatedHolder.end - this.repeatedHolder.start;
    }

    @Override
    public boolean next() {
        if (this.index + 1 < this.repeatedHolder.end) {
            ++this.index;
            this.repeatedHolder.vector.getAccessor().get(this.repeatedHolder.start + this.index, this.holder);
            return true;
        }
        return false;
    }

    @Override
    public void setPosition(int index) {
        throw new UnsupportedOperationException("You can't call next on a single value reader.");
    }

    @Override
    public TypeProtos.MajorType getType() {
        return RepeatedVar16CharHolder.TYPE;
    }

    @Override
    public boolean isSet() {
        return this.repeatedHolder.end != this.repeatedHolder.start;
    }

    @Override
    public String readString(int index) {
        this.repeatedHolder.vector.getAccessor().get(this.repeatedHolder.start + index, this.holder);
        String value = this.readString();
        if (this.index > -1) {
            this.repeatedHolder.vector.getAccessor().get(this.repeatedHolder.start + this.index, this.holder);
        }
        return value;
    }

    @Override
    public String readString() {
        if (!this.isSet()) {
            return null;
        }
        int length = this.holder.end - this.holder.start;
        byte[] value = new byte[length];
        this.holder.buffer.getBytes(this.holder.start, value, 0, length);
        return new String(value);
    }

    @Override
    public Object readObject() {
        ArrayList<String> valList = Lists.newArrayList();
        for (int i = this.repeatedHolder.start; i < this.repeatedHolder.end; ++i) {
            valList.add(this.repeatedHolder.vector.getAccessor().getObject(i));
        }
        return valList;
    }

    private Object readSingleObject() {
        if (!this.isSet()) {
            return null;
        }
        int length = this.holder.end - this.holder.start;
        byte[] value = new byte[length];
        this.holder.buffer.getBytes(this.holder.start, value, 0, length);
        return new String(value);
    }
}

