/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.complex.fn;

import java.io.IOException;
import java.math.BigDecimal;
import oadd.com.fasterxml.jackson.core.JsonGenerator;
import oadd.com.google.common.base.Preconditions;
import oadd.org.apache.drill.exec.expr.fn.impl.DateUtility;
import oadd.org.apache.drill.exec.vector.complex.fn.DateOutputFormat;
import oadd.org.apache.drill.exec.vector.complex.fn.JsonOutput;
import oadd.org.apache.drill.exec.vector.complex.reader.FieldReader;
import oadd.org.joda.time.DateTime;
import oadd.org.joda.time.DateTimeZone;
import oadd.org.joda.time.Period;
import oadd.org.joda.time.format.DateTimeFormatter;
import oadd.org.joda.time.format.ISODateTimeFormat;
import oadd.org.joda.time.format.ISOPeriodFormat;

public class BasicJsonOutput
implements JsonOutput {
    protected final JsonGenerator gen;
    private final DateTimeFormatter dateFormatter;
    private final DateTimeFormatter timeFormatter;
    private final DateTimeFormatter timestampFormatter;

    public BasicJsonOutput(JsonGenerator gen) {
        this(gen, DateOutputFormat.SQL);
    }

    protected BasicJsonOutput(JsonGenerator gen, DateOutputFormat dateOutput) {
        Preconditions.checkNotNull(dateOutput);
        Preconditions.checkNotNull(gen);
        this.gen = gen;
        switch (dateOutput) {
            case SQL: {
                this.dateFormatter = DateUtility.formatDate;
                this.timeFormatter = DateUtility.formatTime;
                this.timestampFormatter = DateUtility.formatTimeStamp;
                break;
            }
            case ISO: {
                this.dateFormatter = ISODateTimeFormat.date();
                this.timeFormatter = ISODateTimeFormat.time();
                this.timestampFormatter = ISODateTimeFormat.dateTime();
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("Unable to support date output of type %s.", new Object[]{dateOutput}));
            }
        }
    }

    @Override
    public void flush() throws IOException {
        this.gen.flush();
    }

    @Override
    public void writeStartArray() throws IOException {
        this.gen.writeStartArray();
    }

    @Override
    public void writeEndArray() throws IOException {
        this.gen.writeEndArray();
    }

    @Override
    public void writeStartObject() throws IOException {
        this.gen.writeStartObject();
    }

    @Override
    public void writeEndObject() throws IOException {
        this.gen.writeEndObject();
    }

    @Override
    public void writeUntypedNull() throws IOException {
        this.gen.writeNull();
    }

    @Override
    public void writeFieldName(String name) throws IOException {
        this.gen.writeFieldName(name);
    }

    @Override
    public void writeDecimal(FieldReader reader) throws IOException {
        if (reader.isSet()) {
            this.writeDecimal(reader.readBigDecimal());
        } else {
            this.writeDecimalNull();
        }
    }

    @Override
    public void writeTinyInt(FieldReader reader) throws IOException {
        if (reader.isSet()) {
            this.writeTinyInt(reader.readByte());
        } else {
            this.writeTinyIntNull();
        }
    }

    @Override
    public void writeSmallInt(FieldReader reader) throws IOException {
        if (reader.isSet()) {
            this.writeSmallInt(reader.readShort());
        } else {
            this.writeSmallIntNull();
        }
    }

    @Override
    public void writeInt(FieldReader reader) throws IOException {
        if (reader.isSet()) {
            this.writeInt(reader.readInteger());
        } else {
            this.writeIntNull();
        }
    }

    @Override
    public void writeBigInt(FieldReader reader) throws IOException {
        if (reader.isSet()) {
            this.writeBigInt(reader.readLong());
        } else {
            this.writeBigIntNull();
        }
    }

    @Override
    public void writeFloat(FieldReader reader) throws IOException {
        if (reader.isSet()) {
            this.writeFloat(reader.readFloat().floatValue());
        } else {
            this.writeFloatNull();
        }
    }

    @Override
    public void writeDouble(FieldReader reader) throws IOException {
        if (reader.isSet()) {
            this.writeDouble(reader.readDouble());
        } else {
            this.writeDoubleNull();
        }
    }

    @Override
    public void writeVarChar(FieldReader reader) throws IOException {
        if (reader.isSet()) {
            this.writeVarChar(reader.readText().toString());
        } else {
            this.writeVarcharNull();
        }
    }

    @Override
    public void writeVar16Char(FieldReader reader) throws IOException {
        if (reader.isSet()) {
            this.writeVar16Char(reader.readText().toString());
        } else {
            this.writeVar16charNull();
        }
    }

    @Override
    public void writeBinary(FieldReader reader) throws IOException {
        if (reader.isSet()) {
            this.writeBinary(reader.readByteArray());
        } else {
            this.writeBinaryNull();
        }
    }

    @Override
    public void writeBoolean(FieldReader reader) throws IOException {
        if (reader.isSet()) {
            this.writeBoolean(reader.readBoolean());
        } else {
            this.writeBooleanNull();
        }
    }

    @Override
    public void writeDate(FieldReader reader) throws IOException {
        if (reader.isSet()) {
            this.writeDate(reader.readDateTime());
        } else {
            this.writeDateNull();
        }
    }

    @Override
    public void writeTime(FieldReader reader) throws IOException {
        if (reader.isSet()) {
            this.writeTime(reader.readDateTime());
        } else {
            this.writeTimeNull();
        }
    }

    @Override
    public void writeTimestamp(FieldReader reader) throws IOException {
        if (reader.isSet()) {
            this.writeTimestamp(reader.readDateTime());
        } else {
            this.writeTimeNull();
        }
    }

    @Override
    public void writeInterval(FieldReader reader) throws IOException {
        if (reader.isSet()) {
            this.writeInterval(reader.readPeriod());
        } else {
            this.writeIntervalNull();
        }
    }

    @Override
    public void writeTinyInt(int index, FieldReader reader) throws IOException {
        if (reader.isSet()) {
            this.writeTinyInt(reader.readByte(index));
        } else {
            this.writeTinyIntNull();
        }
    }

    @Override
    public void writeSmallInt(int index, FieldReader reader) throws IOException {
        if (reader.isSet()) {
            this.writeSmallInt(reader.readShort(index));
        } else {
            this.writeSmallIntNull();
        }
    }

    @Override
    public void writeInt(int index, FieldReader reader) throws IOException {
        if (reader.isSet()) {
            this.writeInt(reader.readInteger(index));
        } else {
            this.writeIntNull();
        }
    }

    @Override
    public void writeBigInt(int index, FieldReader reader) throws IOException {
        if (reader.isSet()) {
            this.writeBigInt(reader.readLong(index));
        } else {
            this.writeBigIntNull();
        }
    }

    @Override
    public void writeFloat(int index, FieldReader reader) throws IOException {
        if (reader.isSet()) {
            this.writeFloat(reader.readFloat(index).floatValue());
        } else {
            this.writeFloatNull();
        }
    }

    @Override
    public void writeDouble(int index, FieldReader reader) throws IOException {
        if (reader.isSet()) {
            this.writeDouble(reader.readDouble(index));
        } else {
            this.writeDoubleNull();
        }
    }

    @Override
    public void writeVarChar(int index, FieldReader reader) throws IOException {
        if (reader.isSet()) {
            this.writeVarChar(reader.readText(index).toString());
        } else {
            this.writeVarcharNull();
        }
    }

    @Override
    public void writeVar16Char(int index, FieldReader reader) throws IOException {
        if (reader.isSet()) {
            this.writeVar16Char(reader.readString(index));
        } else {
            this.writeVar16charNull();
        }
    }

    @Override
    public void writeBinary(int index, FieldReader reader) throws IOException {
        if (reader.isSet()) {
            this.writeBinary(reader.readByteArray(index));
        } else {
            this.writeBinaryNull();
        }
    }

    @Override
    public void writeBoolean(int index, FieldReader reader) throws IOException {
        if (reader.isSet()) {
            this.writeBoolean(reader.readBoolean(index));
        } else {
            this.writeBooleanNull();
        }
    }

    @Override
    public void writeDate(int index, FieldReader reader) throws IOException {
        if (reader.isSet()) {
            this.writeDate(reader.readDateTime(index));
        } else {
            this.writeDateNull();
        }
    }

    @Override
    public void writeTime(int index, FieldReader reader) throws IOException {
        if (reader.isSet()) {
            this.writeTime(reader.readDateTime(index));
        } else {
            this.writeTimeNull();
        }
    }

    @Override
    public void writeTimestamp(int index, FieldReader reader) throws IOException {
        if (reader.isSet()) {
            this.writeTimestamp(reader.readDateTime(index));
        } else {
            this.writeTimestampNull();
        }
    }

    @Override
    public void writeInterval(int index, FieldReader reader) throws IOException {
        if (reader.isSet()) {
            this.writeInterval(reader.readPeriod(index));
        } else {
            this.writeIntervalNull();
        }
    }

    @Override
    public void writeDecimal(int index, FieldReader reader) throws IOException {
        if (reader.isSet()) {
            this.writeDecimal(reader.readBigDecimal(index));
        } else {
            this.writeDecimalNull();
        }
    }

    @Override
    public void writeDecimal(BigDecimal value) throws IOException {
        this.gen.writeNumber(value);
    }

    @Override
    public void writeTinyInt(byte value) throws IOException {
        this.gen.writeNumber(value);
    }

    @Override
    public void writeSmallInt(short value) throws IOException {
        this.gen.writeNumber(value);
    }

    @Override
    public void writeInt(int value) throws IOException {
        this.gen.writeNumber(value);
    }

    @Override
    public void writeBigInt(long value) throws IOException {
        this.gen.writeNumber(value);
    }

    @Override
    public void writeFloat(float value) throws IOException {
        this.gen.writeNumber(value);
    }

    @Override
    public void writeDouble(double value) throws IOException {
        this.gen.writeNumber(value);
    }

    @Override
    public void writeVarChar(String value) throws IOException {
        this.gen.writeString(value);
    }

    @Override
    public void writeVar16Char(String value) throws IOException {
        this.gen.writeString(value);
    }

    @Override
    public void writeBinary(byte[] value) throws IOException {
        this.gen.writeBinary(value);
    }

    @Override
    public void writeBoolean(boolean value) throws IOException {
        this.gen.writeBoolean(value);
    }

    @Override
    public void writeDate(DateTime value) throws IOException {
        this.gen.writeString(this.dateFormatter.print(value.withZone(DateTimeZone.UTC)));
    }

    @Override
    public void writeTime(DateTime value) throws IOException {
        this.gen.writeString(this.timeFormatter.print(value.withZone(DateTimeZone.UTC)));
    }

    @Override
    public void writeTimestamp(DateTime value) throws IOException {
        this.gen.writeString(this.timestampFormatter.print(value.withZone(DateTimeZone.UTC)));
    }

    @Override
    public void writeInterval(Period value) throws IOException {
        this.gen.writeString(value.toString(ISOPeriodFormat.standard()));
    }

    @Override
    public void writeDecimalNull() throws IOException {
        this.gen.writeNull();
    }

    @Override
    public void writeTinyIntNull() throws IOException {
        this.gen.writeNull();
    }

    @Override
    public void writeSmallIntNull() throws IOException {
        this.gen.writeNull();
    }

    @Override
    public void writeIntNull() throws IOException {
        this.gen.writeNull();
    }

    @Override
    public void writeBigIntNull() throws IOException {
        this.gen.writeNull();
    }

    @Override
    public void writeFloatNull() throws IOException {
        this.gen.writeNull();
    }

    @Override
    public void writeDoubleNull() throws IOException {
        this.gen.writeNull();
    }

    @Override
    public void writeVarcharNull() throws IOException {
        this.gen.writeNull();
    }

    @Override
    public void writeVar16charNull() throws IOException {
        this.gen.writeNull();
    }

    @Override
    public void writeBinaryNull() throws IOException {
        this.gen.writeNull();
    }

    @Override
    public void writeBooleanNull() throws IOException {
        this.gen.writeNull();
    }

    @Override
    public void writeDateNull() throws IOException {
        this.gen.writeNull();
    }

    @Override
    public void writeTimeNull() throws IOException {
        this.gen.writeNull();
    }

    @Override
    public void writeTimestampNull() throws IOException {
        this.gen.writeNull();
    }

    @Override
    public void writeIntervalNull() throws IOException {
        this.gen.writeNull();
    }
}

