/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.complex;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import oadd.com.google.common.base.Preconditions;
import oadd.com.google.common.collect.Lists;
import oadd.io.netty.buffer.DrillBuf;
import oadd.org.apache.drill.common.collections.MapWithOrdinal;
import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.exec.expr.BasicTypeHelper;
import oadd.org.apache.drill.exec.memory.BufferAllocator;
import oadd.org.apache.drill.exec.record.MaterializedField;
import oadd.org.apache.drill.exec.util.CallBack;
import oadd.org.apache.drill.exec.vector.ValueVector;
import oadd.org.apache.drill.exec.vector.complex.AbstractContainerVector;
import oadd.org.apache.drill.exec.vector.complex.BaseRepeatedValueVector;
import oadd.org.apache.drill.exec.vector.complex.VectorWithOrdinal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMapVector
extends AbstractContainerVector {
    private static final Logger logger = LoggerFactory.getLogger(AbstractContainerVector.class);
    private final MapWithOrdinal<String, ValueVector> vectors = new MapWithOrdinal();

    protected AbstractMapVector(MaterializedField field, BufferAllocator allocator, CallBack callBack) {
        super(field.clone(), allocator, callBack);
        MaterializedField clonedField = field.clone();
        for (MaterializedField child : clonedField.getChildren()) {
            if (child.equals(BaseRepeatedValueVector.OFFSETS_FIELD)) continue;
            String fieldName = child.getLastName();
            ValueVector v = BasicTypeHelper.getNewVector(child, allocator, callBack);
            this.putVector(fieldName, v);
        }
    }

    @Override
    public void close() {
        for (ValueVector valueVector : this.vectors.values()) {
            valueVector.close();
        }
        this.vectors.clear();
        super.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean allocateNewSafe() {
        boolean success = false;
        try {
            for (ValueVector v : this.vectors.values()) {
                if (v.allocateNewSafe()) continue;
                boolean bl = false;
                return bl;
            }
            success = true;
        }
        finally {
            if (!success) {
                this.clear();
            }
        }
        return true;
    }

    @Override
    public <T extends ValueVector> T addOrGet(String name, TypeProtos.MajorType type, Class<T> clazz) {
        ValueVector existing = this.getChild(name);
        boolean create = false;
        if (existing == null) {
            create = true;
        } else {
            if (clazz.isAssignableFrom(existing.getClass())) {
                return (T)existing;
            }
            if (this.nullFilled(existing)) {
                existing.clear();
                create = true;
            }
        }
        if (create) {
            ValueVector vector = BasicTypeHelper.getNewVector(name, this.allocator, type, this.callBack);
            this.putChild(name, vector);
            if (this.callBack != null) {
                this.callBack.doWork();
            }
            return (T)vector;
        }
        String message = "Drill does not support schema change yet. Existing[%s] and desired[%s] vector types mismatch";
        throw new IllegalStateException(String.format("Drill does not support schema change yet. Existing[%s] and desired[%s] vector types mismatch", existing.getClass().getSimpleName(), clazz.getSimpleName()));
    }

    private boolean nullFilled(ValueVector vector) {
        for (int r = 0; r < vector.getAccessor().getValueCount(); ++r) {
            if (vector.getAccessor().isNull(r)) continue;
            return false;
        }
        return true;
    }

    public ValueVector getChildByOrdinal(int id) {
        return this.vectors.getByOrdinal(id);
    }

    @Override
    public <T extends ValueVector> T getChild(String name, Class<T> clazz) {
        ValueVector v = this.vectors.get(name.toLowerCase());
        if (v == null) {
            return null;
        }
        return this.typeify(v, clazz);
    }

    protected void putChild(String name, ValueVector vector) {
        this.putVector(name, vector);
        this.field.addChild(vector.getField());
    }

    protected void putVector(String name, ValueVector vector) {
        ValueVector old = this.vectors.put(Preconditions.checkNotNull(name, "field name cannot be null").toLowerCase(), Preconditions.checkNotNull(vector, "vector cannot be null"));
        if (old != null && old != vector) {
            logger.debug("Field [{}] mutated from [{}] to [{}]", name, old.getClass().getSimpleName(), vector.getClass().getSimpleName());
        }
    }

    protected Collection<ValueVector> getChildren() {
        return this.vectors.values();
    }

    @Override
    public int size() {
        return this.vectors.size();
    }

    @Override
    public Iterator<ValueVector> iterator() {
        return this.vectors.values().iterator();
    }

    public List<ValueVector> getPrimitiveVectors() {
        ArrayList<ValueVector> primitiveVectors = Lists.newArrayList();
        for (ValueVector v : this.vectors.values()) {
            if (v instanceof AbstractMapVector) {
                AbstractMapVector mapVector = (AbstractMapVector)v;
                primitiveVectors.addAll(mapVector.getPrimitiveVectors());
                continue;
            }
            primitiveVectors.add(v);
        }
        return primitiveVectors;
    }

    @Override
    public VectorWithOrdinal getChildVectorWithOrdinal(String name) {
        int ordinal = this.vectors.getOrdinal(name.toLowerCase());
        if (ordinal < 0) {
            return null;
        }
        ValueVector vector = this.vectors.getByOrdinal(ordinal);
        return new VectorWithOrdinal(vector, ordinal);
    }

    @Override
    public DrillBuf[] getBuffers(boolean clear) {
        ArrayList<DrillBuf> buffers = Lists.newArrayList();
        for (ValueVector vector : this.vectors.values()) {
            for (DrillBuf buf : vector.getBuffers(false)) {
                buffers.add(buf);
                if (!clear) continue;
                buf.retain(1);
            }
            if (!clear) continue;
            vector.clear();
        }
        return buffers.toArray(new DrillBuf[buffers.size()]);
    }

    @Override
    public int getBufferSize() {
        int actualBufSize = 0;
        for (ValueVector v : this.vectors.values()) {
            for (DrillBuf buf : v.getBuffers(false)) {
                actualBufSize += buf.writerIndex();
            }
        }
        return actualBufSize;
    }
}

