/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.accessor;

import java.sql.Time;
import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.common.types.Types;
import oadd.org.apache.drill.exec.vector.TimeVector;
import oadd.org.apache.drill.exec.vector.accessor.AbstractSqlAccessor;
import oadd.org.apache.drill.exec.vector.accessor.sql.TimePrintMillis;
import oadd.org.joda.time.DateTime;
import oadd.org.joda.time.DateTimeZone;

public class TimeAccessor
extends AbstractSqlAccessor {
    private static final TypeProtos.MajorType TYPE = Types.required(TypeProtos.MinorType.TIME);
    private final TimeVector.Accessor ac;

    public TimeAccessor(TimeVector vector) {
        this.ac = vector.getAccessor();
    }

    @Override
    public TypeProtos.MajorType getType() {
        return TYPE;
    }

    @Override
    public boolean isNull(int index) {
        return false;
    }

    @Override
    public Class<?> getObjectClass() {
        return Time.class;
    }

    @Override
    public Object getObject(int index) {
        return this.getTime(index);
    }

    @Override
    public Time getTime(int index) {
        DateTime time = new DateTime((long)this.ac.get(index), DateTimeZone.UTC);
        time = time.withZoneRetainFields(DateTimeZone.getDefault());
        return new TimePrintMillis(time.getMillis());
    }
}

