/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.util;

import oadd.org.apache.drill.exec.expr.fn.impl.DateUtility;
import oadd.org.apache.drill.exec.ops.FragmentContext;
import oadd.org.apache.drill.exec.proto.BitControl;
import oadd.org.apache.drill.exec.proto.ExecProtos;
import oadd.org.apache.drill.exec.proto.helper.QueryIdHelper;

public class Utilities {
    public static String getFileNameForQueryFragment(FragmentContext context, String location, String tag) {
        ExecProtos.FragmentHandle handle = context.getHandle();
        String qid = QueryIdHelper.getQueryId(handle.getQueryId());
        int majorFragmentId = handle.getMajorFragmentId();
        int minorFragmentId = handle.getMinorFragmentId();
        String fileName = String.format("%s//%s_%s_%s_%s", location, qid, majorFragmentId, minorFragmentId, tag);
        return fileName;
    }

    public static BitControl.QueryContextInformation createQueryContextInfo(String defaultSchemaName) {
        long queryStartTime = System.currentTimeMillis();
        int timeZone = DateUtility.getIndex((String)System.getProperty("user.timezone"));
        return BitControl.QueryContextInformation.newBuilder().setDefaultSchemaName(defaultSchemaName).setQueryStartTime(queryStartTime).setTimeZone(timeZone).build();
    }

    public static String getDrillVersion() {
        String v = Utilities.class.getPackage().getImplementationVersion();
        return v;
    }
}

