/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.util;

import java.io.File;
import oadd.com.google.common.io.Files;
import oadd.org.apache.drill.common.exceptions.ExecutionSetupException;
import oadd.org.apache.drill.common.logical.StoragePluginConfig;
import oadd.org.apache.drill.exec.store.StoragePluginRegistry;
import oadd.org.apache.drill.exec.store.dfs.FileSystemConfig;
import oadd.org.apache.drill.exec.store.dfs.FileSystemPlugin;
import oadd.org.apache.drill.exec.store.dfs.WorkspaceConfig;

public class TestUtilities {
    private static final String dfsPluginName = "dfs";
    private static final String dfsTmpSchema = "tmp";
    private static final String dfsTestPluginName = "dfs_test";
    private static final String dfsTestTmpSchema = "tmp";

    public static String createTempDir() {
        File tmpDir = Files.createTempDir();
        tmpDir.deleteOnExit();
        return tmpDir.getAbsolutePath();
    }

    public static void updateDfsTestTmpSchemaLocation(StoragePluginRegistry pluginRegistry, String tmpDirPath) throws ExecutionSetupException {
        FileSystemPlugin plugin = (FileSystemPlugin)pluginRegistry.getPlugin(dfsTestPluginName);
        FileSystemConfig pluginConfig = (FileSystemConfig)plugin.getConfig();
        WorkspaceConfig tmpWSConfig = (WorkspaceConfig)pluginConfig.workspaces.get("tmp");
        WorkspaceConfig newTmpWSConfig = new WorkspaceConfig(tmpDirPath, true, tmpWSConfig.getDefaultInputFormat());
        pluginConfig.workspaces.remove("tmp");
        pluginConfig.workspaces.put("tmp", newTmpWSConfig);
        pluginRegistry.createOrUpdate(dfsTestPluginName, (StoragePluginConfig)pluginConfig, true);
    }

    public static void makeDfsTmpSchemaImmutable(StoragePluginRegistry pluginRegistry) throws ExecutionSetupException {
        FileSystemPlugin dfsPlugin = (FileSystemPlugin)pluginRegistry.getPlugin(dfsPluginName);
        FileSystemConfig dfsPluginConfig = (FileSystemConfig)dfsPlugin.getConfig();
        WorkspaceConfig tmpWSConfig = (WorkspaceConfig)dfsPluginConfig.workspaces.get("tmp");
        WorkspaceConfig newTmpWSConfig = new WorkspaceConfig(tmpWSConfig.getLocation(), false, tmpWSConfig.getDefaultInputFormat());
        dfsPluginConfig.workspaces.remove("tmp");
        dfsPluginConfig.workspaces.put("tmp", newTmpWSConfig);
        pluginRegistry.createOrUpdate(dfsPluginName, (StoragePluginConfig)dfsPluginConfig, true);
    }
}

