/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.server.options;

import java.util.HashSet;
import java.util.Set;
import oadd.com.google.common.base.Preconditions;
import oadd.org.apache.drill.common.exceptions.UserException;
import oadd.org.apache.drill.exec.server.options.OptionValidator;
import oadd.org.apache.drill.exec.server.options.OptionValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeValidators {
    private static final Logger logger = LoggerFactory.getLogger(TypeValidators.class);

    public static abstract class TypeValidator
    extends OptionValidator {
        private final OptionValue.Kind kind;
        private final OptionValue defaultValue;

        public TypeValidator(String name, OptionValue.Kind kind, OptionValue defValue) {
            super(name);
            Preconditions.checkArgument(defValue.type == OptionValue.OptionType.SYSTEM, "Default value must be SYSTEM type.");
            this.kind = kind;
            this.defaultValue = defValue;
        }

        @Override
        public OptionValue getDefault() {
            return this.defaultValue;
        }

        @Override
        public void validate(OptionValue v) {
            if (v.kind != this.kind) {
                throw UserException.validationError().message(String.format("Option %s must be of type %s but you tried to set to %s.", this.getOptionName(), this.kind.name(), v.kind.name()), new Object[0]).build(logger);
            }
        }
    }

    public static class EnumeratedStringValidator
    extends StringValidator {
        private final Set<String> valuesSet = new HashSet<String>();

        public EnumeratedStringValidator(String name, String def, String ... values) {
            super(name, def);
            for (String value : values) {
                this.valuesSet.add(value.toLowerCase());
            }
        }

        @Override
        public void validate(OptionValue v) {
            super.validate(v);
            if (!this.valuesSet.contains(v.string_val.toLowerCase())) {
                throw UserException.validationError().message(String.format("Option %s must be one of: %s.", this.getOptionName(), this.valuesSet), new Object[0]).build(logger);
            }
        }
    }

    public static class AdminOptionValidator
    extends StringValidator {
        public AdminOptionValidator(String name, String def) {
            super(name, def);
        }

        @Override
        public void validate(OptionValue v) {
            if (v.type != OptionValue.OptionType.SYSTEM) {
                throw UserException.validationError().message("Admin related settings can only be set at SYSTEM level scope. Given scope '%s'.", new Object[]{v.type}).build(logger);
            }
            super.validate(v);
        }
    }

    public static class RangeLongValidator
    extends LongValidator {
        private final long min;
        private final long max;

        public RangeLongValidator(String name, long min, long max, long def) {
            super(name, def);
            this.min = min;
            this.max = max;
        }

        @Override
        public void validate(OptionValue v) {
            super.validate(v);
            if (v.num_val > this.max || v.num_val < this.min) {
                throw UserException.validationError().message(String.format("Option %s must be between %d and %d.", this.getOptionName(), this.min, this.max), new Object[0]).build(logger);
            }
        }
    }

    public static class DoubleValidator
    extends TypeValidator {
        public DoubleValidator(String name, double def) {
            super(name, OptionValue.Kind.DOUBLE, OptionValue.createDouble(OptionValue.OptionType.SYSTEM, name, def));
        }
    }

    public static class LongValidator
    extends TypeValidator {
        public LongValidator(String name, long def) {
            super(name, OptionValue.Kind.LONG, OptionValue.createLong(OptionValue.OptionType.SYSTEM, name, def));
        }
    }

    public static class StringValidator
    extends TypeValidator {
        public StringValidator(String name, String def) {
            super(name, OptionValue.Kind.STRING, OptionValue.createString(OptionValue.OptionType.SYSTEM, name, def));
        }
    }

    public static class BooleanValidator
    extends TypeValidator {
        public BooleanValidator(String name, boolean def) {
            super(name, OptionValue.Kind.BOOLEAN, OptionValue.createBoolean(OptionValue.OptionType.SYSTEM, name, def));
        }
    }

    public static class RangeDoubleValidator
    extends DoubleValidator {
        private final double min;
        private final double max;

        public RangeDoubleValidator(String name, double min, double max, double def) {
            super(name, def);
            this.min = min;
            this.max = max;
        }

        @Override
        public void validate(OptionValue v) {
            super.validate(v);
            if (v.float_val > this.max || v.float_val < this.min) {
                throw UserException.validationError().message(String.format("Option %s must be between %f and %f.", this.getOptionName(), this.min, this.max), new Object[0]).build(logger);
            }
        }
    }

    public static class PowerOfTwoLongValidator
    extends PositiveLongValidator {
        public PowerOfTwoLongValidator(String name, long max, long def) {
            super(name, max, def);
        }

        @Override
        public void validate(OptionValue v) {
            super.validate(v);
            if (!PowerOfTwoLongValidator.isPowerOfTwo(v.num_val)) {
                throw UserException.validationError().message(String.format("Option %s must be a power of two.", this.getOptionName()), new Object[0]).build(logger);
            }
        }

        private static boolean isPowerOfTwo(long num) {
            return (num & num - 1L) == 0L;
        }
    }

    public static class PositiveLongValidator
    extends LongValidator {
        private final long max;

        public PositiveLongValidator(String name, long max, long def) {
            super(name, def);
            this.max = max;
        }

        @Override
        public void validate(OptionValue v) {
            super.validate(v);
            if (v.num_val > this.max || v.num_val < 1L) {
                throw UserException.validationError().message(String.format("Option %s must be between %d and %d.", this.getOptionName(), 1, this.max), new Object[0]).build(logger);
            }
        }
    }
}

