/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.server;

import java.util.Collection;
import java.util.concurrent.ExecutorService;
import oadd.com.codahale.metrics.MetricRegistry;
import oadd.com.google.common.base.Preconditions;
import oadd.io.netty.channel.EventLoopGroup;
import oadd.org.apache.drill.common.config.DrillConfig;
import oadd.org.apache.drill.common.config.LogicalPlanPersistence;
import oadd.org.apache.drill.common.scanner.persistence.ScanResult;
import oadd.org.apache.drill.exec.compile.CodeCompiler;
import oadd.org.apache.drill.exec.coord.ClusterCoordinator;
import oadd.org.apache.drill.exec.expr.fn.FunctionImplementationRegistry;
import oadd.org.apache.drill.exec.memory.BufferAllocator;
import oadd.org.apache.drill.exec.physical.impl.OperatorCreatorRegistry;
import oadd.org.apache.drill.exec.planner.PhysicalPlanReader;
import oadd.org.apache.drill.exec.proto.CoordinationProtos;
import oadd.org.apache.drill.exec.rpc.control.Controller;
import oadd.org.apache.drill.exec.rpc.control.WorkEventBus;
import oadd.org.apache.drill.exec.rpc.data.DataConnectionCreator;
import oadd.org.apache.drill.exec.server.BootStrapContext;
import oadd.org.apache.drill.exec.server.options.OptionManager;
import oadd.org.apache.drill.exec.server.options.SystemOptionManager;
import oadd.org.apache.drill.exec.store.SchemaFactory;
import oadd.org.apache.drill.exec.store.StoragePluginRegistry;
import oadd.org.apache.drill.exec.store.sys.PersistentStoreProvider;

public class DrillbitContext
implements AutoCloseable {
    private final BootStrapContext context;
    private final PhysicalPlanReader reader;
    private final ClusterCoordinator coord;
    private final DataConnectionCreator connectionsPool;
    private final CoordinationProtos.DrillbitEndpoint endpoint;
    private final StoragePluginRegistry storagePlugins;
    private final OperatorCreatorRegistry operatorCreatorRegistry;
    private final Controller controller;
    private final WorkEventBus workBus;
    private final FunctionImplementationRegistry functionRegistry;
    private final SystemOptionManager systemOptions;
    private final PersistentStoreProvider provider;
    private final CodeCompiler compiler;
    private final ScanResult classpathScan;
    private final LogicalPlanPersistence lpPersistence;

    public DrillbitContext(CoordinationProtos.DrillbitEndpoint endpoint, BootStrapContext context, ClusterCoordinator coord, Controller controller, DataConnectionCreator connectionsPool, WorkEventBus workBus, PersistentStoreProvider provider) {
        this.classpathScan = context.getClasspathScan();
        this.workBus = workBus;
        this.controller = Preconditions.checkNotNull(controller);
        this.context = Preconditions.checkNotNull(context);
        this.coord = coord;
        this.connectionsPool = Preconditions.checkNotNull(connectionsPool);
        this.endpoint = Preconditions.checkNotNull(endpoint);
        this.provider = provider;
        this.lpPersistence = new LogicalPlanPersistence(context.getConfig(), this.classpathScan);
        this.storagePlugins = context.getConfig().getInstance("drill.exec.storage.registry", StoragePluginRegistry.class, this);
        this.reader = new PhysicalPlanReader(context.getConfig(), this.classpathScan, this.lpPersistence, endpoint, this.storagePlugins);
        this.operatorCreatorRegistry = new OperatorCreatorRegistry(this.classpathScan);
        this.systemOptions = new SystemOptionManager(this.lpPersistence, provider);
        this.functionRegistry = new FunctionImplementationRegistry(context.getConfig(), this.classpathScan, (OptionManager)this.systemOptions);
        this.compiler = new CodeCompiler(context.getConfig(), (OptionManager)this.systemOptions);
    }

    public FunctionImplementationRegistry getFunctionImplementationRegistry() {
        return this.functionRegistry;
    }

    public WorkEventBus getWorkBus() {
        return this.workBus;
    }

    public SystemOptionManager getOptionManager() {
        return this.systemOptions;
    }

    public CoordinationProtos.DrillbitEndpoint getEndpoint() {
        return this.endpoint;
    }

    public DrillConfig getConfig() {
        return this.context.getConfig();
    }

    public Collection<CoordinationProtos.DrillbitEndpoint> getBits() {
        return this.coord.getAvailableEndpoints();
    }

    public BufferAllocator getAllocator() {
        return this.context.getAllocator();
    }

    public OperatorCreatorRegistry getOperatorCreatorRegistry() {
        return this.operatorCreatorRegistry;
    }

    public StoragePluginRegistry getStorage() {
        return this.storagePlugins;
    }

    public EventLoopGroup getBitLoopGroup() {
        return this.context.getBitLoopGroup();
    }

    public DataConnectionCreator getDataConnectionsPool() {
        return this.connectionsPool;
    }

    public Controller getController() {
        return this.controller;
    }

    public MetricRegistry getMetrics() {
        return this.context.getMetrics();
    }

    public PhysicalPlanReader getPlanReader() {
        return this.reader;
    }

    public PersistentStoreProvider getStoreProvider() {
        return this.provider;
    }

    public SchemaFactory getSchemaFactory() {
        return this.storagePlugins.getSchemaFactory();
    }

    public ClusterCoordinator getClusterCoordinator() {
        return this.coord;
    }

    public CodeCompiler getCompiler() {
        return this.compiler;
    }

    public ExecutorService getExecutor() {
        return this.context.getExecutor();
    }

    public LogicalPlanPersistence getLpPersistence() {
        return this.lpPersistence;
    }

    public ScanResult getClasspathScan() {
        return this.classpathScan;
    }

    @Override
    public void close() throws Exception {
        this.getOptionManager().close();
    }
}

