/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.rpc.user.security;

import java.io.IOException;
import java.util.List;
import oadd.net.sf.jpam.Pam;
import oadd.org.apache.drill.common.config.DrillConfig;
import oadd.org.apache.drill.exec.exception.DrillbitStartupException;
import oadd.org.apache.drill.exec.rpc.user.security.UserAuthenticationException;
import oadd.org.apache.drill.exec.rpc.user.security.UserAuthenticator;
import oadd.org.apache.drill.exec.rpc.user.security.UserAuthenticatorTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UserAuthenticatorTemplate(type="pam")
public class PamUserAuthenticator
implements UserAuthenticator {
    private static final Logger logger = LoggerFactory.getLogger(PamUserAuthenticator.class);
    private List<String> profiles;

    @Override
    public void setup(DrillConfig drillConfig) throws DrillbitStartupException {
        this.profiles = DrillConfig.create().getStringList("drill.exec.security.user.auth.pam_profiles");
        try {
            new Pam();
        }
        catch (LinkageError e) {
            String errMsg = "Problem in finding the native library of JPAM (Pluggable Authenticator Module API). Make sure to set Drillbit JVM option 'java.library.path' to point to the directory where the native JPAM exists.";
            logger.error("Problem in finding the native library of JPAM (Pluggable Authenticator Module API). Make sure to set Drillbit JVM option 'java.library.path' to point to the directory where the native JPAM exists.", e);
            throw new DrillbitStartupException("Problem in finding the native library of JPAM (Pluggable Authenticator Module API). Make sure to set Drillbit JVM option 'java.library.path' to point to the directory where the native JPAM exists.:" + e.getMessage(), e);
        }
    }

    @Override
    public void authenticate(String user, String password) throws UserAuthenticationException {
        for (String pamProfile : this.profiles) {
            Pam pam = new Pam(pamProfile);
            if (pam.authenticateSuccessful(user, password)) continue;
            throw new UserAuthenticationException(String.format("PAM profile '%s' validation failed", pamProfile));
        }
    }

    @Override
    public void close() throws IOException {
    }
}

