/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.rpc.user;

import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import oadd.com.google.common.base.Preconditions;
import oadd.com.google.common.base.Strings;
import oadd.com.google.common.collect.ImmutableSet;
import oadd.com.google.common.collect.Lists;
import oadd.com.google.common.collect.Maps;
import oadd.org.apache.calcite.schema.SchemaPlus;
import oadd.org.apache.calcite.tools.ValidationException;
import oadd.org.apache.drill.exec.planner.sql.SchemaUtilites;
import oadd.org.apache.drill.exec.proto.UserBitShared;
import oadd.org.apache.drill.exec.proto.UserProtos;
import oadd.org.apache.drill.exec.rpc.user.InboundImpersonationManager;
import oadd.org.apache.drill.exec.server.options.OptionManager;
import oadd.org.apache.drill.exec.server.options.SessionOptionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserSession {
    private static final Logger logger = LoggerFactory.getLogger(UserSession.class);
    public static final String SCHEMA = "schema";
    public static final String USER = "user";
    public static final String PASSWORD = "password";
    public static final String IMPERSONATION_TARGET = "impersonation_target";
    private static final Set<String> knownProperties = ImmutableSet.of("schema", "user", "password", "impersonation_target");
    private boolean supportComplexTypes = false;
    private UserBitShared.UserCredentials credentials;
    private Map<String, String> properties;
    private OptionManager sessionOptions;
    private final AtomicInteger queryCount = new AtomicInteger(0);

    private UserSession() {
    }

    public boolean isSupportComplexTypes() {
        return this.supportComplexTypes;
    }

    public OptionManager getOptions() {
        return this.sessionOptions;
    }

    public UserBitShared.UserCredentials getCredentials() {
        return this.credentials;
    }

    public void replaceUserCredentials(InboundImpersonationManager impersonationManager, UserBitShared.UserCredentials newCredentials) {
        Preconditions.checkNotNull(impersonationManager, "User credentials can only be replaced by an impersonation manager.");
        this.credentials = newCredentials;
    }

    public String getTargetUserName() {
        return this.properties.get(IMPERSONATION_TARGET);
    }

    public String getDefaultSchemaName() {
        return this.getProp(SCHEMA);
    }

    public void incrementQueryCount(QueryCountIncrementer incrementer) {
        assert (incrementer != null);
        this.queryCount.incrementAndGet();
    }

    public int getQueryCount() {
        return this.queryCount.get();
    }

    public void setDefaultSchemaPath(String newDefaultSchemaPath, SchemaPlus currentDefaultSchema) throws ValidationException {
        ArrayList<String> newDefaultPathAsList = Lists.newArrayList(newDefaultSchemaPath.split("\\."));
        SchemaPlus newDefault = SchemaUtilites.findSchema((SchemaPlus)currentDefaultSchema, newDefaultPathAsList);
        if (newDefault == null) {
            newDefault = SchemaUtilites.findSchema((SchemaPlus)currentDefaultSchema, newDefaultPathAsList);
        }
        if (newDefault == null) {
            SchemaUtilites.throwSchemaNotFoundException((SchemaPlus)currentDefaultSchema, (String)newDefaultSchemaPath);
        }
        this.setProp(SCHEMA, SchemaUtilites.getSchemaPath((SchemaPlus)newDefault));
    }

    public String getDefaultSchemaPath() {
        return this.getProp(SCHEMA);
    }

    public SchemaPlus getDefaultSchema(SchemaPlus rootSchema) {
        String defaultSchemaPath = this.getProp(SCHEMA);
        if (Strings.isNullOrEmpty(defaultSchemaPath)) {
            return null;
        }
        SchemaPlus defaultSchema = SchemaUtilites.findSchema((SchemaPlus)rootSchema, (String)defaultSchemaPath);
        if (defaultSchema == null) {
            return defaultSchema;
        }
        return defaultSchema;
    }

    public boolean setSessionOption(String name, String value) {
        return true;
    }

    private String getProp(String key) {
        return this.properties.get(key) != null ? this.properties.get(key) : "";
    }

    private void setProp(String key, String value) {
        this.properties.put(key, value);
    }

    public static class Builder {
        UserSession userSession = new UserSession();

        public static Builder newBuilder() {
            return new Builder();
        }

        public Builder withCredentials(UserBitShared.UserCredentials credentials) {
            this.userSession.credentials = credentials;
            return this;
        }

        public Builder withOptionManager(OptionManager systemOptions) {
            this.userSession.sessionOptions = new SessionOptionManager(systemOptions, this.userSession);
            return this;
        }

        public Builder withUserProperties(UserProtos.UserProperties properties) {
            this.userSession.properties = Maps.newHashMap();
            if (properties != null) {
                for (int i = 0; i < properties.getPropertiesCount(); ++i) {
                    UserProtos.Property property = properties.getProperties(i);
                    String propertyName = property.getKey().toLowerCase();
                    if (knownProperties.contains(propertyName)) {
                        this.userSession.properties.put(propertyName, property.getValue());
                        continue;
                    }
                    logger.warn("Ignoring unknown property: {}", (Object)propertyName);
                }
            }
            return this;
        }

        public Builder setSupportComplexTypes(boolean supportComplexTypes) {
            this.userSession.supportComplexTypes = supportComplexTypes;
            return this;
        }

        public UserSession build() {
            UserSession session = this.userSession;
            this.userSession = null;
            return session;
        }

        Builder() {
        }
    }

    public static interface QueryCountIncrementer {
        public void increment(UserSession var1);
    }
}

