/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.record;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Objects;
import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.exec.expr.BasicTypeHelper;
import oadd.org.apache.drill.exec.proto.UserBitShared;

public class MaterializedField {
    private final String name;
    private final TypeProtos.MajorType type;
    private final LinkedHashSet<MaterializedField> children;

    private MaterializedField(String name, TypeProtos.MajorType type, LinkedHashSet<MaterializedField> children) {
        this.name = name;
        this.type = type;
        this.children = children;
    }

    public static MaterializedField create(UserBitShared.SerializedField serField) {
        LinkedHashSet<MaterializedField> children = new LinkedHashSet<MaterializedField>();
        for (UserBitShared.SerializedField sf : serField.getChildList()) {
            children.add(MaterializedField.create(sf));
        }
        return new MaterializedField(serField.getNamePart().getName(), serField.getMajorType(), children);
    }

    public UserBitShared.SerializedField getSerializedField() {
        UserBitShared.SerializedField.Builder serializedFieldBuilder = this.getAsBuilder();
        for (MaterializedField childMaterializedField : this.getChildren()) {
            serializedFieldBuilder.addChild(childMaterializedField.getSerializedField());
        }
        return serializedFieldBuilder.build();
    }

    public UserBitShared.SerializedField.Builder getAsBuilder() {
        return UserBitShared.SerializedField.newBuilder().setMajorType(this.type).setNamePart(UserBitShared.NamePart.newBuilder().setName(this.name).build());
    }

    public Collection<MaterializedField> getChildren() {
        return new ArrayList<MaterializedField>(this.children);
    }

    public MaterializedField newWithChild(MaterializedField child) {
        MaterializedField newField = this.clone();
        newField.addChild(child);
        return newField;
    }

    public void addChild(MaterializedField field) {
        this.children.add(field);
    }

    public MaterializedField clone() {
        return this.withPathAndType(this.name, this.getType());
    }

    public MaterializedField withType(TypeProtos.MajorType type) {
        return this.withPathAndType(this.name, type);
    }

    public MaterializedField withPath(String name) {
        return this.withPathAndType(name, this.getType());
    }

    public MaterializedField withPathAndType(String name, TypeProtos.MajorType type) {
        LinkedHashSet<MaterializedField> newChildren = new LinkedHashSet<MaterializedField>(this.children.size());
        for (MaterializedField child : this.children) {
            newChildren.add(child.clone());
        }
        return new MaterializedField(name, type, newChildren);
    }

    public boolean matches(UserBitShared.SerializedField field) {
        MaterializedField f = MaterializedField.create(field);
        return f.equals(this);
    }

    public static MaterializedField create(String name, TypeProtos.MajorType type) {
        return new MaterializedField(name, type, new LinkedHashSet<MaterializedField>());
    }

    public String getPath() {
        return this.getName();
    }

    public String getLastName() {
        return this.getName();
    }

    public String getName() {
        return this.name;
    }

    public int getWidth() {
        return this.type.getWidth();
    }

    public TypeProtos.MajorType getType() {
        return this.type;
    }

    public int getScale() {
        return this.type.getScale();
    }

    public int getPrecision() {
        return this.type.getPrecision();
    }

    public boolean isNullable() {
        return this.type.getMode() == TypeProtos.DataMode.OPTIONAL;
    }

    public TypeProtos.DataMode getDataMode() {
        return this.type.getMode();
    }

    public MaterializedField getOtherNullableVersion() {
        TypeProtos.MajorType mt = this.type;
        TypeProtos.DataMode newDataMode = null;
        switch (mt.getMode()) {
            case OPTIONAL: {
                newDataMode = TypeProtos.DataMode.REQUIRED;
                break;
            }
            case REQUIRED: {
                newDataMode = TypeProtos.DataMode.OPTIONAL;
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        return new MaterializedField(this.name, mt.toBuilder().setMode(newDataMode).build(), this.children);
    }

    public Class<?> getValueClass() {
        return BasicTypeHelper.getValueVectorClass(this.getType().getMinorType(), this.getDataMode());
    }

    public int hashCode() {
        return Objects.hash(this.name, this.type, this.children);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MaterializedField other = (MaterializedField)obj;
        return this.name.equalsIgnoreCase(other.name) && Objects.equals(this.type, other.type);
    }

    public String toString() {
        int maxLen = 10;
        String childStr = this.children != null && !this.children.isEmpty() ? this.toString(this.children, 10) : "";
        return this.name + "(" + this.type.getMinorType().name() + ":" + this.type.getMode().name() + ")" + childStr;
    }

    private String toString(Collection<?> collection, int maxLen) {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        Iterator<?> iterator = collection.iterator();
        for (int i = 0; iterator.hasNext() && i < maxLen; ++i) {
            if (i > 0) {
                builder.append(", ");
            }
            builder.append(iterator.next());
        }
        builder.append("]");
        return builder.toString();
    }
}

