/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.ops;

import oadd.org.apache.drill.exec.ops.SendingAccountor;
import oadd.org.apache.drill.exec.proto.GeneralRPCProtos;
import oadd.org.apache.drill.exec.record.FragmentWritableBatch;
import oadd.org.apache.drill.exec.rpc.RpcOutcomeListener;
import oadd.org.apache.drill.exec.rpc.data.DataTunnel;
import oadd.org.apache.drill.exec.testing.ControlsInjector;
import oadd.org.apache.drill.exec.testing.ExecutionControls;
import org.slf4j.Logger;

public class AccountingDataTunnel {
    private final DataTunnel tunnel;
    private final SendingAccountor sendingAccountor;
    private final RpcOutcomeListener<GeneralRPCProtos.Ack> statusHandler;

    public AccountingDataTunnel(DataTunnel tunnel, SendingAccountor sendingAccountor, RpcOutcomeListener<GeneralRPCProtos.Ack> statusHandler) {
        this.tunnel = tunnel;
        this.sendingAccountor = sendingAccountor;
        this.statusHandler = statusHandler;
    }

    public void sendRecordBatch(FragmentWritableBatch batch) {
        this.sendingAccountor.increment();
        this.tunnel.sendRecordBatch(this.statusHandler, batch);
    }

    public void setTestInjectionControls(ControlsInjector testInjector, ExecutionControls testControls, Logger testLogger) {
        this.tunnel.setTestInjectionControls(testInjector, testControls, testLogger);
    }
}

