/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.expr;

import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JConditional;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldRef;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JLabel;
import com.sun.codemodel.JStatement;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import oadd.com.google.common.collect.Lists;
import oadd.com.google.common.collect.Maps;
import oadd.org.apache.drill.common.expression.BooleanOperator;
import oadd.org.apache.drill.common.expression.CastExpression;
import oadd.org.apache.drill.common.expression.ConvertExpression;
import oadd.org.apache.drill.common.expression.ExpressionStringBuilder;
import oadd.org.apache.drill.common.expression.FunctionCall;
import oadd.org.apache.drill.common.expression.FunctionHolderExpression;
import oadd.org.apache.drill.common.expression.IfExpression;
import oadd.org.apache.drill.common.expression.LogicalExpression;
import oadd.org.apache.drill.common.expression.NullExpression;
import oadd.org.apache.drill.common.expression.PathSegment;
import oadd.org.apache.drill.common.expression.SchemaPath;
import oadd.org.apache.drill.common.expression.TypedNullConstant;
import oadd.org.apache.drill.common.expression.ValueExpressions;
import oadd.org.apache.drill.common.expression.visitors.AbstractExprVisitor;
import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.common.types.Types;
import oadd.org.apache.drill.exec.compile.sig.ConstantExpressionIdentifier;
import oadd.org.apache.drill.exec.compile.sig.GeneratorMapping;
import oadd.org.apache.drill.exec.compile.sig.MappingSet;
import oadd.org.apache.drill.exec.expr.ClassGenerator;
import oadd.org.apache.drill.exec.expr.DirectExpression;
import oadd.org.apache.drill.exec.expr.EqualityVisitor;
import oadd.org.apache.drill.exec.expr.GetSetVectorHelper;
import oadd.org.apache.drill.exec.expr.HashVisitor;
import oadd.org.apache.drill.exec.expr.HoldingContainerExpression;
import oadd.org.apache.drill.exec.expr.TypeHelper;
import oadd.org.apache.drill.exec.expr.ValueVectorReadExpression;
import oadd.org.apache.drill.exec.expr.ValueVectorWriteExpression;
import oadd.org.apache.drill.exec.expr.fn.AbstractFuncHolder;
import oadd.org.apache.drill.exec.expr.fn.FunctionImplementationRegistry;
import oadd.org.apache.drill.exec.physical.impl.filter.ReturnValueExpression;
import oadd.org.apache.drill.exec.vector.ValueHolderHelper;
import oadd.org.apache.drill.exec.vector.complex.impl.NullReader;
import oadd.org.apache.drill.exec.vector.complex.reader.FieldReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvaluationVisitor {
    static final Logger logger = LoggerFactory.getLogger(EvaluationVisitor.class);
    private final FunctionImplementationRegistry registry;
    Map<ExpressionHolder, ClassGenerator.HoldingContainer> previousExpressions = Maps.newHashMap();
    Stack<Map<ExpressionHolder, ClassGenerator.HoldingContainer>> mapStack = new Stack();

    public EvaluationVisitor(FunctionImplementationRegistry registry) {
        this.registry = registry;
    }

    public ClassGenerator.HoldingContainer addExpr(LogicalExpression e, ClassGenerator<?> generator) {
        Set constantBoundaries = generator.getMappingSet().hasEmbeddedConstant() ? Collections.emptySet() : ConstantExpressionIdentifier.getConstantExpressionSet((LogicalExpression)e);
        return (ClassGenerator.HoldingContainer)e.accept(new CSEFilter(constantBoundaries), generator);
    }

    void newScope() {
        this.mapStack.push(this.previousExpressions);
        this.previousExpressions = new HashMap<ExpressionHolder, ClassGenerator.HoldingContainer>(this.previousExpressions);
    }

    void leaveScope() {
        this.previousExpressions.clear();
        this.previousExpressions = this.mapStack.pop();
    }

    private ClassGenerator.HoldingContainer getPrevious(LogicalExpression expression, MappingSet mappingSet) {
        ClassGenerator.HoldingContainer previous = this.previousExpressions.get(new ExpressionHolder(expression, mappingSet));
        if (previous != null) {
            logger.debug("Found previously evaluated expression: {}", (Object)ExpressionStringBuilder.toString(expression));
        }
        return previous;
    }

    private void put(LogicalExpression expression, ClassGenerator.HoldingContainer hc, MappingSet mappingSet) {
        this.previousExpressions.put(new ExpressionHolder(expression, mappingSet), hc);
    }

    private class ConstantFilter
    extends EvalVisitor {
        private Set<LogicalExpression> constantBoundaries;

        public ConstantFilter(Set<LogicalExpression> constantBoundaries) {
            this.constantBoundaries = constantBoundaries;
        }

        @Override
        public ClassGenerator.HoldingContainer visitFunctionCall(FunctionCall e, ClassGenerator<?> generator) throws RuntimeException {
            throw new UnsupportedOperationException("FunctionCall is not expected here. It should have been converted to FunctionHolderExpression in materialization");
        }

        @Override
        public ClassGenerator.HoldingContainer visitFunctionHolderExpression(FunctionHolderExpression e, ClassGenerator<?> generator) throws RuntimeException {
            if (this.constantBoundaries.contains(e)) {
                generator.getMappingSet().enterConstant();
                ClassGenerator.HoldingContainer c = super.visitFunctionHolderExpression(e, generator);
                return this.renderConstantExpression(generator, c);
            }
            if (generator.getMappingSet().isWithinConstant()) {
                return super.visitFunctionHolderExpression(e, generator).setConstant(true);
            }
            return super.visitFunctionHolderExpression(e, generator);
        }

        @Override
        public ClassGenerator.HoldingContainer visitBooleanOperator(BooleanOperator e, ClassGenerator<?> generator) throws RuntimeException {
            if (this.constantBoundaries.contains(e)) {
                generator.getMappingSet().enterConstant();
                ClassGenerator.HoldingContainer c = super.visitBooleanOperator(e, generator);
                return this.renderConstantExpression(generator, c);
            }
            if (generator.getMappingSet().isWithinConstant()) {
                return super.visitBooleanOperator(e, generator).setConstant(true);
            }
            return super.visitBooleanOperator(e, generator);
        }

        @Override
        public ClassGenerator.HoldingContainer visitIfExpression(IfExpression e, ClassGenerator<?> generator) throws RuntimeException {
            if (this.constantBoundaries.contains(e)) {
                generator.getMappingSet().enterConstant();
                ClassGenerator.HoldingContainer c = super.visitIfExpression(e, generator);
                return this.renderConstantExpression(generator, c);
            }
            if (generator.getMappingSet().isWithinConstant()) {
                return super.visitIfExpression(e, generator).setConstant(true);
            }
            return super.visitIfExpression(e, generator);
        }

        @Override
        public ClassGenerator.HoldingContainer visitSchemaPath(SchemaPath e, ClassGenerator<?> generator) throws RuntimeException {
            if (this.constantBoundaries.contains(e)) {
                generator.getMappingSet().enterConstant();
                ClassGenerator.HoldingContainer c = super.visitSchemaPath(e, generator);
                return this.renderConstantExpression(generator, c);
            }
            if (generator.getMappingSet().isWithinConstant()) {
                return super.visitSchemaPath(e, generator).setConstant(true);
            }
            return super.visitSchemaPath(e, generator);
        }

        @Override
        public ClassGenerator.HoldingContainer visitLongConstant(ValueExpressions.LongExpression e, ClassGenerator<?> generator) throws RuntimeException {
            if (this.constantBoundaries.contains(e)) {
                generator.getMappingSet().enterConstant();
                ClassGenerator.HoldingContainer c = super.visitLongConstant(e, generator);
                return this.renderConstantExpression(generator, c);
            }
            if (generator.getMappingSet().isWithinConstant()) {
                return super.visitLongConstant(e, generator).setConstant(true);
            }
            return super.visitLongConstant(e, generator);
        }

        @Override
        public ClassGenerator.HoldingContainer visitDecimal9Constant(ValueExpressions.Decimal9Expression e, ClassGenerator<?> generator) throws RuntimeException {
            if (this.constantBoundaries.contains(e)) {
                generator.getMappingSet().enterConstant();
                ClassGenerator.HoldingContainer c = super.visitDecimal9Constant(e, generator);
                return this.renderConstantExpression(generator, c);
            }
            if (generator.getMappingSet().isWithinConstant()) {
                return super.visitDecimal9Constant(e, generator).setConstant(true);
            }
            return super.visitDecimal9Constant(e, generator);
        }

        @Override
        public ClassGenerator.HoldingContainer visitDecimal18Constant(ValueExpressions.Decimal18Expression e, ClassGenerator<?> generator) throws RuntimeException {
            if (this.constantBoundaries.contains(e)) {
                generator.getMappingSet().enterConstant();
                ClassGenerator.HoldingContainer c = super.visitDecimal18Constant(e, generator);
                return this.renderConstantExpression(generator, c);
            }
            if (generator.getMappingSet().isWithinConstant()) {
                return super.visitDecimal18Constant(e, generator).setConstant(true);
            }
            return super.visitDecimal18Constant(e, generator);
        }

        @Override
        public ClassGenerator.HoldingContainer visitDecimal28Constant(ValueExpressions.Decimal28Expression e, ClassGenerator<?> generator) throws RuntimeException {
            if (this.constantBoundaries.contains(e)) {
                generator.getMappingSet().enterConstant();
                ClassGenerator.HoldingContainer c = super.visitDecimal28Constant(e, generator);
                return this.renderConstantExpression(generator, c);
            }
            if (generator.getMappingSet().isWithinConstant()) {
                return super.visitDecimal28Constant(e, generator).setConstant(true);
            }
            return super.visitDecimal28Constant(e, generator);
        }

        @Override
        public ClassGenerator.HoldingContainer visitDecimal38Constant(ValueExpressions.Decimal38Expression e, ClassGenerator<?> generator) throws RuntimeException {
            if (this.constantBoundaries.contains(e)) {
                generator.getMappingSet().enterConstant();
                ClassGenerator.HoldingContainer c = super.visitDecimal38Constant(e, generator);
                return this.renderConstantExpression(generator, c);
            }
            if (generator.getMappingSet().isWithinConstant()) {
                return super.visitDecimal38Constant(e, generator).setConstant(true);
            }
            return super.visitDecimal38Constant(e, generator);
        }

        @Override
        public ClassGenerator.HoldingContainer visitIntConstant(ValueExpressions.IntExpression e, ClassGenerator<?> generator) throws RuntimeException {
            if (this.constantBoundaries.contains(e)) {
                generator.getMappingSet().enterConstant();
                ClassGenerator.HoldingContainer c = super.visitIntConstant(e, generator);
                return this.renderConstantExpression(generator, c);
            }
            if (generator.getMappingSet().isWithinConstant()) {
                return super.visitIntConstant(e, generator).setConstant(true);
            }
            return super.visitIntConstant(e, generator);
        }

        @Override
        public ClassGenerator.HoldingContainer visitDateConstant(ValueExpressions.DateExpression e, ClassGenerator<?> generator) throws RuntimeException {
            if (this.constantBoundaries.contains(e)) {
                generator.getMappingSet().enterConstant();
                ClassGenerator.HoldingContainer c = super.visitDateConstant(e, generator);
                return this.renderConstantExpression(generator, c);
            }
            if (generator.getMappingSet().isWithinConstant()) {
                return super.visitDateConstant(e, generator).setConstant(true);
            }
            return super.visitDateConstant(e, generator);
        }

        @Override
        public ClassGenerator.HoldingContainer visitTimeConstant(ValueExpressions.TimeExpression e, ClassGenerator<?> generator) throws RuntimeException {
            if (this.constantBoundaries.contains(e)) {
                generator.getMappingSet().enterConstant();
                ClassGenerator.HoldingContainer c = super.visitTimeConstant(e, generator);
                return this.renderConstantExpression(generator, c);
            }
            if (generator.getMappingSet().isWithinConstant()) {
                return super.visitTimeConstant(e, generator).setConstant(true);
            }
            return super.visitTimeConstant(e, generator);
        }

        @Override
        public ClassGenerator.HoldingContainer visitIntervalYearConstant(ValueExpressions.IntervalYearExpression e, ClassGenerator<?> generator) throws RuntimeException {
            if (this.constantBoundaries.contains(e)) {
                generator.getMappingSet().enterConstant();
                ClassGenerator.HoldingContainer c = super.visitIntervalYearConstant(e, generator);
                return this.renderConstantExpression(generator, c);
            }
            if (generator.getMappingSet().isWithinConstant()) {
                return super.visitIntervalYearConstant(e, generator).setConstant(true);
            }
            return super.visitIntervalYearConstant(e, generator);
        }

        @Override
        public ClassGenerator.HoldingContainer visitTimeStampConstant(ValueExpressions.TimeStampExpression e, ClassGenerator<?> generator) throws RuntimeException {
            if (this.constantBoundaries.contains(e)) {
                generator.getMappingSet().enterConstant();
                ClassGenerator.HoldingContainer c = super.visitTimeStampConstant(e, generator);
                return this.renderConstantExpression(generator, c);
            }
            if (generator.getMappingSet().isWithinConstant()) {
                return super.visitTimeStampConstant(e, generator).setConstant(true);
            }
            return super.visitTimeStampConstant(e, generator);
        }

        @Override
        public ClassGenerator.HoldingContainer visitFloatConstant(ValueExpressions.FloatExpression e, ClassGenerator<?> generator) throws RuntimeException {
            if (this.constantBoundaries.contains(e)) {
                generator.getMappingSet().enterConstant();
                ClassGenerator.HoldingContainer c = super.visitFloatConstant(e, generator);
                return this.renderConstantExpression(generator, c);
            }
            if (generator.getMappingSet().isWithinConstant()) {
                return super.visitFloatConstant(e, generator).setConstant(true);
            }
            return super.visitFloatConstant(e, generator);
        }

        @Override
        public ClassGenerator.HoldingContainer visitDoubleConstant(ValueExpressions.DoubleExpression e, ClassGenerator<?> generator) throws RuntimeException {
            if (this.constantBoundaries.contains(e)) {
                generator.getMappingSet().enterConstant();
                ClassGenerator.HoldingContainer c = super.visitDoubleConstant(e, generator);
                return this.renderConstantExpression(generator, c);
            }
            if (generator.getMappingSet().isWithinConstant()) {
                return super.visitDoubleConstant(e, generator).setConstant(true);
            }
            return super.visitDoubleConstant(e, generator);
        }

        @Override
        public ClassGenerator.HoldingContainer visitBooleanConstant(ValueExpressions.BooleanExpression e, ClassGenerator<?> generator) throws RuntimeException {
            if (this.constantBoundaries.contains(e)) {
                generator.getMappingSet().enterConstant();
                ClassGenerator.HoldingContainer c = super.visitBooleanConstant(e, generator);
                return this.renderConstantExpression(generator, c);
            }
            if (generator.getMappingSet().isWithinConstant()) {
                return super.visitBooleanConstant(e, generator).setConstant(true);
            }
            return super.visitBooleanConstant(e, generator);
        }

        @Override
        public ClassGenerator.HoldingContainer visitUnknown(LogicalExpression e, ClassGenerator<?> generator) throws RuntimeException {
            if (this.constantBoundaries.contains(e)) {
                generator.getMappingSet().enterConstant();
                ClassGenerator.HoldingContainer c = super.visitUnknown(e, generator);
                return this.renderConstantExpression(generator, c);
            }
            if (generator.getMappingSet().isWithinConstant()) {
                return super.visitUnknown(e, generator).setConstant(true);
            }
            return super.visitUnknown(e, generator);
        }

        @Override
        public ClassGenerator.HoldingContainer visitQuotedStringConstant(ValueExpressions.QuotedString e, ClassGenerator<?> generator) throws RuntimeException {
            if (this.constantBoundaries.contains(e)) {
                generator.getMappingSet().enterConstant();
                ClassGenerator.HoldingContainer c = super.visitQuotedStringConstant(e, generator);
                return this.renderConstantExpression(generator, c);
            }
            if (generator.getMappingSet().isWithinConstant()) {
                return super.visitQuotedStringConstant(e, generator).setConstant(true);
            }
            return super.visitQuotedStringConstant(e, generator);
        }

        @Override
        public ClassGenerator.HoldingContainer visitIntervalDayConstant(ValueExpressions.IntervalDayExpression e, ClassGenerator<?> generator) throws RuntimeException {
            if (this.constantBoundaries.contains(e)) {
                generator.getMappingSet().enterConstant();
                ClassGenerator.HoldingContainer c = super.visitIntervalDayConstant(e, generator);
                return this.renderConstantExpression(generator, c);
            }
            if (generator.getMappingSet().isWithinConstant()) {
                return super.visitIntervalDayConstant(e, generator).setConstant(true);
            }
            return super.visitIntervalDayConstant(e, generator);
        }

        private ClassGenerator.HoldingContainer renderConstantExpression(ClassGenerator<?> generator, ClassGenerator.HoldingContainer input) {
            JVar fieldValue = generator.declareClassField("constant", generator.getHolderType(input.getMajorType()));
            generator.getEvalBlock().assign((JAssignmentTarget)fieldValue, (JExpression)input.getHolder());
            generator.getMappingSet().exitConstant();
            return new ClassGenerator.HoldingContainer(input.getMajorType(), fieldValue, fieldValue.ref("value"), fieldValue.ref("isSet")).setConstant(true);
        }
    }

    private class CSEFilter
    extends ConstantFilter {
        public CSEFilter(Set<LogicalExpression> constantBoundaries) {
            super(constantBoundaries);
        }

        @Override
        public ClassGenerator.HoldingContainer visitFunctionCall(FunctionCall call, ClassGenerator<?> generator) throws RuntimeException {
            ClassGenerator.HoldingContainer hc = EvaluationVisitor.this.getPrevious(call, generator.getMappingSet());
            if (hc == null) {
                hc = super.visitFunctionCall(call, generator);
                EvaluationVisitor.this.put(call, hc, generator.getMappingSet());
            }
            return hc;
        }

        @Override
        public ClassGenerator.HoldingContainer visitFunctionHolderExpression(FunctionHolderExpression holder, ClassGenerator<?> generator) throws RuntimeException {
            ClassGenerator.HoldingContainer hc = EvaluationVisitor.this.getPrevious(holder, generator.getMappingSet());
            if (hc == null) {
                hc = super.visitFunctionHolderExpression(holder, generator);
                EvaluationVisitor.this.put(holder, hc, generator.getMappingSet());
            }
            return hc;
        }

        @Override
        public ClassGenerator.HoldingContainer visitIfExpression(IfExpression ifExpr, ClassGenerator<?> generator) throws RuntimeException {
            ClassGenerator.HoldingContainer hc = EvaluationVisitor.this.getPrevious(ifExpr, generator.getMappingSet());
            if (hc == null) {
                hc = super.visitIfExpression(ifExpr, generator);
                EvaluationVisitor.this.put(ifExpr, hc, generator.getMappingSet());
            }
            return hc;
        }

        @Override
        public ClassGenerator.HoldingContainer visitBooleanOperator(BooleanOperator call, ClassGenerator<?> generator) throws RuntimeException {
            ClassGenerator.HoldingContainer hc = EvaluationVisitor.this.getPrevious(call, generator.getMappingSet());
            if (hc == null) {
                hc = super.visitBooleanOperator(call, generator);
                EvaluationVisitor.this.put(call, hc, generator.getMappingSet());
            }
            return hc;
        }

        @Override
        public ClassGenerator.HoldingContainer visitSchemaPath(SchemaPath path, ClassGenerator<?> generator) throws RuntimeException {
            ClassGenerator.HoldingContainer hc = EvaluationVisitor.this.getPrevious(path, generator.getMappingSet());
            if (hc == null) {
                hc = super.visitSchemaPath(path, generator);
                EvaluationVisitor.this.put(path, hc, generator.getMappingSet());
            }
            return hc;
        }

        @Override
        public ClassGenerator.HoldingContainer visitIntConstant(ValueExpressions.IntExpression intExpr, ClassGenerator<?> generator) throws RuntimeException {
            ClassGenerator.HoldingContainer hc = EvaluationVisitor.this.getPrevious(intExpr, generator.getMappingSet());
            if (hc == null) {
                hc = super.visitIntConstant(intExpr, generator);
                EvaluationVisitor.this.put(intExpr, hc, generator.getMappingSet());
            }
            return hc;
        }

        @Override
        public ClassGenerator.HoldingContainer visitFloatConstant(ValueExpressions.FloatExpression fExpr, ClassGenerator<?> generator) throws RuntimeException {
            ClassGenerator.HoldingContainer hc = EvaluationVisitor.this.getPrevious(fExpr, generator.getMappingSet());
            if (hc == null) {
                hc = super.visitFloatConstant(fExpr, generator);
                EvaluationVisitor.this.put(fExpr, hc, generator.getMappingSet());
            }
            return hc;
        }

        @Override
        public ClassGenerator.HoldingContainer visitLongConstant(ValueExpressions.LongExpression longExpr, ClassGenerator<?> generator) throws RuntimeException {
            ClassGenerator.HoldingContainer hc = EvaluationVisitor.this.getPrevious(longExpr, generator.getMappingSet());
            if (hc == null) {
                hc = super.visitLongConstant(longExpr, generator);
                EvaluationVisitor.this.put(longExpr, hc, generator.getMappingSet());
            }
            return hc;
        }

        @Override
        public ClassGenerator.HoldingContainer visitDateConstant(ValueExpressions.DateExpression dateExpr, ClassGenerator<?> generator) throws RuntimeException {
            ClassGenerator.HoldingContainer hc = EvaluationVisitor.this.getPrevious(dateExpr, generator.getMappingSet());
            if (hc == null) {
                hc = super.visitDateConstant(dateExpr, generator);
                EvaluationVisitor.this.put(dateExpr, hc, generator.getMappingSet());
            }
            return hc;
        }

        @Override
        public ClassGenerator.HoldingContainer visitTimeConstant(ValueExpressions.TimeExpression timeExpr, ClassGenerator<?> generator) throws RuntimeException {
            ClassGenerator.HoldingContainer hc = EvaluationVisitor.this.getPrevious(timeExpr, generator.getMappingSet());
            if (hc == null) {
                hc = super.visitTimeConstant(timeExpr, generator);
                EvaluationVisitor.this.put(timeExpr, hc, generator.getMappingSet());
            }
            return hc;
        }

        @Override
        public ClassGenerator.HoldingContainer visitTimeStampConstant(ValueExpressions.TimeStampExpression timeStampExpr, ClassGenerator<?> generator) throws RuntimeException {
            ClassGenerator.HoldingContainer hc = EvaluationVisitor.this.getPrevious(timeStampExpr, generator.getMappingSet());
            if (hc == null) {
                hc = super.visitTimeStampConstant(timeStampExpr, generator);
                EvaluationVisitor.this.put(timeStampExpr, hc, generator.getMappingSet());
            }
            return hc;
        }

        @Override
        public ClassGenerator.HoldingContainer visitIntervalYearConstant(ValueExpressions.IntervalYearExpression intervalYearExpression, ClassGenerator<?> generator) throws RuntimeException {
            ClassGenerator.HoldingContainer hc = EvaluationVisitor.this.getPrevious(intervalYearExpression, generator.getMappingSet());
            if (hc == null) {
                hc = super.visitIntervalYearConstant(intervalYearExpression, generator);
                EvaluationVisitor.this.put(intervalYearExpression, hc, generator.getMappingSet());
            }
            return hc;
        }

        @Override
        public ClassGenerator.HoldingContainer visitIntervalDayConstant(ValueExpressions.IntervalDayExpression intervalDayExpression, ClassGenerator<?> generator) throws RuntimeException {
            ClassGenerator.HoldingContainer hc = EvaluationVisitor.this.getPrevious(intervalDayExpression, generator.getMappingSet());
            if (hc == null) {
                hc = super.visitIntervalDayConstant(intervalDayExpression, generator);
                EvaluationVisitor.this.put(intervalDayExpression, hc, generator.getMappingSet());
            }
            return hc;
        }

        @Override
        public ClassGenerator.HoldingContainer visitDecimal9Constant(ValueExpressions.Decimal9Expression decExpr, ClassGenerator<?> generator) throws RuntimeException {
            ClassGenerator.HoldingContainer hc = EvaluationVisitor.this.getPrevious(decExpr, generator.getMappingSet());
            if (hc == null) {
                hc = super.visitDecimal9Constant(decExpr, generator);
                EvaluationVisitor.this.put(decExpr, hc, generator.getMappingSet());
            }
            return hc;
        }

        @Override
        public ClassGenerator.HoldingContainer visitDecimal18Constant(ValueExpressions.Decimal18Expression decExpr, ClassGenerator<?> generator) throws RuntimeException {
            ClassGenerator.HoldingContainer hc = EvaluationVisitor.this.getPrevious(decExpr, generator.getMappingSet());
            if (hc == null) {
                hc = super.visitDecimal18Constant(decExpr, generator);
                EvaluationVisitor.this.put(decExpr, hc, generator.getMappingSet());
            }
            return hc;
        }

        @Override
        public ClassGenerator.HoldingContainer visitDecimal28Constant(ValueExpressions.Decimal28Expression decExpr, ClassGenerator<?> generator) throws RuntimeException {
            ClassGenerator.HoldingContainer hc = EvaluationVisitor.this.getPrevious(decExpr, generator.getMappingSet());
            if (hc == null) {
                hc = super.visitDecimal28Constant(decExpr, generator);
                EvaluationVisitor.this.put(decExpr, hc, generator.getMappingSet());
            }
            return hc;
        }

        @Override
        public ClassGenerator.HoldingContainer visitDecimal38Constant(ValueExpressions.Decimal38Expression decExpr, ClassGenerator<?> generator) throws RuntimeException {
            ClassGenerator.HoldingContainer hc = EvaluationVisitor.this.getPrevious(decExpr, generator.getMappingSet());
            if (hc == null) {
                hc = super.visitDecimal38Constant(decExpr, generator);
                EvaluationVisitor.this.put(decExpr, hc, generator.getMappingSet());
            }
            return hc;
        }

        @Override
        public ClassGenerator.HoldingContainer visitDoubleConstant(ValueExpressions.DoubleExpression dExpr, ClassGenerator<?> generator) throws RuntimeException {
            ClassGenerator.HoldingContainer hc = EvaluationVisitor.this.getPrevious(dExpr, generator.getMappingSet());
            if (hc == null) {
                hc = super.visitDoubleConstant(dExpr, generator);
                EvaluationVisitor.this.put(dExpr, hc, generator.getMappingSet());
            }
            return hc;
        }

        @Override
        public ClassGenerator.HoldingContainer visitBooleanConstant(ValueExpressions.BooleanExpression e, ClassGenerator<?> generator) throws RuntimeException {
            ClassGenerator.HoldingContainer hc = EvaluationVisitor.this.getPrevious(e, generator.getMappingSet());
            if (hc == null) {
                hc = super.visitBooleanConstant(e, generator);
                EvaluationVisitor.this.put(e, hc, generator.getMappingSet());
            }
            return hc;
        }

        @Override
        public ClassGenerator.HoldingContainer visitQuotedStringConstant(ValueExpressions.QuotedString e, ClassGenerator<?> generator) throws RuntimeException {
            ClassGenerator.HoldingContainer hc = EvaluationVisitor.this.getPrevious(e, generator.getMappingSet());
            if (hc == null) {
                hc = super.visitQuotedStringConstant(e, generator);
                EvaluationVisitor.this.put(e, hc, generator.getMappingSet());
            }
            return hc;
        }

        @Override
        public ClassGenerator.HoldingContainer visitNullConstant(TypedNullConstant e, ClassGenerator<?> generator) throws RuntimeException {
            return (ClassGenerator.HoldingContainer)super.visitNullConstant(e, generator);
        }

        @Override
        public ClassGenerator.HoldingContainer visitNullExpression(NullExpression e, ClassGenerator<?> generator) throws RuntimeException {
            ClassGenerator.HoldingContainer hc = EvaluationVisitor.this.getPrevious(e, generator.getMappingSet());
            if (hc == null) {
                hc = (ClassGenerator.HoldingContainer)super.visitNullExpression(e, generator);
                EvaluationVisitor.this.put(e, hc, generator.getMappingSet());
            }
            return hc;
        }

        @Override
        public ClassGenerator.HoldingContainer visitUnknown(LogicalExpression e, ClassGenerator<?> generator) throws RuntimeException {
            if (e instanceof ValueVectorReadExpression) {
                ClassGenerator.HoldingContainer hc = EvaluationVisitor.this.getPrevious(e, generator.getMappingSet());
                if (hc == null) {
                    hc = super.visitUnknown(e, generator);
                    EvaluationVisitor.this.put(e, hc, generator.getMappingSet());
                }
                return hc;
            }
            return super.visitUnknown(e, generator);
        }

        @Override
        public ClassGenerator.HoldingContainer visitCastExpression(CastExpression e, ClassGenerator<?> generator) throws RuntimeException {
            ClassGenerator.HoldingContainer hc = EvaluationVisitor.this.getPrevious(e, generator.getMappingSet());
            if (hc == null) {
                hc = super.visitCastExpression(e, generator);
                EvaluationVisitor.this.put(e, hc, generator.getMappingSet());
            }
            return hc;
        }

        @Override
        public ClassGenerator.HoldingContainer visitConvertExpression(ConvertExpression e, ClassGenerator<?> generator) throws RuntimeException {
            ClassGenerator.HoldingContainer hc = EvaluationVisitor.this.getPrevious(e, generator.getMappingSet());
            if (hc == null) {
                hc = super.visitConvertExpression(e, generator);
                EvaluationVisitor.this.put(e, hc, generator.getMappingSet());
            }
            return hc;
        }
    }

    private class EvalVisitor
    extends AbstractExprVisitor<ClassGenerator.HoldingContainer, ClassGenerator<?>, RuntimeException> {
        private EvalVisitor() {
        }

        @Override
        public ClassGenerator.HoldingContainer visitFunctionCall(FunctionCall call, ClassGenerator<?> generator) throws RuntimeException {
            throw new UnsupportedOperationException("FunctionCall is not expected here. It should have been converted to FunctionHolderExpression in materialization");
        }

        @Override
        public ClassGenerator.HoldingContainer visitBooleanOperator(BooleanOperator op, ClassGenerator<?> generator) throws RuntimeException {
            if (op.getName().equals("booleanAnd")) {
                return this.visitBooleanAnd(op, generator);
            }
            if (op.getName().equals("booleanOr")) {
                return this.visitBooleanOr(op, generator);
            }
            throw new UnsupportedOperationException("BooleanOperator can only be booleanAnd, booleanOr. You are using " + op.getName());
        }

        @Override
        public ClassGenerator.HoldingContainer visitFunctionHolderExpression(FunctionHolderExpression holderExpr, ClassGenerator<?> generator) throws RuntimeException {
            AbstractFuncHolder holder = (AbstractFuncHolder)holderExpr.getHolder();
            JVar[] workspaceVars = holder.renderStart(generator, null);
            if (holder.isNested()) {
                generator.getMappingSet().enterChild();
            }
            ClassGenerator.HoldingContainer[] args = new ClassGenerator.HoldingContainer[holderExpr.args.size()];
            for (int i = 0; i < holderExpr.args.size(); ++i) {
                args[i] = (ClassGenerator.HoldingContainer)((LogicalExpression)holderExpr.args.get(i)).accept(this, generator);
            }
            holder.renderMiddle(generator, args, workspaceVars);
            if (holder.isNested()) {
                generator.getMappingSet().exitChild();
            }
            return holder.renderEnd(generator, args, workspaceVars);
        }

        @Override
        public ClassGenerator.HoldingContainer visitIfExpression(IfExpression ifExpr, ClassGenerator<?> generator) throws RuntimeException {
            JBlock local = generator.getEvalBlock();
            ClassGenerator.HoldingContainer output = generator.declare(ifExpr.getMajorType());
            JConditional jc = null;
            JBlock conditionalBlock = new JBlock(false, false);
            IfExpression.IfCondition c = ifExpr.ifCondition;
            ClassGenerator.HoldingContainer holdingContainer = (ClassGenerator.HoldingContainer)c.condition.accept(this, generator);
            jc = jc == null ? (holdingContainer.isOptional() ? conditionalBlock._if(holdingContainer.getIsSet().eq(JExpr.lit((int)1)).cand(holdingContainer.getValue().eq(JExpr.lit((int)1)))) : conditionalBlock._if(holdingContainer.getValue().eq(JExpr.lit((int)1)))) : (holdingContainer.isOptional() ? jc._else()._if(holdingContainer.getIsSet().eq(JExpr.lit((int)1)).cand(holdingContainer.getValue().eq(JExpr.lit((int)1)))) : jc._else()._if(holdingContainer.getValue().eq(JExpr.lit((int)1))));
            generator.nestEvalBlock(jc._then());
            ClassGenerator.HoldingContainer thenExpr = (ClassGenerator.HoldingContainer)c.expression.accept(this, generator);
            generator.unNestEvalBlock();
            if (thenExpr.isOptional()) {
                JConditional newCond = jc._then()._if(thenExpr.getIsSet().ne(JExpr.lit((int)0)));
                JBlock b = newCond._then();
                b.assign((JAssignmentTarget)output.getHolder(), (JExpression)thenExpr.getHolder());
            } else {
                jc._then().assign((JAssignmentTarget)output.getHolder(), (JExpression)thenExpr.getHolder());
            }
            generator.nestEvalBlock(jc._else());
            ClassGenerator.HoldingContainer elseExpr = (ClassGenerator.HoldingContainer)ifExpr.elseExpression.accept(this, generator);
            generator.unNestEvalBlock();
            if (elseExpr.isOptional()) {
                JConditional newCond = jc._else()._if(elseExpr.getIsSet().ne(JExpr.lit((int)0)));
                JBlock b = newCond._then();
                b.assign((JAssignmentTarget)output.getHolder(), (JExpression)elseExpr.getHolder());
            } else {
                jc._else().assign((JAssignmentTarget)output.getHolder(), (JExpression)elseExpr.getHolder());
            }
            local.add((JStatement)conditionalBlock);
            return output;
        }

        @Override
        public ClassGenerator.HoldingContainer visitSchemaPath(SchemaPath path, ClassGenerator<?> generator) throws RuntimeException {
            throw new UnsupportedOperationException("All schema paths should have been replaced with ValueVectorExpressions.");
        }

        @Override
        public ClassGenerator.HoldingContainer visitLongConstant(ValueExpressions.LongExpression e, ClassGenerator<?> generator) throws RuntimeException {
            ClassGenerator.HoldingContainer out = generator.declare(e.getMajorType());
            generator.getEvalBlock().assign((JAssignmentTarget)out.getValue(), JExpr.lit((long)e.getLong()));
            return out;
        }

        @Override
        public ClassGenerator.HoldingContainer visitIntConstant(ValueExpressions.IntExpression e, ClassGenerator<?> generator) throws RuntimeException {
            ClassGenerator.HoldingContainer out = generator.declare(e.getMajorType());
            generator.getEvalBlock().assign((JAssignmentTarget)out.getValue(), JExpr.lit((int)e.getInt()));
            return out;
        }

        @Override
        public ClassGenerator.HoldingContainer visitDateConstant(ValueExpressions.DateExpression e, ClassGenerator<?> generator) throws RuntimeException {
            ClassGenerator.HoldingContainer out = generator.declare(e.getMajorType());
            generator.getEvalBlock().assign((JAssignmentTarget)out.getValue(), JExpr.lit((long)e.getDate()));
            return out;
        }

        @Override
        public ClassGenerator.HoldingContainer visitTimeConstant(ValueExpressions.TimeExpression e, ClassGenerator<?> generator) throws RuntimeException {
            ClassGenerator.HoldingContainer out = generator.declare(e.getMajorType());
            generator.getEvalBlock().assign((JAssignmentTarget)out.getValue(), JExpr.lit((int)e.getTime()));
            return out;
        }

        @Override
        public ClassGenerator.HoldingContainer visitIntervalYearConstant(ValueExpressions.IntervalYearExpression e, ClassGenerator<?> generator) throws RuntimeException {
            ClassGenerator.HoldingContainer out = generator.declare(e.getMajorType());
            generator.getEvalBlock().assign((JAssignmentTarget)out.getValue(), JExpr.lit((int)e.getIntervalYear()));
            return out;
        }

        @Override
        public ClassGenerator.HoldingContainer visitTimeStampConstant(ValueExpressions.TimeStampExpression e, ClassGenerator<?> generator) throws RuntimeException {
            ClassGenerator.HoldingContainer out = generator.declare(e.getMajorType());
            generator.getEvalBlock().assign((JAssignmentTarget)out.getValue(), JExpr.lit((long)e.getTimeStamp()));
            return out;
        }

        @Override
        public ClassGenerator.HoldingContainer visitFloatConstant(ValueExpressions.FloatExpression e, ClassGenerator<?> generator) throws RuntimeException {
            ClassGenerator.HoldingContainer out = generator.declare(e.getMajorType());
            generator.getEvalBlock().assign((JAssignmentTarget)out.getValue(), JExpr.lit((float)e.getFloat()));
            return out;
        }

        @Override
        public ClassGenerator.HoldingContainer visitDoubleConstant(ValueExpressions.DoubleExpression e, ClassGenerator<?> generator) throws RuntimeException {
            ClassGenerator.HoldingContainer out = generator.declare(e.getMajorType());
            generator.getEvalBlock().assign((JAssignmentTarget)out.getValue(), JExpr.lit((double)e.getDouble()));
            return out;
        }

        @Override
        public ClassGenerator.HoldingContainer visitBooleanConstant(ValueExpressions.BooleanExpression e, ClassGenerator<?> generator) throws RuntimeException {
            ClassGenerator.HoldingContainer out = generator.declare(e.getMajorType());
            generator.getEvalBlock().assign((JAssignmentTarget)out.getValue(), JExpr.lit((int)(e.getBoolean() ? 1 : 0)));
            return out;
        }

        @Override
        public ClassGenerator.HoldingContainer visitUnknown(LogicalExpression e, ClassGenerator<?> generator) throws RuntimeException {
            if (e instanceof ValueVectorReadExpression) {
                return this.visitValueVectorReadExpression((ValueVectorReadExpression)e, generator);
            }
            if (e instanceof ValueVectorWriteExpression) {
                return this.visitValueVectorWriteExpression((ValueVectorWriteExpression)e, generator);
            }
            if (e instanceof ReturnValueExpression) {
                return this.visitReturnValueExpression((ReturnValueExpression)e, generator);
            }
            if (e instanceof HoldingContainerExpression) {
                return ((HoldingContainerExpression)e).getContainer();
            }
            if (e instanceof NullExpression) {
                return generator.declare(Types.optional(TypeProtos.MinorType.INT));
            }
            if (e instanceof TypedNullConstant) {
                return generator.declare(e.getMajorType());
            }
            return (ClassGenerator.HoldingContainer)super.visitUnknown(e, generator);
        }

        private ClassGenerator.HoldingContainer visitValueVectorWriteExpression(ValueVectorWriteExpression e, ClassGenerator<?> generator) {
            LogicalExpression child = e.getChild();
            ClassGenerator.HoldingContainer inputContainer = (ClassGenerator.HoldingContainer)child.accept(this, generator);
            JBlock block = generator.getEvalBlock();
            DirectExpression outIndex = generator.getMappingSet().getValueWriteIndex();
            JVar vv = generator.declareVectorValueSetupAndMember(generator.getMappingSet().getOutgoing(), e.getFieldId());
            if (inputContainer.isReader()) {
                JType writerImpl = generator.getModel()._ref(TypeHelper.getWriterImpl(inputContainer.getMinorType(), inputContainer.getMajorType().getMode()));
                JType writerIFace = generator.getModel()._ref(TypeHelper.getWriterInterface(inputContainer.getMinorType(), inputContainer.getMajorType().getMode()));
                JVar writer = generator.declareClassField("writer", writerIFace);
                generator.getSetupBlock().assign((JAssignmentTarget)writer, (JExpression)JExpr._new((JType)writerImpl).arg((JExpression)vv).arg(JExpr._null()));
                generator.getEvalBlock().add((JStatement)writer.invoke("setPosition").arg((JExpression)outIndex));
                String copyMethod = inputContainer.isSingularRepeated() ? "copyAsValueSingle" : "copyAsValue";
                generator.getEvalBlock().add((JStatement)inputContainer.getHolder().invoke(copyMethod).arg((JExpression)writer));
                if (e.isSafe()) {
                    ClassGenerator.HoldingContainer outputContainer = generator.declare(Types.REQUIRED_BIT);
                    generator.getEvalBlock().assign((JAssignmentTarget)outputContainer.getValue(), JExpr.lit((int)1));
                    return outputContainer;
                }
            } else {
                JInvocation setMeth = GetSetVectorHelper.write(e.getChild().getMajorType(), vv, inputContainer, (JExpression)outIndex, e.isSafe() ? "setSafe" : "set");
                if (inputContainer.isOptional()) {
                    JConditional jc = block._if(inputContainer.getIsSet().eq(JExpr.lit((int)0)).not());
                    block = jc._then();
                }
                block.add((JStatement)setMeth);
            }
            return null;
        }

        private ClassGenerator.HoldingContainer visitValueVectorReadExpression(ValueVectorReadExpression e, ClassGenerator<?> generator) throws RuntimeException {
            JVar vv1 = generator.declareVectorValueSetupAndMember(generator.getMappingSet().getIncoming(), e.getFieldId());
            DirectExpression indexVariable = generator.getMappingSet().getValueReadIndex();
            JExpression componentVariable = indexVariable.shrz(JExpr.lit((int)16));
            if (e.isSuperReader()) {
                vv1 = vv1.component(componentVariable);
                indexVariable = indexVariable.band(JExpr.lit((int)65535));
            }
            ClassGenerator.HoldingContainer out = generator.declare(e.getMajorType());
            boolean hasReadPath = e.hasReadPath();
            boolean complex = Types.isComplex(e.getMajorType());
            boolean repeated = Types.isRepeated(e.getMajorType());
            boolean listVector = e.getTypedFieldId().isListVector();
            int[] fieldIds = e.getFieldId().getFieldIds();
            for (int i = 1; i < fieldIds.length; ++i) {
            }
            if (!hasReadPath && !complex) {
                JBlock eval = new JBlock();
                GetSetVectorHelper.read(e.getMajorType(), (JExpression)vv1, eval, out, generator.getModel(), (JExpression)indexVariable);
                generator.getEvalBlock().add((JStatement)eval);
            } else {
                JVar vector = e.isSuperReader() ? vv1.component(componentVariable) : vv1;
                JInvocation expr = vector.invoke("getReader");
                PathSegment seg = e.getReadPath();
                JVar isNull = null;
                boolean isNullReaderLikely = this.isNullReaderLikely(seg, complex || repeated || listVector);
                if (isNullReaderLikely) {
                    isNull = generator.getEvalBlock().decl((JType)generator.getModel().INT, generator.getNextVar("isNull"), JExpr.lit((int)0));
                }
                JLabel label = generator.getEvalBlock().label("complex");
                JBlock eval = generator.getEvalBlock().block();
                eval.add((JStatement)expr.invoke("reset"));
                eval.add((JStatement)expr.invoke("setPosition").arg((JExpression)indexVariable));
                int listNum = 0;
                while (seg != null) {
                    if (seg.isArray()) {
                        if (seg.isLastPath() && !complex && !repeated && !listVector) break;
                        JVar list = generator.declareClassField("list", generator.getModel()._ref(FieldReader.class));
                        eval.assign((JAssignmentTarget)list, (JExpression)expr);
                        JVar desiredIndex = eval.decl((JType)generator.getModel().INT, "desiredIndex" + listNum, JExpr.lit((int)seg.getArraySegment().getIndex()));
                        JVar currentIndex = eval.decl((JType)generator.getModel().INT, "currentIndex" + listNum, JExpr.lit((int)-1));
                        eval._while(currentIndex.lt((JExpression)desiredIndex).cand((JExpression)list.invoke("next"))).body().assign((JAssignmentTarget)currentIndex, currentIndex.plus(JExpr.lit((int)1)));
                        JBlock ifNoVal = eval._if(desiredIndex.ne((JExpression)currentIndex))._then().block();
                        if (out.isOptional()) {
                            ifNoVal.assign((JAssignmentTarget)out.getIsSet(), JExpr.lit((int)0));
                        }
                        ifNoVal.assign((JAssignmentTarget)isNull, JExpr.lit((int)1));
                        ifNoVal._break(label);
                        expr = list.invoke("reader");
                        ++listNum;
                    } else {
                        JExpression fieldName = JExpr.lit((String)seg.getNameSegment().getPath());
                        expr = expr.invoke("reader").arg(fieldName);
                    }
                    seg = seg.getChild();
                }
                if (complex || repeated) {
                    TypeProtos.MajorType finalType = e.getFieldId().getFinalType();
                    JVar complexReader = generator.declareClassField("reader", generator.getModel()._ref(FieldReader.class));
                    if (isNullReaderLikely) {
                        JConditional jc = generator.getEvalBlock()._if(isNull.eq(JExpr.lit((int)0)));
                        JClass nrClass = generator.getModel().ref(NullReader.class);
                        JFieldRef nullReader = complex ? nrClass.staticRef("EMPTY_MAP_INSTANCE") : (repeated ? nrClass.staticRef("EMPTY_LIST_INSTANCE") : nrClass.staticRef("INSTANCE"));
                        jc._then().assign((JAssignmentTarget)complexReader, (JExpression)expr);
                        jc._else().assign((JAssignmentTarget)complexReader, (JExpression)nullReader);
                    } else {
                        eval.assign((JAssignmentTarget)complexReader, (JExpression)expr);
                    }
                    ClassGenerator.HoldingContainer hc = new ClassGenerator.HoldingContainer(e.getMajorType(), complexReader, null, null, false, true);
                    return hc;
                }
                if (seg != null) {
                    eval.add((JStatement)expr.invoke("read").arg(JExpr.lit((int)seg.getArraySegment().getIndex())).arg((JExpression)out.getHolder()));
                } else {
                    eval.add((JStatement)expr.invoke("read").arg((JExpression)out.getHolder()));
                }
            }
            return out;
        }

        private boolean isNullReaderLikely(PathSegment seg, boolean complexOrRepeated) {
            while (seg != null) {
                if (seg.isArray() && !seg.isLastPath()) {
                    return true;
                }
                if (seg.isLastPath() && complexOrRepeated) {
                    return true;
                }
                seg = seg.getChild();
            }
            return false;
        }

        private ClassGenerator.HoldingContainer visitReturnValueExpression(ReturnValueExpression e, ClassGenerator<?> generator) {
            LogicalExpression child = e.getChild();
            ClassGenerator.HoldingContainer hc = (ClassGenerator.HoldingContainer)child.accept(this, generator);
            if (e.isReturnTrueOnOne()) {
                generator.getEvalBlock()._return(hc.getValue().eq(JExpr.lit((int)1)));
            } else {
                generator.getEvalBlock()._return((JExpression)hc.getValue());
            }
            return null;
        }

        @Override
        public ClassGenerator.HoldingContainer visitQuotedStringConstant(ValueExpressions.QuotedString e, ClassGenerator<?> generator) throws RuntimeException {
            TypeProtos.MajorType majorType = Types.required(TypeProtos.MinorType.VARCHAR);
            JBlock setup = generator.getBlock(ClassGenerator.BlockType.SETUP);
            JType holderType = generator.getHolderType(majorType);
            JVar var = generator.declareClassField("string", holderType);
            JExpression stringLiteral = JExpr.lit((String)((String)e.value));
            JInvocation buffer = generator.getMappingSet().getIncoming().invoke("getContext").invoke("getManagedBuffer");
            setup.assign((JAssignmentTarget)var, (JExpression)generator.getModel().ref(ValueHolderHelper.class).staticInvoke("getVarCharHolder").arg((JExpression)buffer).arg(stringLiteral));
            return new ClassGenerator.HoldingContainer(majorType, var, null, null);
        }

        @Override
        public ClassGenerator.HoldingContainer visitIntervalDayConstant(ValueExpressions.IntervalDayExpression e, ClassGenerator<?> generator) throws RuntimeException {
            TypeProtos.MajorType majorType = Types.required(TypeProtos.MinorType.INTERVALDAY);
            JBlock setup = generator.getBlock(ClassGenerator.BlockType.SETUP);
            JType holderType = generator.getHolderType(majorType);
            JVar var = generator.declareClassField("intervalday", holderType);
            JExpression dayLiteral = JExpr.lit((int)e.getIntervalDay());
            JExpression millisLiteral = JExpr.lit((int)e.getIntervalMillis());
            setup.assign((JAssignmentTarget)var, (JExpression)generator.getModel().ref(ValueHolderHelper.class).staticInvoke("getIntervalDayHolder").arg(dayLiteral).arg(millisLiteral));
            return new ClassGenerator.HoldingContainer(majorType, var, null, null);
        }

        @Override
        public ClassGenerator.HoldingContainer visitDecimal9Constant(ValueExpressions.Decimal9Expression e, ClassGenerator<?> generator) throws RuntimeException {
            TypeProtos.MajorType majorType = e.getMajorType();
            JBlock setup = generator.getBlock(ClassGenerator.BlockType.SETUP);
            JType holderType = generator.getHolderType(majorType);
            JVar var = generator.declareClassField("dec9", holderType);
            JExpression valueLiteral = JExpr.lit((int)e.getIntFromDecimal());
            JExpression scaleLiteral = JExpr.lit((int)e.getScale());
            JExpression precisionLiteral = JExpr.lit((int)e.getPrecision());
            setup.assign((JAssignmentTarget)var, (JExpression)generator.getModel().ref(ValueHolderHelper.class).staticInvoke("getDecimal9Holder").arg(valueLiteral).arg(scaleLiteral).arg(precisionLiteral));
            return new ClassGenerator.HoldingContainer(majorType, var, null, null);
        }

        @Override
        public ClassGenerator.HoldingContainer visitDecimal18Constant(ValueExpressions.Decimal18Expression e, ClassGenerator<?> generator) throws RuntimeException {
            TypeProtos.MajorType majorType = e.getMajorType();
            JBlock setup = generator.getBlock(ClassGenerator.BlockType.SETUP);
            JType holderType = generator.getHolderType(majorType);
            JVar var = generator.declareClassField("dec18", holderType);
            JExpression valueLiteral = JExpr.lit((long)e.getLongFromDecimal());
            JExpression scaleLiteral = JExpr.lit((int)e.getScale());
            JExpression precisionLiteral = JExpr.lit((int)e.getPrecision());
            setup.assign((JAssignmentTarget)var, (JExpression)generator.getModel().ref(ValueHolderHelper.class).staticInvoke("getDecimal18Holder").arg(valueLiteral).arg(scaleLiteral).arg(precisionLiteral));
            return new ClassGenerator.HoldingContainer(majorType, var, null, null);
        }

        @Override
        public ClassGenerator.HoldingContainer visitDecimal28Constant(ValueExpressions.Decimal28Expression e, ClassGenerator<?> generator) throws RuntimeException {
            TypeProtos.MajorType majorType = e.getMajorType();
            JBlock setup = generator.getBlock(ClassGenerator.BlockType.SETUP);
            JType holderType = generator.getHolderType(majorType);
            JVar var = generator.declareClassField("dec28", holderType);
            JExpression stringLiteral = JExpr.lit((String)e.getBigDecimal().toString());
            setup.assign((JAssignmentTarget)var, (JExpression)generator.getModel().ref(ValueHolderHelper.class).staticInvoke("getDecimal28Holder").arg(stringLiteral));
            return new ClassGenerator.HoldingContainer(majorType, var, null, null);
        }

        @Override
        public ClassGenerator.HoldingContainer visitDecimal38Constant(ValueExpressions.Decimal38Expression e, ClassGenerator<?> generator) throws RuntimeException {
            TypeProtos.MajorType majorType = e.getMajorType();
            JBlock setup = generator.getBlock(ClassGenerator.BlockType.SETUP);
            JType holderType = generator.getHolderType(majorType);
            JVar var = generator.declareClassField("dec38", holderType);
            JExpression stringLiteral = JExpr.lit((String)e.getBigDecimal().toString());
            setup.assign((JAssignmentTarget)var, (JExpression)generator.getModel().ref(ValueHolderHelper.class).staticInvoke("getVarCharHolder").arg(stringLiteral));
            return new ClassGenerator.HoldingContainer(majorType, var, null, null);
        }

        @Override
        public ClassGenerator.HoldingContainer visitCastExpression(CastExpression e, ClassGenerator<?> value) throws RuntimeException {
            throw new UnsupportedOperationException("CastExpression is not expected here. It should have been converted to FunctionHolderExpression in materialization");
        }

        @Override
        public ClassGenerator.HoldingContainer visitConvertExpression(ConvertExpression e, ClassGenerator<?> value) throws RuntimeException {
            String convertFunctionName = e.getConvertFunction() + e.getEncodingType();
            ArrayList<LogicalExpression> newArgs = Lists.newArrayList();
            newArgs.add(e.getInput());
            FunctionCall fc = new FunctionCall(convertFunctionName, newArgs, e.getPosition());
            return (ClassGenerator.HoldingContainer)fc.accept(this, value);
        }

        private ClassGenerator.HoldingContainer visitBooleanAnd(BooleanOperator op, ClassGenerator<?> generator) {
            ClassGenerator.HoldingContainer out = generator.declare(op.getMajorType());
            JLabel label = generator.getEvalBlockLabel("AndOP");
            JBlock eval = generator.getEvalBlock().block();
            generator.nestEvalBlock(eval);
            ClassGenerator.HoldingContainer arg = null;
            Object e = null;
            for (int i = 0; i < op.args.size(); ++i) {
                arg = (ClassGenerator.HoldingContainer)((LogicalExpression)op.args.get(i)).accept(this, generator);
                JBlock earlyExit = null;
                if (arg.isOptional()) {
                    earlyExit = eval._if(arg.getIsSet().eq(JExpr.lit((int)1)).cand(arg.getValue().ne(JExpr.lit((int)1))))._then();
                    e = e == null ? arg.getIsSet() : e.mul((JExpression)arg.getIsSet());
                } else {
                    earlyExit = eval._if(arg.getValue().ne(JExpr.lit((int)1)))._then();
                }
                if (out.isOptional()) {
                    earlyExit.assign((JAssignmentTarget)out.getIsSet(), JExpr.lit((int)1));
                }
                earlyExit.assign((JAssignmentTarget)out.getValue(), JExpr.lit((int)0));
                earlyExit._break(label);
            }
            if (out.isOptional()) {
                assert (e != null);
                JConditional notSetJC = eval._if(e.eq(JExpr.lit((int)0)));
                notSetJC._then().assign((JAssignmentTarget)out.getIsSet(), JExpr.lit((int)0));
                JBlock setBlock = notSetJC._else().block();
                setBlock.assign((JAssignmentTarget)out.getIsSet(), JExpr.lit((int)1));
                setBlock.assign((JAssignmentTarget)out.getValue(), JExpr.lit((int)1));
            } else {
                assert (e == null);
                eval.assign((JAssignmentTarget)out.getValue(), JExpr.lit((int)1));
            }
            generator.unNestEvalBlock();
            return out;
        }

        private ClassGenerator.HoldingContainer visitBooleanOr(BooleanOperator op, ClassGenerator<?> generator) {
            ClassGenerator.HoldingContainer out = generator.declare(op.getMajorType());
            JLabel label = generator.getEvalBlockLabel("OrOP");
            JBlock eval = generator.getEvalBlock().block();
            generator.nestEvalBlock(eval);
            ClassGenerator.HoldingContainer arg = null;
            Object e = null;
            for (int i = 0; i < op.args.size(); ++i) {
                arg = (ClassGenerator.HoldingContainer)((LogicalExpression)op.args.get(i)).accept(this, generator);
                JBlock earlyExit = null;
                if (arg.isOptional()) {
                    earlyExit = eval._if(arg.getIsSet().eq(JExpr.lit((int)1)).cand(arg.getValue().eq(JExpr.lit((int)1))))._then();
                    e = e == null ? arg.getIsSet() : e.mul((JExpression)arg.getIsSet());
                } else {
                    earlyExit = eval._if(arg.getValue().eq(JExpr.lit((int)1)))._then();
                }
                if (out.isOptional()) {
                    earlyExit.assign((JAssignmentTarget)out.getIsSet(), JExpr.lit((int)1));
                }
                earlyExit.assign((JAssignmentTarget)out.getValue(), JExpr.lit((int)1));
                earlyExit._break(label);
            }
            if (out.isOptional()) {
                assert (e != null);
                JConditional notSetJC = eval._if(e.eq(JExpr.lit((int)0)));
                notSetJC._then().assign((JAssignmentTarget)out.getIsSet(), JExpr.lit((int)0));
                JBlock setBlock = notSetJC._else().block();
                setBlock.assign((JAssignmentTarget)out.getIsSet(), JExpr.lit((int)1));
                setBlock.assign((JAssignmentTarget)out.getValue(), JExpr.lit((int)0));
            } else {
                assert (e == null);
                eval.assign((JAssignmentTarget)out.getValue(), JExpr.lit((int)0));
            }
            generator.unNestEvalBlock();
            return out;
        }
    }

    private class ExpressionHolder {
        private LogicalExpression expression;
        private GeneratorMapping mapping;
        private MappingSet mappingSet;

        ExpressionHolder(LogicalExpression expression, MappingSet mappingSet) {
            this.expression = expression;
            this.mapping = mappingSet.getCurrentMapping();
            this.mappingSet = mappingSet;
        }

        public int hashCode() {
            return this.expression.accept(new HashVisitor(), null);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ExpressionHolder)) {
                return false;
            }
            ExpressionHolder that = (ExpressionHolder)obj;
            return this.mappingSet == that.mappingSet && this.mapping == that.mapping && this.expression.accept(new EqualityVisitor(), that.expression) != false;
        }
    }
}

