/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.client;

import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.concurrent.TimeUnit;
import oadd.com.beust.jcommander.JCommander;
import oadd.com.beust.jcommander.Parameter;
import oadd.com.beust.jcommander.ParameterException;
import oadd.com.google.common.base.Charsets;
import oadd.com.google.common.base.Preconditions;
import oadd.com.google.common.base.Stopwatch;
import oadd.org.apache.drill.common.config.DrillConfig;
import oadd.org.apache.drill.exec.client.DrillClient;
import oadd.org.apache.drill.exec.client.PrintingResultsListener;
import oadd.org.apache.drill.exec.coord.zk.ZKClusterCoordinator;
import oadd.org.apache.drill.exec.proto.UserBitShared;
import oadd.org.apache.drill.exec.rpc.user.AwaitableUserResultsListener;
import oadd.org.apache.drill.exec.server.Drillbit;
import oadd.org.apache.drill.exec.server.RemoteServiceSet;

public class QuerySubmitter {
    public static void main(String[] args) throws Exception {
        QuerySubmitter submitter = new QuerySubmitter();
        Options o = new Options();
        JCommander jc = null;
        try {
            jc = new JCommander((Object)o, args);
            jc.setProgramName("./submit_plan");
        }
        catch (ParameterException e) {
            System.out.println(e.getMessage());
            String[] valid = new String[]{"-f", "file", "-t", "physical"};
            new JCommander((Object)o, valid).usage();
            System.exit(-1);
        }
        if (o.help) {
            jc.usage();
            System.exit(0);
        }
        System.exit(submitter.submitQuery(o.location, o.queryString, o.planType, o.zk, o.local, o.bits, o.format, o.width));
    }

    public int submitQuery(String planLocation, String queryString, String type, String zkQuorum, boolean local, int bits, String format) throws Exception {
        return this.submitQuery(planLocation, queryString, type, zkQuorum, local, bits, format, 15);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int submitQuery(String planLocation, String queryString, String type, String zkQuorum, boolean local, int bits, String format, int width) throws Exception {
        DrillConfig config = DrillConfig.create();
        DrillClient client = null;
        Preconditions.checkArgument(planLocation != null || queryString != null, "Must provide either query file or query string");
        Preconditions.checkArgument(planLocation == null || queryString == null, "Must provide either query file or query string, not both");
        RemoteServiceSet serviceSet = null;
        Drillbit[] drillbits = null;
        try {
            if (local) {
                serviceSet = RemoteServiceSet.getLocalServiceSet();
                drillbits = new Drillbit[bits];
                for (int i = 0; i < bits; ++i) {
                    drillbits[i] = new Drillbit(config, serviceSet);
                    drillbits[i].run();
                }
                client = new DrillClient(config, serviceSet.getCoordinator());
            } else {
                ZKClusterCoordinator clusterCoordinator = new ZKClusterCoordinator(config, zkQuorum);
                clusterCoordinator.start(10000L);
                client = new DrillClient(config, clusterCoordinator);
            }
            client.connect();
            String plan = queryString == null ? Charsets.UTF_8.decode(ByteBuffer.wrap(Files.readAllBytes(Paths.get(planLocation, new String[0])))).toString() : queryString;
            int n = this.submitQuery(client, plan, type, format, width);
            return n;
        }
        catch (Throwable th) {
            System.err.println("Query Failed due to : " + th.getMessage());
            int n = -1;
            return n;
        }
        finally {
            if (client != null) {
                client.close();
            }
            if (local) {
                for (Drillbit b : drillbits) {
                    b.close();
                }
                serviceSet.close();
            }
        }
    }

    public int submitQuery(DrillClient client, String plan, String type, String format, int width) throws Exception {
        Format outputFormat;
        String[] queries;
        UserBitShared.QueryType queryType;
        switch (type = type.toLowerCase()) {
            case "sql": {
                queryType = UserBitShared.QueryType.SQL;
                queries = plan.trim().split(";");
                break;
            }
            case "logical": {
                queryType = UserBitShared.QueryType.LOGICAL;
                queries = new String[]{plan};
                break;
            }
            case "physical": {
                queryType = UserBitShared.QueryType.PHYSICAL;
                queries = new String[]{plan};
                break;
            }
            default: {
                System.out.println("Invalid query type: " + type);
                return -1;
            }
        }
        switch (format = format.toLowerCase()) {
            case "csv": {
                outputFormat = Format.CSV;
                break;
            }
            case "tsv": {
                outputFormat = Format.TSV;
                break;
            }
            case "table": {
                outputFormat = Format.TABLE;
                break;
            }
            default: {
                System.out.println("Invalid format type: " + format);
                return -1;
            }
        }
        Stopwatch watch = Stopwatch.createUnstarted();
        for (String query : queries) {
            AwaitableUserResultsListener listener = new AwaitableUserResultsListener(new PrintingResultsListener(client.getConfig(), outputFormat, width));
            watch.start();
            client.runQuery(queryType, query, listener);
            int rows = listener.await();
            System.out.println(String.format("%d record%s selected (%f seconds)", rows, rows > 1 ? "s" : "", Float.valueOf((float)watch.elapsed(TimeUnit.MILLISECONDS) / 1000.0f)));
            if (query != queries[queries.length - 1]) {
                System.out.println();
            }
            watch.stop();
            watch.reset();
        }
        return 0;
    }

    public static enum Format {
        TSV,
        CSV,
        TABLE;

    }

    static class Options {
        @Parameter(names={"-f", "--file"}, description="file containing plan", required=false)
        public String location = null;
        @Parameter(names={"-q", "-e", "--query"}, description="query string", required=false)
        public String queryString = null;
        @Parameter(names={"-t", "--type"}, description="type of query, sql/logical/physical", required=true)
        public String planType;
        @Parameter(names={"-z", "--zookeeper"}, description="zookeeper connect string.", required=false)
        public String zk = "localhost:2181";
        @Parameter(names={"-l", "--local"}, description="run query in local mode", required=false)
        public boolean local;
        @Parameter(names={"-b", "--bits"}, description="number of drillbits to run. local mode only", required=false)
        public int bits = 1;
        @Parameter(names={"-h", "--help"}, description="show usage", help=true)
        public boolean help = false;
        @Parameter(names={"--format"}, description="output format, csv,tsv,table", required=false)
        public String format = "table";
        @Parameter(names={"-w", "--width"}, description="max column width", required=false)
        public int width = 15;

        Options() {
        }
    }
}

