/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.common.expression.visitors;

import oadd.org.apache.drill.common.expression.BooleanOperator;
import oadd.org.apache.drill.common.expression.CastExpression;
import oadd.org.apache.drill.common.expression.ConvertExpression;
import oadd.org.apache.drill.common.expression.FunctionCall;
import oadd.org.apache.drill.common.expression.FunctionHolderExpression;
import oadd.org.apache.drill.common.expression.IfExpression;
import oadd.org.apache.drill.common.expression.LogicalExpression;
import oadd.org.apache.drill.common.expression.NullExpression;
import oadd.org.apache.drill.common.expression.SchemaPath;
import oadd.org.apache.drill.common.expression.TypedNullConstant;
import oadd.org.apache.drill.common.expression.ValueExpressions;
import oadd.org.apache.drill.common.expression.visitors.ExprVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractExprVisitor<T, VAL, EXCEP extends Exception>
implements ExprVisitor<T, VAL, EXCEP> {
    static final Logger logger = LoggerFactory.getLogger(AbstractExprVisitor.class);

    @Override
    public T visitFunctionCall(FunctionCall call, VAL value) throws EXCEP {
        return this.visitUnknown(call, value);
    }

    @Override
    public T visitFunctionHolderExpression(FunctionHolderExpression holder, VAL value) throws EXCEP {
        return this.visitUnknown(holder, value);
    }

    @Override
    public T visitIfExpression(IfExpression ifExpr, VAL value) throws EXCEP {
        return this.visitUnknown(ifExpr, value);
    }

    @Override
    public T visitBooleanOperator(BooleanOperator op, VAL value) throws EXCEP {
        return this.visitUnknown(op, value);
    }

    @Override
    public T visitSchemaPath(SchemaPath path, VAL value) throws EXCEP {
        return this.visitUnknown(path, value);
    }

    @Override
    public T visitFloatConstant(ValueExpressions.FloatExpression fExpr, VAL value) throws EXCEP {
        return this.visitUnknown(fExpr, value);
    }

    @Override
    public T visitIntConstant(ValueExpressions.IntExpression intExpr, VAL value) throws EXCEP {
        return this.visitUnknown(intExpr, value);
    }

    @Override
    public T visitLongConstant(ValueExpressions.LongExpression intExpr, VAL value) throws EXCEP {
        return this.visitUnknown(intExpr, value);
    }

    @Override
    public T visitDecimal9Constant(ValueExpressions.Decimal9Expression decExpr, VAL value) throws EXCEP {
        return this.visitUnknown(decExpr, value);
    }

    @Override
    public T visitDecimal18Constant(ValueExpressions.Decimal18Expression decExpr, VAL value) throws EXCEP {
        return this.visitUnknown(decExpr, value);
    }

    @Override
    public T visitDecimal28Constant(ValueExpressions.Decimal28Expression decExpr, VAL value) throws EXCEP {
        return this.visitUnknown(decExpr, value);
    }

    @Override
    public T visitDecimal38Constant(ValueExpressions.Decimal38Expression decExpr, VAL value) throws EXCEP {
        return this.visitUnknown(decExpr, value);
    }

    @Override
    public T visitDateConstant(ValueExpressions.DateExpression intExpr, VAL value) throws EXCEP {
        return this.visitUnknown(intExpr, value);
    }

    @Override
    public T visitTimeConstant(ValueExpressions.TimeExpression intExpr, VAL value) throws EXCEP {
        return this.visitUnknown(intExpr, value);
    }

    @Override
    public T visitTimeStampConstant(ValueExpressions.TimeStampExpression intExpr, VAL value) throws EXCEP {
        return this.visitUnknown(intExpr, value);
    }

    @Override
    public T visitIntervalYearConstant(ValueExpressions.IntervalYearExpression intExpr, VAL value) throws EXCEP {
        return this.visitUnknown(intExpr, value);
    }

    @Override
    public T visitIntervalDayConstant(ValueExpressions.IntervalDayExpression intExpr, VAL value) throws EXCEP {
        return this.visitUnknown(intExpr, value);
    }

    @Override
    public T visitDoubleConstant(ValueExpressions.DoubleExpression dExpr, VAL value) throws EXCEP {
        return this.visitUnknown(dExpr, value);
    }

    @Override
    public T visitBooleanConstant(ValueExpressions.BooleanExpression e, VAL value) throws EXCEP {
        return this.visitUnknown(e, value);
    }

    @Override
    public T visitQuotedStringConstant(ValueExpressions.QuotedString e, VAL value) throws EXCEP {
        return this.visitUnknown(e, value);
    }

    @Override
    public T visitCastExpression(CastExpression e, VAL value) throws EXCEP {
        return this.visitUnknown(e, value);
    }

    @Override
    public T visitConvertExpression(ConvertExpression e, VAL value) throws EXCEP {
        return this.visitUnknown(e, value);
    }

    @Override
    public T visitNullConstant(TypedNullConstant e, VAL value) throws EXCEP {
        return this.visitUnknown(e, value);
    }

    @Override
    public T visitNullExpression(NullExpression e, VAL value) throws EXCEP {
        return this.visitUnknown(e, value);
    }

    @Override
    public T visitUnknown(LogicalExpression e, VAL value) throws EXCEP {
        throw new UnsupportedOperationException(String.format("Expression of type %s not handled by visitor type %s.", e.getClass().getCanonicalName(), this.getClass().getCanonicalName()));
    }
}

