/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.common.expression;

import java.lang.reflect.Constructor;
import java.lang.reflect.Type;
import java.util.List;
import oadd.com.google.common.collect.ImmutableMap;
import oadd.com.google.common.reflect.TypeToken;
import oadd.org.apache.drill.common.expression.FunctionName;
import oadd.org.apache.drill.common.expression.LogicalExpression;
import oadd.org.apache.drill.common.expression.visitors.ExpressionValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpressionFunction {
    static final Logger logger = LoggerFactory.getLogger(ExpressionFunction.class);
    static final Type EXPR_LIST = new TypeToken<List<LogicalExpression>>(){}.getType();
    private static final Class<?>[] FUNCTIONS = new Class[0];
    private static final ImmutableMap<String, Constructor<LogicalExpression>> FUNCTION_MAP;

    public static LogicalExpression create(String functionName, List<LogicalExpression> expressions) throws ExpressionValidationException {
        if (!FUNCTION_MAP.containsKey(functionName)) {
            throw new ExpressionValidationException(String.format("Unknown function with name '%s'", functionName));
        }
        try {
            return FUNCTION_MAP.get(functionName).newInstance(expressions);
        }
        catch (Exception e) {
            throw new ExpressionValidationException("Failure while attempting to build type of " + functionName, e);
        }
    }

    static {
        ImmutableMap.Builder<String, Constructor<?>> builder = ImmutableMap.builder();
        for (Class<?> c : FUNCTIONS) {
            if (!LogicalExpression.class.isAssignableFrom(c)) {
                logger.error("The provided Class [{}] does not derive from LogicalExpression.  Skipping inclusion in registry.", (Object)c);
                continue;
            }
            FunctionName fn = c.getAnnotation(FunctionName.class);
            if (fn == null) {
                logger.error("The provided Class [{}] did not have a FunctionName annotation.  Skipping inclusion in registry.", (Object)c);
                continue;
            }
            String name = fn.value();
            try {
                Constructor<?> m = c.getConstructor(List.class);
                if (!EXPR_LIST.equals(m.getGenericParameterTypes()[0])) {
                    logger.error("The constructor for each function must have a argument list that only contains a List<LogicalExpression>.  The class[{}] has an inccorect List<{}> argument.", (Object)c, (Object)m.getGenericParameterTypes()[0]);
                    continue;
                }
                builder.put(name, m);
            }
            catch (Exception e) {
                logger.error("Failure while attempting to retrieve Logical Expression list constructor on class [{}].  Functions must have one of these.", (Object)c, (Object)e);
            }
        }
        FUNCTION_MAP = builder.build();
    }
}

