/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.curator.x.discovery.details;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ThreadFactory;
import oadd.com.google.common.collect.Lists;
import oadd.org.apache.curator.x.discovery.DownInstancePolicy;
import oadd.org.apache.curator.x.discovery.InstanceFilter;
import oadd.org.apache.curator.x.discovery.ProviderStrategy;
import oadd.org.apache.curator.x.discovery.ServiceCache;
import oadd.org.apache.curator.x.discovery.ServiceInstance;
import oadd.org.apache.curator.x.discovery.ServiceProvider;
import oadd.org.apache.curator.x.discovery.details.DownInstanceManager;
import oadd.org.apache.curator.x.discovery.details.FilteredInstanceProvider;
import oadd.org.apache.curator.x.discovery.details.InstanceProvider;
import oadd.org.apache.curator.x.discovery.details.ServiceDiscoveryImpl;

public class ServiceProviderImpl<T>
implements ServiceProvider<T> {
    private final ServiceCache<T> cache;
    private final InstanceProvider<T> instanceProvider;
    private final ServiceDiscoveryImpl<T> discovery;
    private final ProviderStrategy<T> providerStrategy;
    private final DownInstanceManager<T> downInstanceManager;

    public ServiceProviderImpl(ServiceDiscoveryImpl<T> discovery, String serviceName, ProviderStrategy<T> providerStrategy, ThreadFactory threadFactory, List<InstanceFilter<T>> filters, DownInstancePolicy downInstancePolicy) {
        this.discovery = discovery;
        this.providerStrategy = providerStrategy;
        this.downInstanceManager = new DownInstanceManager(downInstancePolicy);
        this.cache = discovery.serviceCacheBuilder().name(serviceName).threadFactory(threadFactory).build();
        ArrayList<InstanceFilter<T>> localFilters = Lists.newArrayList(filters);
        localFilters.add(this.downInstanceManager);
        this.instanceProvider = new FilteredInstanceProvider<T>(this.cache, localFilters);
    }

    @Override
    public void start() throws Exception {
        this.cache.start();
        this.discovery.providerOpened(this);
    }

    @Override
    public void close() throws IOException {
        this.discovery.providerClosed(this);
        this.cache.close();
    }

    @Override
    public Collection<ServiceInstance<T>> getAllInstances() throws Exception {
        return this.instanceProvider.getInstances();
    }

    @Override
    public ServiceInstance<T> getInstance() throws Exception {
        return this.providerStrategy.getInstance(this.instanceProvider);
    }

    @Override
    public void noteError(ServiceInstance<T> instance) {
        this.downInstanceManager.add(instance);
    }
}

