/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.curator.framework.recipes.barriers;

import java.util.concurrent.TimeUnit;
import oadd.org.apache.curator.framework.CuratorFramework;
import oadd.org.apache.curator.framework.api.BackgroundPathable;
import oadd.org.apache.curator.utils.PathUtils;
import oadd.org.apache.zookeeper.KeeperException;
import oadd.org.apache.zookeeper.WatchedEvent;
import oadd.org.apache.zookeeper.Watcher;

public class DistributedBarrier {
    private final CuratorFramework client;
    private final String barrierPath;
    private final Watcher watcher = new Watcher(){

        @Override
        public void process(WatchedEvent event) {
            DistributedBarrier.this.notifyFromWatcher();
        }
    };

    public DistributedBarrier(CuratorFramework client, String barrierPath) {
        this.client = client;
        this.barrierPath = PathUtils.validatePath(barrierPath);
    }

    public synchronized void setBarrier() throws Exception {
        try {
            this.client.create().creatingParentsIfNeeded().forPath(this.barrierPath);
        }
        catch (KeeperException.NodeExistsException nodeExistsException) {
            // empty catch block
        }
    }

    public synchronized void removeBarrier() throws Exception {
        try {
            this.client.delete().forPath(this.barrierPath);
        }
        catch (KeeperException.NoNodeException noNodeException) {
            // empty catch block
        }
    }

    public synchronized void waitOnBarrier() throws Exception {
        this.waitOnBarrier(-1L, null);
    }

    public synchronized boolean waitOnBarrier(long maxWait, TimeUnit unit) throws Exception {
        boolean result;
        long startMs = System.currentTimeMillis();
        boolean hasMaxWait = unit != null;
        long maxWaitMs = hasMaxWait ? TimeUnit.MILLISECONDS.convert(maxWait, unit) : Long.MAX_VALUE;
        while (true) {
            boolean bl = result = ((BackgroundPathable)this.client.checkExists().usingWatcher(this.watcher)).forPath(this.barrierPath) == null;
            if (result) break;
            if (hasMaxWait) {
                long elapsed = System.currentTimeMillis() - startMs;
                long thisWaitMs = maxWaitMs - elapsed;
                if (thisWaitMs <= 0L) break;
                this.wait(thisWaitMs);
                continue;
            }
            this.wait();
        }
        return result;
    }

    private synchronized void notifyFromWatcher() {
        this.notifyAll();
    }
}

